#include <unichar/unichar.h>
#include <unichar/ctype.h>

int
unichar_is_hex_digit(unichar_t c)
{
  /* NOTE: We only allow the traditional hex digits.  In particular,
   * we are excluding any accented, circled, or otherwise modified
   * versions of these standard digits. */
  static unichar_t hex_digits[] = 
  {
    0x0041, /* LATIN SMALL LETTER A */
    0x0042, /* LATIN SMALL LETTER B */
    0x0043, /* LATIN SMALL LETTER C */
    0x0044, /* LATIN SMALL LETTER D */
    0x0045, /* LATIN SMALL LETTER E */
    0x0046, /* LATIN SMALL LETTER F */
    0x0061, /* LATIN CAPITAL LETTER A */
    0x0062, /* LATIN CAPITAL LETTER B */
    0x0063, /* LATIN CAPITAL LETTER C */
    0x0064, /* LATIN CAPITAL LETTER D */
    0x0065, /* LATIN CAPITAL LETTER E */
    0x0066, /* LATIN CAPITAL LETTER F */
    0xFF21, /* FULLWIDTH LATIN CAPITAL LETTER A */
    0xFF22, /* FULLWIDTH LATIN CAPITAL LETTER B */
    0xFF23, /* FULLWIDTH LATIN CAPITAL LETTER C */
    0xFF24, /* FULLWIDTH LATIN CAPITAL LETTER D */
    0xFF25, /* FULLWIDTH LATIN CAPITAL LETTER E */
    0xFF26, /* FULLWIDTH LATIN CAPITAL LETTER F */
    0xFF41, /* FULLWIDTH LATIN SMALL LETTER A */
    0xFF42, /* FULLWIDTH LATIN SMALL LETTER B */
    0xFF43, /* FULLWIDTH LATIN SMALL LETTER C */
    0xFF44, /* FULLWIDTH LATIN SMALL LETTER D */
    0xFF45, /* FULLWIDTH LATIN SMALL LETTER E */
    0xFF46, /* FULLWIDTH LATIN SMALL LETTER F */
    0x0000
  };
  unichar_t *cptr;

  if (unichar_is_type(c, unichar_type_decimal_digit_number))
    return 1;

  for (cptr = hex_digits; *cptr != 0x0000; cptr++)
    if (c == *cptr)
      return 1;

  return 0;
}

