#include <unichar/unichar.h>
#include <unichar/string.h>

/* Append FROM to TO.  We assume that both FROM and TO are
 * nul-terminated! */

unichar_t *
unichar_strcat(unichar_t *to, const unichar_t *from)
{
  register unichar_t *thence = to;
  register const unichar_t *whence = from;

  /* Skip to the end of TO. */
  while (*(thence++) != 0x0000);

  /* But we went one character too far in the previous line. */
  --thence;

  /* Now just do like `unichar_strcpy()'. */
  while ((*(thence++) = *(whence++)) != 0x0000);

  return to;
}
