#include <stdarg.h>
#include <unichar/unichar.h>
#include <unichar/string.h>

unichar_t *
unichar_strcatn(unichar_t *dest, ...)
{
  va_list ap;
  register unichar_t *thence = dest;
  register unichar_t *whence;

  /* Skip to the end of TO. */
  while (*(thence++) != 0x0000);

  /* But we went one character too far in the previous line. */
  --thence;

  /* Now just do like `unichar_strcpy()'. */

  va_start(ap, dest);

  while ((whence = va_arg(ap, unichar_t *)) != 0)
  {
    while ((*(thence++) = *(whence++)) != 0x0000);
    --thence;
  }

  va_end(ap);

  return dest;
}
