#include <unichar/unichar.h>
#include <unichar/string.h>

/* Return (a pointer to) the first occurrence of CH in S.  Return
 * `0' if CH does not occur in S. */

unichar_t *
unichar_strchr(const unichar_t *s, unichar_t ch)
{
  register const unichar_t *t = s;
  register unichar_t c;

  while ((c = *(t++)) != 0x0000)
    if (c == ch)
      return (unichar_t *)(--t);

  if (ch == 0x0000)
    return (unichar_t *)(--t);

  return 0;
}

