#include <unichar/unichar.h>
#include <unichar/string.h>

/* WARNING: `unichar_strcmp()' performs an encoding-based lexicographical
 * comparison of the two character strings S1 and S2.  This is, in
 * general, absolutely useless for alphabetizing or like
 * applications. */

/* WARNING: Collating (e.g., alphabetizing) international strings is
 * going to have to wait a little while.  Some decisions need to be
 * made. */

/* Perform a lexicographical comparison of S1 and S2. */

int
unichar_strcmp(register const unichar_t *s1, register const unichar_t *s2)
{
  /* FIXME: Should I do this first check?  It seems out of the spirit
   * of the function, but would often make this comparison a trivial
   * matter to evaluate. */
  if (s1 == s2)
  {
    return 0;
  }
  else
  {
  register unichar_t c1;
  register unichar_t c2;

  while ((c1 = *(s1++)) == (c2 = *(s2++)))
    if (c1 == 0x0000)
      return 0;

  return (c1 - c2);
  }
}
