#include <unichar/unichar.h>
#include <unichar/string.h>

/* FIXME: I am not sure what to do here.  Since ``case-insensitive''
 * is not an internationally well-defined character concept, it is
 * quite unclear how an algorithm for this function should go.  In
 * particular, the standard ``push everything to lowercase'' for
 * American/European locales just won't cut it. */

/* HOWEVER: The Unicode Standard recommends to simply perform the
 * standard ``push everything to lowercase''.  The idea is that this
 * is good enough for a generic case-insensitive comparison.  For a
 * more detailed, useful comparison, the comparison algorithm must
 * begin to take into account the language-specific nuances inherent
 * in the characters. */

/* Perform a case-insensitive lexicographical comparison of the
 * universial character strings S1 and S2. */

int
unichar_strcasecmp(const unichar_t *s1, const unichar_t *s2)
{
  register unichar_t c1;
  register unichar_t c2;

  while ((c1 = unichar_to_lowercase(*(s1++)))
	 == (c2 = unichar_to_lowercase(*(s2++))))
    if (c1 == 0x0000)
      return 0;

  return (c1 - c2);
}


