#include <unichar/unichar.h>
#include <unichar/string.h>

/* Return the length of the largest inital segment of TARGET which
 * contains no characters from REJECT.  */

static inline int
_unichar_cins(unichar_t c, const unichar_t *s)
{
  register const unichar_t *t = s;

  while (*t != 0x0000)
    if (c == *(t++))
      return 1;

  return 0;
}

size_t
unichar_strcspn(const unichar_t *target, const unichar_t *reject)
{
  register size_t i;

  for (i = 0; !_unichar_cins(target[i], reject); i++);

  return i;
}

