#include <errno.h>
#include <unichar/unichar.h>
#include <unichar/string.h>

/* Duplicate ORIG. */

unichar_t *
unichar_strdup(const unichar_t *orig)
{
  /* SIZE is the size (in bytes) of ORIG, including the terminating
   * zero (0x0000) character. */
  register size_t size = (unichar_strlen(orig) + 1) * sizeof(unichar_t);

  /* Set aside space for the duplicate, FORGERY. */
  register unichar_t *forgery = (unichar_t *) malloc(size);

  if (forgery == 0)
    errno = ENOMEM;
  else
    /* Copy all SIZE bytes of ORIG into FORGERY. */
    memcpy(forgery, orig, size);

  return forgery;
}
