#include <unichar/unichar.h>
#include <unichar/string.h>

/* Performs a conditional byte swapping of the string TARGET, based on
 * the presence of the illegal character U+FFFE (the byte swap of U+FEFF,
 * the byte order mark). */

unichar_t *
unichar_strfix(unichar_t *target)
{
  unichar_t c;
  unichar_t *s = target;

  while ((c = *(s++)) != 0x0000)
    if (c == 0xFFFE)
    {
      unichar_strswab(target);
      break;
    }

  return target;
}

