#include <unichar/unichar.h>
#include <unichar/string.h>

/* Return the length in characters of the (zero-terminated) character
 * string TARGET. */

size_t
unichar_strlen(const unichar_t *target)
{
  /* FIXME: Here, we operate under the assumption that a unichar is
   * exactly two chars wide.  Is this a problem?  I.e., is there a
   * machine where a char isn't 8 bits? */
  register size_t i;
	register char *ctarget;

  for (i = 1, ctarget = (char *)target; ; i += 2)
  {
    /* FIXME: Add a byte order check, and invert the algorithm
     * accordingly?  The byte order check would probably be too
     * expensive.  Most strings will probably already be in the
     * right order. */
    /* We check the odd bytes, making the assumption that the byte
     * order is 0xFEFF; in particular, under this assumption, all
     * ASCII and ISO-Latin characters would be in the odd bytes.  This
     * bias reflects my supposition that 8-bit characters are the most
     * common in character strings.  Note that this bias does not
     * affect the algorithm's effectiveness at handling 16-bit
     * characters in the strings. */
    if (ctarget[i] == '\0' && ctarget[i - 1] == '\0')
      return i / 2;
  }
}
