#include <unichar/unichar.h>
#include <unichar/string.h>

/* Append the first NUM characters of FROM to TO.  */

unichar_t *
unichar_strncat(unichar_t *to, const unichar_t *from, size_t num)
{
  register unichar_t *thence = to;
  register const unichar_t *whence = from;
  register size_t i = num + 1;

  /* Skip to the end of TO. */
  while (*(thence++) != 0x0000);

  /* But we went one character too far in the previous line. */
  --thence;

  /* Now just do like `unichar_strncpy()'. */
  while ((--i != 0) && ((*(thence++) = *(whence++)) != 0x0000));

  /* We need to be sure that we zero-terminate TO. */
  if (i == 0)
    *thence = 0x0000;

  return to;
}
