#include <unichar/unichar.h>
#include <unichar/string.h>

/* WARNING: `unichar_strncmp()' performs an encoding-based lexicographical
 * comparison of the first N characters of the two character strings
 * S1 and S2.  This is, in general, absolutely useless for
 * alphabetizing or like applications. */

/* WARNING: Collating (e.g., alphabetizing) international strings is
 * going to have to wait a little while.  Some decisions need to be
 * made. */

/* Perform a lexicographical comparison of the first N characters of
 * S1 and S2. */

int
unichar_strncmp(register const unichar_t *s1,
                register const unichar_t *s2, size_t num)
{
  register unichar_t c1;
  register unichar_t c2;
  register size_t i = num + 1;

  while ((--i != 0) && ((c1 = *(s1++)) == (c2 = *(s2++))))
    if (c1 == 0x0000)
      return 0;

  if (i == 0)
    return 0;

  return (c1 - c2);
}

