#include <unichar/unichar.h>
#include <unichar/string.h>

/* Return (a pointer to) the last occurrence of CH in S.  Return
 * `0' if CH does not occur in S. */

unichar_t *
unichar_strrchr(const unichar_t *s, unichar_t ch)
{
  size_t len = unichar_strlen(s);

  if (ch == 0x0000)
    return (unichar_t *)(s + len);
  else
  {
    register const unichar_t *t = s + len;
    register unichar_t c;

    while (s <= --t)
      if ((c = *t) == ch)
        return (unichar_t *)t;

    return 0;
  }
}

