#include <unichar/unichar.h>
#include <unichar/string.h>

/* Return the length of the maximum initial segment of TARGET which
 * contains only characters in ACCEPT.  */

static inline int
_unichar_cins(register unichar_t c, register const unichar_t *s)
{
  while (*s != 0x0000)
    if (c == *(s++))
      return 1;

  return 0;
}

size_t
unichar_strspn(register const unichar_t *target,
               register const unichar_t *accept)
{
  register size_t i;

  for (i = 0; _unichar_cins(target[i], accept); i++);

  return i;
}
