#include <unichar/unichar.h>
#include <unichar/string.h>

/* Return the first occurrence of NEEDLE in HAYSTACK.  */

unichar_t *
unichar_strstr(const unichar_t *haystack, const unichar_t *needle)
{
  size_t haystack_len = unichar_strlen(haystack);
  size_t needle_len = unichar_strlen(needle);
  register size_t i;
  register size_t j;

  if (needle_len == 0)
    return (unichar_t *)haystack;

  if (haystack_len < needle_len)
    return 0;

  for (i = 0; i < haystack_len - needle_len + 1; i++)
  {
    for (j = 0;
         j < needle_len && haystack[i + j] == needle[j];
         j++);
    if (j == needle_len)
      return (unichar_t *)(haystack + i);
  }

  return 0;
}



