#include <unichar/unichar.h>
#include <unichar/string.h>

static unichar_t *old_str = 0;

/* Parse STR into tokens separated by characters in DELIMS.  If STR is
 * `0', the last string `unichar_strtok()' was called with is used. */

unichar_t *
unichar_strtok(register unichar_t *str, const unichar_t *delims)
{
  /* NOTE: This is a GCC-ism. */
  str = str ?: old_str;

  if (str == 0)
  {
    errno = EINVAL;
    return 0;
  }
  else
  {
    /* Push past any members of DELIMS at the beginning of STR. */
    str += unichar_strspn(str, delims);

    /* If we pushed off of the end, then this is it, baby. */
    if (*str == 0x0000)
    {
      old_str = 0;
      return 0;
    }
    else
    {
      /* Save our place here at the beginning of the token. */
      unichar_t *token = str;

      /* Scan ahead to the next member of DELIMS. */
      str = unichar_strpbrk(str, delims);

      if (str == 0)
      {
        /* This token is the last in STR. */
        old_str = 0;
      }
      else
      {
        /* Zero-terminate the token. */
        *str = 0x0000;

        /* Set OLD_STR ahead one for the next go 'round. */
        old_str = str + 1;
      }

      /* Return a pointer to the token. */
      return token;
    }
  }
}
