#include <limits.h>
#include <unichar/unichar.h>
#include <unichar/ctype.h>
#include <unichar/string.h>

/* FIXME: Finish this. */

/* Convert NPTR to an `unsigned long int' or `long int' in base BASE.
 * If BASE is 0 the base is determined by the presence of a leading
 * zero, indicating octal or a leading "0x" or "0X", indicating
 * hexadecimal.  If BASE is < 2 or > 36, it is reset to 10.  If END
 * is not 0, a pointer to the character after the last one
 * converted is stored in *END.  */

#ifdef __UNSIGNED__
unsigned long int
unichar_strtoul(const unichar_t *str, unichar_t **end, int base)
#else /* !__UNSIGNED__ */
long int
unichar_strtol(const unichar_t *str, unichar_t **end, int base)
#endif /* __UNSIGNED__ */
{
  int is_negative;
  unsigned long int cutoff;
  unsigned int cutlim;
  unsigned long int i;
  const unichar_t *s;
  unichar_t c;
  const unichar_t *save;
  int overflow;

  if (base < 0 || base == 1 || base > 36)
    base = 10;

  s = str;

  /* Skip white space.  */
  while (unichar_is_type(*s, unichar_type_space_separator))
    ++s;
  if (*s == 0x0000)
    goto NOTHING_TO_DO;

  /* Check for a sign.  */
  if (*s == '-')
    {
      is_negative = 1;
      ++s;
    }
  else if (*s == '+')
    {
      is_negative = 0;
      ++s;
    }
  else
    is_negative = 0;

  if (base == 16 && s[0] == '0' && toupper(s[1]) == 'X')
    s += 2;

  /* If BASE is zero, figure it out ourselves.  */
  if (base == 0)
    if (*s == '0')
      {
	if (toupper (s[1]) == 'X')
	  {
	    s += 2;
	    base = 16;
	  }
	else
	  base = 8;
      }
    else
      base = 10;

  /* Save the pointer so we can check later if anything happened.  */
  save = s;

  cutoff = ULONG_MAX / (unsigned long int) base;
  cutlim = ULONG_MAX % (unsigned long int) base;

  overflow = 0;
  i = 0;

  for (c = *s; c != 0x0000; c = *++s)
    {
      if (unichar_is_type(c, unichar_type_decimal_digit_number))
	c = unichar_decimal_digit_value(c);
      else if (isalpha(c))
	c = toupper (c) - 'A' + 10;
      else
	break;
      if (c >= base)
	break;
      /* Check for overflow.  */
      if (i > cutoff || (i == cutoff && c > cutlim))
	overflow = 1;
      else
	{
	  i *= (unsigned long int) base;
	  i += c;
	}
    }

  /* Check if anything actually happened. */
  if (s == save)
    goto NOTHING_TO_DO;

  /* Store in END the address of one character past the last
   * character we converted. */
  if (end != 0)
    *end = (unichar_t *) s;

#ifndef __UNSIGNED__
  /* Check for a value that is within the range of `unsigned long
   * int', but outside the range of `long int'. */
  if (i > (is_negative ?
	   -(unsigned long int) LONG_MIN : (unsigned long int) LONG_MAX))
    overflow = 1;
#endif /* __UNSIGNED__ */

  if (overflow)
    {
      errno = ERANGE;
#ifdef __UNSIGNED__
      return ULONG_MAX;
#else /* !__UNSIGNED__ */
      return (is_negative ? LONG_MIN : LONG_MAX);
#endif /* __UNSIGNED__ */
    }

  /* Return the result of the appropriate sign.  */
  return (is_negative ? -i : i);

NOTHING_TO_DO:
  /* There was no number to convert.  */
  if (end != 0)
    *end = (unichar_t *) str;
  return 0L;
}
