#ifndef __ctype_h_UNICHAR_INCLUDE
#define __ctype_h_UNICHAR_INCLUDE 1

#include <unichar/unichar.h>

typedef enum _unichar_type unichar_type_t;
enum _unichar_type
{
  unichar_type_unknown              = 0x00000000,
  unichar_type_invalid              = 0x00000001,
    unichar_type_invalid_character    = 0x00000001,
  unichar_type_letter               = 0x0000003e,
    unichar_type_uppercase_letter     = 0x00000002,
    unichar_type_lowercase_letter     = 0x00000004,
    unichar_type_titlecase_letter     = 0x00000008,
    unichar_type_modifier_letter      = 0x00000010,
    unichar_type_other_letter         = 0x00000020,
  unichar_type_mark                 = 0x000000c0,
    unichar_type_non_spacing_mark     = 0x00000040,
    unichar_type_combining_mark       = 0x00000080,
  unichar_type_number               = 0x00000300,
    unichar_type_decimal_digit_number = 0x00000100,
    unichar_type_other_number         = 0x00000200,
  unichar_type_other                = 0x00000400,
    unichar_type_other_character      = 0x00000400,
  unichar_type_punctuation          = 0x00007800,
    unichar_type_dash_punctuation     = 0x00000800,
    unichar_type_open_punctuation     = 0x00001000,
    unichar_type_close_punctuation    = 0x00002000,
    unichar_type_other_punctuation    = 0x00004000,
  unichar_type_symbol               = 0x00038000,
    unichar_type_math_symbol          = 0x00008000,
    unichar_type_currency_symbol      = 0x00010000,
    unichar_type_other_symbol         = 0x00020000,
  unichar_type_separator            = 0x001c0000,
    unichar_type_space_separator      = 0x00040000,
    unichar_type_line_separator       = 0x00080000,
    unichar_type_paragraph_separator  = 0x00100000,
  unichar_type_control              = 0x00200000,
    unichar_type_control_character    = 0x00200000
};

typedef enum _unichar_bidirectional_type unichar_bidirectional_type_t;
enum _unichar_bidirectional_type
{
  unichar_bidirectional_type_unknown                    = 0x0000,
  unichar_bidirectional_type_left_right                 = 0x0001,
  unichar_bidirectional_type_right_left                 = 0x0002,
  unichar_bidirectional_type_european_number            = 0x0004,
  unichar_bidirectional_type_european_number_separator  = 0x0008,
  unichar_bidirectional_type_european_number_terminator = 0x0010,
  unichar_bidirectional_type_arabic_number              = 0x0020,
  unichar_bidirectional_type_common_number_separator    = 0x0040,
  unichar_bidirectional_type_block_separator            = 0x0080,
  unichar_bidirectional_type_segment_separator          = 0x0100,
  unichar_bidirectional_type_whitespace                 = 0x0200,
  unichar_bidirectional_type_other_neutral              = 0x0400
};

typedef enum _unichar_decomposition_modifier unichar_decomposition_modifier_t;
enum _unichar_decomposition_modifier
{
  unichar_decomposition_modifier_unknown = -1,
  unichar_decomposition_modifier_none = 0,
  unichar_decomposition_modifier_font,
  unichar_decomposition_modifier_fraction,
  unichar_decomposition_modifier_no_break,
  unichar_decomposition_modifier_initial,
  unichar_decomposition_modifier_medial,
  unichar_decomposition_modifier_final,
  unichar_decomposition_modifier_isolated,
  unichar_decomposition_modifier_circle,
  unichar_decomposition_modifier_superscript,
  unichar_decomposition_modifier_subscript,
  unichar_decomposition_modifier_vertical,
  unichar_decomposition_modifier_wide,
  unichar_decomposition_modifier_narrow,
  unichar_decomposition_modifier_small,
  unichar_decomposition_modifier_square,
  unichar_decomposition_modifier_compatibility
};

typedef struct _unichar_info unichar_info_t;
struct _unichar_info
{
  unichar_t                         character;
  const char *                      name;
  const char *                      old_name;
  const char *                      iso_10646_comment;
  unichar_t                         to_uppercase;
  unichar_t                         to_lowercase;
  unichar_t                         to_titlecase;
  unichar_type_t                    type;
  unichar_bidirectional_type_t      bidirectional_type;
  int				    combining_class;
  int                               ordering_priority;
  int                               is_mirrored;
  unichar_decomposition_modifier_t  decomposition_modifier;
  const unichar_t *                 decomposition;
  int                               decimal_digit_value;
  int                               digit_value;
  float                             numeric_value;
};

/* Getting information about individual characters. */
extern unichar_info_t unichar_info(unichar_t c);
extern const char *unichar_name(unichar_t c);
extern const char *unichar_old_name(unichar_t c);
extern unichar_t unichar_to_uppercase(unichar_t c);
extern unichar_t unichar_to_lowercase(unichar_t c);
extern unichar_t unichar_to_titlecase(unichar_t c);
extern unichar_type_t unichar_type(unichar_t c);
extern int unichar_is_type(unichar_t c, unsigned int flag);
extern unichar_bidirectional_type_t unichar_bidirectional_type(unichar_t c);
extern int unichar_is_bidirectional_type(unichar_t c, unsigned int flag);
extern int unichar_is_mirrored(unichar_t c);
extern int unichar_ordering_priority(unichar_t c);
extern int unichar_combining_class(unichar_t c);
extern const unichar_t *unichar_decomposition(unichar_t c);
extern const unichar_decomposition_modifier_t *unichar_decomposition_modifier(unichar_t c);

/* Shortcuts for those too used to the stardard type functions. */
#define unichar_toupper(C)  unichar_to_uppercase((C))
#define unichar_tolower(C)  unichar_to_lowercase((C))
#define unichar_totitle(C)  unichar_to_titlecase((C))
#define unichar_isalnum(C)  unichar_is_type((C), (unichar_type_letter \
                                                  | unichar_type_number))
#define unichar_isalpha(C)  unichar_is_type((C), unichar_type_letter)
#define unichar_iscntrl(C)  unichar_is_type((C), unichar_type_control)
#define unichar_isdigit(C)  unichar_is_type((C), unichar_type_number)
#define unichar_isgraph(C)  unichar_is_type((C), !(unichar_type_mark \
                                                   | unichar_type_control \
                                                   | unichar_type_separator))
#define unichar_islower(C)  unichar_is_type((C), unichar_type_lowercase_letter)
#define unichar_isprint(C)  unichar_is_type((C), !(unichar_type_mark \
                                                   | unichar_type_control))
#define unichar_ispunct(C)  unichar_is_type((C), unichar_type_punctuation)
#define unichar_isspace(C)  unichar_is_type((C), unichar_type_separator)
#define unichar_isupper(C)  unichar_is_type((C), unichar_type_uppercase_letter)
#define unichar_istitle(C)  unichar_is_type((C), unichar_type_titlecase_letter)
#define unichar_isxdigit(C) unichar_is_hex_digit((C))
#define unichar_tolower(C)  unichar_to_lowercase((C))
#define unichar_toupper(C)  unichar_to_uppercase((C))

#endif /* __ctype_h_UNICHAR_INCLUDE */
