#ifndef __string_h_UNICHAR_INCLUDE
#define __string_h_UNICHAR_INCLUDE 1

#include <unichar/unichar.h>

int unichar_strcmp(const unichar_t *s1, const unichar_t *s2);
int unichar_strncmp(const unichar_t *s1, const unichar_t *s2, size_t count);
int unichar_strcasecmp(const unichar_t *s1, const unichar_t *s2);
int unichar_strncasecmp(const unichar_t *s1, const unichar_t *s2, size_t count);
size_t unichar_strlen(const unichar_t *s);
size_t unichar_strspn(const unichar_t *s, const unichar_t *accept);
size_t unichar_strcspn(const unichar_t *s, const unichar_t *reject);
unichar_t *unichar_strcpy(unichar_t *dest, const unichar_t *src);
unichar_t *unichar_strncpy(unichar_t *dest, const unichar_t *src, size_t count);
unichar_t *unichar_stpcpy(unichar_t *dest, const unichar_t *src);
unichar_t *unichar_strpcpy(unichar_t *dest, const unichar_t *src, size_t count);
unichar_t *unichar_strdup(const unichar_t *s);
unichar_t *unichar_strcat(unichar_t *dest, const unichar_t *src);
unichar_t *unichar_strncat(unichar_t *dest, const unichar_t *src, size_t count);
unichar_t *unichar_strcatn(unichar_t *dest, ...);
unichar_t *unichar_strchr(const unichar_t *s, unichar_t c);
unichar_t *unichar_strrchr(const unichar_t *s, unichar_t c);
unichar_t *unichar_strstr(const unichar_t *haystack, const unichar_t *needle);
unichar_t *unichar_strpbrk(const unichar_t *s, const unichar_t *accept);
unichar_t *unichar_strsep(unichar_t **stringp, const unichar_t *delim);
unichar_t *unichar_swab(unichar_t *target);
unichar_t *unichar_strfix(unichar_t *target);
unichar_t *unichar_strfry(unichar_t *target);
unichar_t *unichar_strrev(unichar_t *target);
unichar_t *unichar_strnrev(unichar_t *target, size_t count);

#endif /* __string_h_UNICHAR_INCLUDE */
