.TH PCAL 1
.SH NAME
pcal \- generate PostScript calendars
.SH SYNOPSIS
.B pcal
[
.BR \-e
|
.BR \-f <cal>
] [
.B \-m <month>
[
.B \-y <year>
]] [
.B -r
] [
.B -s
] [
.B -t <titlefont name>
] [
.B -d <dayfont name>
]
.SH DESCRIPTION
.I Pcal
generates PostScript to produce landscape or portrait calendars for any 
month and year.  The arguments
.B <month>
and
.BR <year> ,
if provided, should be numeric.  The month should be in the range 1 - 12,
and year should be specified as 1 or 2 digits or as the full 4 digit year.
The defaults for month and year are the current month and year.
If month is provided, but zero, the entire year is printed.
.P
If a file named
.I calendar
resides in the caller's home directory, it will be searched for lines with
leading dates matching the requested month and year (current by default).
Any text following the date will be printed on the calendar under the
appropriate day of the month.  Dates in the
.I calendar
file may consist of a numeric or alpha month (at least the first 3 characters
for month names) followed by a numeric day and optionally followed by a
year.  Any non-numeric character may separate numeric dates.  Holidays may
be flagged by following the date immediately with '*'; this will cause the
date to be printed in gray.  Lines in the
.I calendar
file consisting of "year xxxx" (where xxxx is a numeric year) can be used
to set the year for following entries.  This assumes that the following
entries do not contain a year; any date entries containing year information
will set the remembered year to that year.
.P
.I Pcal has many options:
.P
.TP
.B \-e
Print an empty calendar.  Do not print entries from a calendar file.
.TP
.BR \-f <cal>
Directs
.I pcal
to use the file name <cal> as the input file in place of the default
calendar file in the callers home directory.
.TP
.B \-r
This will cause the output to come out in portrait
mode instead of landscape.
.TP
.B \-s
This will cause Saturdays to be printed in black instead of gray.
.TP
.BR \-t <titlefont name>
This option can be used to change the font the title
is printed in. (ie. pcal -t Times-Roman).
.TP
.BR  -d <dayfont name>
This option is the same as -t except that the font used
to print the day numbers is changed.
.SH SEE ALSO
cal(1)
.SH CAVEATS
The original PostScript code to generate the calendars was written by
Patrick Wood (Copywrite (c) 1987 by Patrick Wood of Pipeline Associates,
Inc.), and authorized for modification and redistribution.  The calendar
file inclusion code was originally written in "bs(1)" by Bill Vogel of
AT&T.  Patrick's original PostScript was modified and enhanced several
times by others whos names have regrettably been lost.  Ken Keirnan of
Pacific Bell assembled the original "C" version upon which this is based;
additional modifications and enhancements were the work of Joseph P.
Larson, Ed Hand, and Andrew W. Rogers.
