. /* Copyright 1994 Yggdrasil Computing, Inc. */5 /* Written by Adam J. Richter (adam@yggdrasil.com) */   7 /* Rewritten February 1997 by Eberhard Heuser-Hofmann*/ . /* using the OpenVMS generic scsi-interface */4 /* see the README-file, how to setup your machine */   F /* This file may be copied under the terms and conditions of version 2>    of the GNU General Public License, as published by the Free2    Software Foundation (Cambridge, Massachusetts).  B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software@    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */  E /* The second notice comes from sys$examples:gktest.c (OpenVMS 7.0)*/    /* ** COPYRIGHT (c) 1993 BY9 ** DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.  ** ALL RIGHTS RESERVED.  **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDH ** ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THEH ** INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHERH ** COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANYH ** OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY ** TRANSFERRED.  **H ** THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICEH ** AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT ** CORPORATION.  **H ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS: ** SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL. */    
 #ifdef VAX #pragma module gktest "V01-03" #else  #pragma module gktest "V01-03" #endif   /* ** **  INCLUDE FILES  ** */   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <fcntl.h> #include <stdarg.h>  #include <ctype.h> #include <iodef.h> #include <descrip.h> #include <starlet.h> #include <unistd.h>    /* ** **  MACRO DEFINITIONS  ** */  . #define GK_EFN 0		    /*  Event flag number */  @ #define SCSI_DATA_LENGTH 0x24    /*  Length of inquiry buffer */   /* SCSI command opcodes */$ #define TEST_UNIT_READY         0x00$ #define REZERO_UNIT             0x01$ #define REQUEST_SENSE           0x03$ #define WRITE_6                 0x0a$ #define INQUIRY                 0x12$ #define MODE_SELECT             0x15$ #define START_STOP              0x1b$ #define ALLOW_MEDIUM_REMOVAL    0x1e$ #define READ_CAPACITY           0x25$ #define SYNCRONIZE_CACHE        0x35  L /* SCSI-commands - PHILLIPS specific.  If we fix the program to use multiple<    writers, this would be something that needs attention. */ #define RESERVE_TRACK   0xE4 #define WRITE_TRACK     0xE6 #define LOAD_UNLOAD     0xE7= #define FIXATION        0xE9    /* Write table of contents */  #define RECOVER         0xEC   #define SPEED 2  #define DUMMY_WRITE 1  #define TRACK_NUMBER 0 #define CD_BLOCK_SIZE      2048  #define BLOCKS_PER_WRITE   25 = #define WRITE_BLOCK_SIZE   (CD_BLOCK_SIZE * BLOCKS_PER_WRITE)    /* ** SCSI definitions: **E ** Ideally, these definitions should come from a header file provided E ** with the system.  At the time that this example was written and at C ** the time of last update, no such file was available. For now, we E ** define right here fields we need from the SCSI descriptor for this B ** example; this should be replaced with the appropriate #include,F ** should such a header file become available.  The reader should noteA ** that some of the field names and types in that header file may F ** differ slightly from what's shown here; when and if the header fileD ** becomes available, code which does depend on the names should useD ** the appropriate header file names.  Code which depends on gettingE ** the types right may need to re-cast these members when referencing  ** them. */  % /* Generic SCSI command descriptor */    struct SCSI$DESC {A     unsigned int    SCSI$L_OPCODE;	     /* SCSI Operation Code */ ?     unsigned int    SCSI$L_FLAGS;	     /* SCSI Flags Bit Map */ <     char	* SCSI$A_CMD_ADDR;	     /* ->SCSI command buffer */F     unsigned int	SCSI$L_CMD_LEN;	     /* SCSI command length, bytes */:     char	* SCSI$A_DATA_ADDR;	     /* ->SCSI data buffer */C     unsigned int	SCSI$L_DATA_LEN;     /* SCSI data length, bytes */ B     unsigned int	SCSI$L_PAD_LEN;	     /* SCSI pad length, bytes */J     unsigned int	SCSI$L_PH_CH_TMOUT;  /* SCSI phase change timeout, sec */H     unsigned int	SCSI$L_DISCON_TMOUT; /* SCSI disconnect timeout, sec */2     unsigned int	SCSI$L_RES_1;	     /* Reserved */2     unsigned int	SCSI$L_RES_2;	     /* Reserved */2     unsigned int	SCSI$L_RES_3;	     /* Reserved */2     unsigned int	SCSI$L_RES_4;	     /* Reserved */2     unsigned int	SCSI$L_RES_5;	     /* Reserved */2     unsigned int	SCSI$L_RES_6;	     /* Reserved */	     } ;     $ /* SCSI Input/Output Status Block */   #ifdef __ALPHA #pragma member_alignment save  #pragma nomember_alignment #endif   struct SCSI$IOSB {A     unsigned short int	SCSI$W_VMS_STAT;	    /* VMS status code */ J     unsigned long int	SCSI$L_IOSB_TFR_CNT; /* Actual #bytes transferred */     char 	SCSI$B_IOSB_FILL_1; <     unsigned char	SCSI$B_IOSB_STS;		/* SCSI device status */     };   #ifdef __ALPHA  #pragma member_alignment restore #endif    0 /* SCSI status codes and flag field constants */  ! #define SCSI$K_GOOD_STATUS      0 ; #define SCSI$K_WRITE		0X0	/* direction of transfer=write */ 9 #define SCSI$K_READ		0X1	/* direction of transfer=read */ 7 #define SCSI$K_FL_ENAB_DIS	0X2	/* enable disconnects */ 1 #define SCSI$K_FL_ENAB_SYNC	0X4	/* enable sync */    /* end of SCSI definitions */    /* data declarations */    char scsi_status,       scsi_command_6[6],  	scsi_command_10[10],  	scsi_data[SCSI_DATA_LENGTH],  	scsi_data1[WRITE_BLOCK_SIZE],   	gk_device[] = {"CDWR"};        unsigned short int gk_chan,  		       transfer_length;      int i,   	status;  ,     $DESCRIPTOR (gk_device_desc, gk_device);       struct SCSI$IOSB gk_iosb ;    N /* Set up the descriptor with the SCSI information to be sent to the target */  + struct SCSI$DESC gk_desc;    /* reserved */    long lib$wait();   int inquire() {    scsi_command_6[0] = INQUIRY; scsi_command_6[1] = 0; scsi_command_6[2] = 0; scsi_command_6[3] = 0;% scsi_command_6[4] = SCSI_DATA_LENGTH;  scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ M gk_desc.SCSI$L_DATA_LEN = SCSI_DATA_LENGTH;     /* SCSI data length, bytes */ G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */            L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  ' /* Yes, was SCSI Status OK from QIO? */   6     if (gk_iosb.SCSI$B_IOSB_STS != SCSI$K_GOOD_STATUS)     { L     	printf ("Bad SCSI status returned: %02.2x\n", gk_iosb.SCSI$B_IOSB_STS); 	sys$exit (1);     }   K /* The command succeeded. Display the SCSI data returned from the target */   2     transfer_length = gk_iosb.SCSI$L_IOSB_TFR_CNT;Q     printf ("SCSI inquiry data returned %lu bytes of data: \n", transfer_length); '     for (i=8;  i<transfer_length;  i++)      {   	    if (isprint (scsi_data[i]))" 		    printf ("%c", scsi_data[i]);	 	    else  		    printf (".");      }      printf ("\n");%     status = gk_iosb.SCSI$B_IOSB_STS;      return status; }    int request_sense() {   " scsi_command_6[0] = REQUEST_SENSE; scsi_command_6[1] = 1; scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 18;  scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ ? gk_desc.SCSI$L_DATA_LEN = 18;     /* SCSI data length, bytes */ G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */            L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  K /* The command succeeded. Display the SCSI data returned from the target */   2     transfer_length = gk_iosb.SCSI$L_IOSB_TFR_CNT;K     printf ("request_sense returned %lu bytes of data: ", transfer_length);      for (i=0;  i<18;  i++)     {   	    if (isprint (scsi_data[i]))" 		    printf ("%c", scsi_data[i]);	 	    else  		    printf (".");      }      printf ("\n");     printf ("\n");%     status = gk_iosb.SCSI$B_IOSB_STS;      return status; }    int test_unit_ready() { $ scsi_command_6[0] = TEST_UNIT_READY; scsi_command_6[1] = 0; scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 0; scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */     gk_iosb.SCSI$B_IOSB_STS = -1; 1 printf ("Wait until drive becomes ready ... \r");   $ while (gk_iosb.SCSI$B_IOSB_STS != 0) {     L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  ' /* Yes, was SCSI Status OK from QIO? */  }   B printf ("Drive is ready now!                                 \r");! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int unload() {  scsi_command_10[0] =LOAD_UNLOAD; scsi_command_10[1] = 1;  scsi_command_10[2] = 0;  scsi_command_10[3] = 0;  scsi_command_10[4] = 0;  scsi_command_10[5] = 0;  scsi_command_10[6] = 0;  scsi_command_10[7] = 0;  scsi_command_10[8] = 1;  scsi_command_10[9] = 0;   h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */O gk_desc.SCSI$A_CMD_ADDR = &scsi_command_10[0];	     /* ->SCSI command buffer */ B gk_desc.SCSI$L_CMD_LEN = 10;	     /* SCSI command length, bytes */G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  4 printf ("unload                                \r");! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int load() {  scsi_command_10[0] =LOAD_UNLOAD; scsi_command_10[1] = 1;  scsi_command_10[2] = 0;  scsi_command_10[3] = 0;  scsi_command_10[4] = 0;  scsi_command_10[5] = 0;  scsi_command_10[6] = 0;  scsi_command_10[7] = 0;  scsi_command_10[8] = 0;  scsi_command_10[9] = 0;   h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */O gk_desc.SCSI$A_CMD_ADDR = &scsi_command_10[0];	     /* ->SCSI command buffer */ B gk_desc.SCSI$L_CMD_LEN = 10;	     /* SCSI command length, bytes */G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */       L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  ! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int disallow_removal()    {   ) scsi_command_6[0] = ALLOW_MEDIUM_REMOVAL;  scsi_command_6[1] = 0; scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 1; scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  ' /* Yes, was SCSI Status OK from QIO? */   ; printf ("Disallow media-removal                       \r"); ! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int start_unit() { scsi_command_6[0] = START_STOP;  scsi_command_6[1] = 1; scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 1; scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  = printf ("Start unit                                     \r"); ! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int rezero_unit() {   scsi_command_6[0] = REZERO_UNIT; scsi_command_6[1] = 0; scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 0; scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  % status = gk_iosb.SCSI$B_IOSB_STS & 1;  return status; }    int mode_select1()	{  scsi_command_6[0] = MODE_SELECT; scsi_command_6[1] = 0x10;  scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 20;  scsi_command_6[5] = 0;     /* Mode select header: */ (    scsi_data[0] = 0;  /* 6+0 reserved */+    scsi_data[1] = 0;  /* 6+1 medium type */ !    scsi_data[2] = 0;  /* 6+2   */ 8    scsi_data[3] = 0;   /* 6+3 block descriptor length */      /* Mode Page 0x21 */ /    scsi_data[4] = 0x21;   /* 6+4+0 page code */ 2    scsi_data[5] = 14; /* 6+4+1 paramter length? */*    scsi_data[6] = 0;  /* 6+4+2 reserved */=    scsi_data[7] = 1;  /* 2048-byte non-mixed CDROM sectors */ 6    scsi_data[8] = 0;  /* 6+4+4 create new track ??? */&    scsi_data[9] = 0; /* reserved... */    scsi_data[10] = 0;     scsi_data[11] = 0;     scsi_data[12] = 0;     scsi_data[13] = 0;     scsi_data[14] = 0;     scsi_data[15] = 0;     scsi_data[16] = 0;     scsi_data[17] = 0; $    scsi_data[18] = 0; /* reserved */9    scsi_data[19] = 0; /* 6+4+15, total byte count = 20 */     i gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_WRITE|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */ N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ ? gk_desc.SCSI$L_DATA_LEN = 20;     /* SCSI data length, bytes */ G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  = printf ("Mode select #1                                 \r"); ! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }   / int mode_select2(int speed, int dummy_write)  {   scsi_command_6[0] = MODE_SELECT; scsi_command_6[1] = 0x10;  scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 12;  scsi_command_6[5] = 0;     /* Mode select header: */ (    scsi_data[0] = 0;  /* 6+0 reserved */+    scsi_data[1] = 0;  /* 6+1 medium type */ !    scsi_data[2] = 0;  /* 6+2   */ 8    scsi_data[3] = 0;   /* 6+3 block descriptor length */      /* Mode Page 0x23 */ /    scsi_data[4] = 0x23;   /* 6+4+0 page code */ 1    scsi_data[5] = 6; /* 6+4+1 paramter length? */ .    scsi_data[6] = speed;  /* 6+4+2 reserved */>    scsi_data[7] = dummy_write;  /* 1 = dummy, 0 = real write*/6    scsi_data[8] = 0;  /* 6+4+4 create new track ??? */&    scsi_data[9] = 0; /* reserved... */    scsi_data[10] = 0;     scsi_data[11] = 0;     i gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_WRITE|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */ N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ ? gk_desc.SCSI$L_DATA_LEN = 12;     /* SCSI data length, bytes */ G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  B printf ("Mode select #2                                      \r");! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int write_track() { ! scsi_command_10[0] = WRITE_TRACK;  scsi_command_10[1] = 0;  scsi_command_10[2] = 0;  scsi_command_10[3] = 0;  scsi_command_10[4] = 0; " scsi_command_10[5] = TRACK_NUMBER; scsi_command_10[6] = 1;  scsi_command_10[7] = 0;  scsi_command_10[8] = 0;  scsi_command_10[9] = 0;   h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */O gk_desc.SCSI$A_CMD_ADDR = &scsi_command_10[0];	     /* ->SCSI command buffer */ B gk_desc.SCSI$L_CMD_LEN = 10;	     /* SCSI command length, bytes */G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  < printf ("write_track                                   \r");! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int write_6()	{  scsi_command_6[0] = WRITE_6 ;  scsi_command_6[1] = 0;+ scsi_command_6[2] = BLOCKS_PER_WRITE >> 16; * scsi_command_6[3] = BLOCKS_PER_WRITE >> 8;% scsi_command_6[4] = BLOCKS_PER_WRITE;  scsi_command_6[5] = 0;  d gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_WRITE|SCSI$K_FL_ENAB_DIS; /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ H gk_desc.SCSI$A_DATA_ADDR = &scsi_data1[0];	     /* ->SCSI data buffer */M gk_desc.SCSI$L_DATA_LEN = WRITE_BLOCK_SIZE;     /* SCSI data length, bytes */ M gk_desc.SCSI$L_PH_CH_TMOUT = 0xfffffff;  /* SCSI phase change timeout, sec */ K gk_desc.SCSI$L_DISCON_TMOUT = 0xfffffff; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  ! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int sync_cache()    { & scsi_command_10[0] = SYNCRONIZE_CACHE; scsi_command_10[1] = 0;  scsi_command_10[2] = 0;  scsi_command_10[3] = 0;  scsi_command_10[4] = 0;  scsi_command_10[5] = 0;  scsi_command_10[6] = 0;  scsi_command_10[7] = 0;  scsi_command_10[8] = 0;  scsi_command_10[9] = 0;   h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */O gk_desc.SCSI$A_CMD_ADDR = &scsi_command_10[0];	     /* ->SCSI command buffer */ B gk_desc.SCSI$L_CMD_LEN = 10;	     /* SCSI command length, bytes */G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  > printf ("Flush Cache                                     \r");! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int fixation()	{ scsi_command_10[0] = FIXATION; scsi_command_10[1] = 0;  scsi_command_10[2] = 0;  scsi_command_10[3] = 0;  scsi_command_10[4] = 0;  scsi_command_10[5] = 0;  scsi_command_10[6] = 0;  scsi_command_10[7] = 0;  scsi_command_10[8] = 1;  scsi_command_10[9] = 0;   h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */O gk_desc.SCSI$A_CMD_ADDR = &scsi_command_10[0];	     /* ->SCSI command buffer */ B gk_desc.SCSI$L_CMD_LEN = 10;	     /* SCSI command length, bytes */G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */H gk_desc.SCSI$L_PH_CH_TMOUT = 1800;  /* SCSI phase change timeout, sec */F gk_desc.SCSI$L_DISCON_TMOUT = 1800; /* SCSI disconnect timeout, sec */       L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  B printf ("Fixation                                            \r");! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int stop_unit()	{  scsi_command_6[0] = START_STOP;  scsi_command_6[1] = 1; scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 0; scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  B printf ("Stop unit                                           \r");! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    int allow_removal() { ) scsi_command_6[0] = ALLOW_MEDIUM_REMOVAL;  scsi_command_6[1] = 0; scsi_command_6[2] = 0; scsi_command_6[3] = 0; scsi_command_6[4] = 0; scsi_command_6[5] = 0;  h gk_desc.SCSI$L_FLAGS = SCSI$K_FL_ENAB_SYNC|SCSI$K_READ|SCSI$K_FL_ENAB_DIS;	     /* SCSI Flags Bit Map */N gk_desc.SCSI$A_CMD_ADDR = &scsi_command_6[0];	     /* ->SCSI command buffer */A gk_desc.SCSI$L_CMD_LEN = 6;	     /* SCSI command length, bytes */ G gk_desc.SCSI$A_DATA_ADDR = &scsi_data[0];	     /* ->SCSI data buffer */ > gk_desc.SCSI$L_DATA_LEN = 0;     /* SCSI data length, bytes */G gk_desc.SCSI$L_PH_CH_TMOUT = 180;  /* SCSI phase change timeout, sec */ E gk_desc.SCSI$L_DISCON_TMOUT = 180; /* SCSI disconnect timeout, sec */        L /* Issue the QIO to send the inquiry command and receive the inquiry data */  L     status = sys$qiow ( GK_EFN,  gk_chan,  IO$_DIAGNOSE,  &gk_iosb,  0,  0, 7                       &gk_desc,  15*4,  0,  0,  0,  0);     . /* Check the various returned status values */)     if (!(status & 1))	sys$exit (status);     ! /* Was VMS Status OK from QIO? */   '     if (!(gk_iosb.SCSI$W_VMS_STAT & 1)) (     	sys$exit (gk_iosb.SCSI$W_VMS_STAT);  ! status = gk_iosb.SCSI$B_IOSB_STS;  return status; }    main (int argc, char **argv )    {  int bytes_in,fd,bges;  int speed_factor = 2;  int dummy_write = 1; float t = 5.0;      if (argc == 1) {        fprintf (stderr,P                "Usage: cdwrite [-dummy/write] [-speed speed_factor (1/2)] \n ");       exit(1);    }      while (argc > 1) { +       if (strcmp(argv[1], "-write") == 0) {           dummy_write = 0;           argv++;          argc--;       } 0       else if (strcmp(argv[1], "-speed") == 0) { 	 if (argv[2] != 0)  {0          switch (speed_factor = atoi(argv[2])) {           case 1:            case 2:              argv += 2;             argc -= 2;             break;           default:C             fprintf (stderr, "%d is not a support speed factor\n");              exit(1);
          }	         }        else break;        } 	    else {        fprintf (stderr,I        "Usage: cdwrite [-dummy/write] [-speed speed_factor (1/2)] \n\n");  	break;     }      }        fprintf (stderr,C 	    "Parameters :\n dummy=0 write=1: %i\n speed:           %i\n\n" ! 	    ,!dummy_write,speed_factor);     /*  Assign the device channel */>     status = sys$assign ( &gk_device_desc,  &gk_chan,  0,  0);     if (!(status & 1))     { >     	printf ("Unable to assign channel to %s", &gk_device[0]); 	sys$exit (status);      }   9 gk_desc.SCSI$L_OPCODE = 1;	     /* SCSI Operation Code */ = gk_desc.SCSI$L_PAD_LEN = 0;	     /* SCSI pad length, bytes */ - gk_desc.SCSI$L_RES_1 = 0;	     /* Reserved */ - gk_desc.SCSI$L_RES_2 = 0;	     /* Reserved */ - gk_desc.SCSI$L_RES_3 = 0;	     /* Reserved */ - gk_desc.SCSI$L_RES_4 = 0;	     /* Reserved */ - gk_desc.SCSI$L_RES_5 = 0;	     /* Reserved */ - gk_desc.SCSI$L_RES_6 = 0;	     /* Reserved */   
 inquire();   test_unit_ready();  %     if (status != SCSI$K_GOOD_STATUS)      {  	if (status != 0)  	    {< 	     printf ("Bad SCSI status returned: %02.2x\n", status); 	     sys$exit (1);  	    }     }      gk_iosb.SCSI$B_IOSB_STS = -1;   $ while (gk_iosb.SCSI$B_IOSB_STS != 0)
     unload(); ! if (status != SCSI$K_GOOD_STATUS)      {  	if (status!= 0)   	    {< 	     printf ("Bad SCSI status returned: %02.2x\n", status); 	     sys$exit (1);  	    }     }  /* wait a short time	*/ 
 lib$wait(&t);    gk_iosb.SCSI$B_IOSB_STS = -1;   E printf ("load-command                                           \r"); $ while (gk_iosb.SCSI$B_IOSB_STS != 0)     load(); ! if (status != SCSI$K_GOOD_STATUS)      {          if (status!= 0) 
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }    test_unit_ready();  %     if (status != SCSI$K_GOOD_STATUS)      {  	if (status != 0)  	    {< 	     printf ("Bad SCSI status returned: %02.2x\n", status); 	     sys$exit (1);  	    }     }    disallow_removal();   %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }    gk_iosb.SCSI$B_IOSB_STS = -1;   $ while (gk_iosb.SCSI$B_IOSB_STS != 0)     start_unit ();  %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }    gk_iosb.SCSI$B_IOSB_STS = -1;    printf ("Rezero unit \n");$ while (gk_iosb.SCSI$B_IOSB_STS != 0) rezero_unit (); %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }    test_unit_ready();  %     if (status != SCSI$K_GOOD_STATUS)      {  	if (status != 0)  	    {< 	     printf ("Bad SCSI status returned: %02.2x\n", status); 	     sys$exit (1);  	    }     }    gk_iosb.SCSI$B_IOSB_STS = -1;   $ while (gk_iosb.SCSI$B_IOSB_STS != 0)     start_unit ();  %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }      mode_select1();   %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }    ' mode_select2(speed_factor,dummy_write);   %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }    write_track();  %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }   9 printf ("write_6 executed. Now it's coffee time ... \n"); 2 fd = open ("VDA", O_RDONLY ,0,"ctx=stm","mbc=64");0 bytes_in = read(fd,scsi_data1,WRITE_BLOCK_SIZE);	 bges = 0; & while (bytes_in == WRITE_BLOCK_SIZE)	{
 write_6();%     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status); ' 	     if (status == 2) request_sense(); $ 	     if (status != 0) sys$exit (1);
             }      }  bges += bytes_in; $ printf (" %i bytes written\r",bges);0 bytes_in = read(fd,scsi_data1,WRITE_BLOCK_SIZE); } $ printf (" %i bytes written\n",bges); printf (" write_6 finished\n");   
 close(fd);
 sync_cache(); %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status); ' 	     if (status == 2) request_sense(); $ 	     if (status != 0) sys$exit (1);
             }      }  fixation(); %     if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status); ' 	     if (status == 2) request_sense(); $ 	     if (status != 0) sys$exit (1);
             }      }   
 sync_cache(); ' /*    if (status != SCSI$K_GOOD_STATUS)      {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status); ' 	     if (status == 2) request_sense(); $ 	     if (status != 0) sys$exit (1);
             }      }  */ gk_iosb.SCSI$B_IOSB_STS = -1;   $ while (gk_iosb.SCSI$B_IOSB_STS != 0)     stop_unit();$    if (status != SCSI$K_GOOD_STATUS)     {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }    gk_iosb.SCSI$B_IOSB_STS = -1; " printf ("Allow media-removal \n");$ while (gk_iosb.SCSI$B_IOSB_STS != 0)     allow_removal();$    if (status != SCSI$K_GOOD_STATUS)     {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      } 1                                                    gk_iosb.SCSI$B_IOSB_STS = -1;   $ while (gk_iosb.SCSI$B_IOSB_STS != 0)
     unload(); $    if (status != SCSI$K_GOOD_STATUS)     {          if (status != 0)
             { C              printf ("Bad SCSI status returned: %02.2x\n", status);               sys$exit (1);
             }      }   " printf ("CD-Writing finished \n"); } 