/*
**	mod_msql.h	-  Lite / W3-mSQL module for mSQL Access
**
**
** Copyright (c) 1995  Hughes Technologies Pty Ltd.
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
**
** This software is provided "as is" without any expressed or implied warranty.
**
*/


/*
** External function prototypes
*/

void doMsqlConnect();
void doMsqlClose();
void doMsqlSelectDB();
void doMsqlQuery();
void doMsqlStoreResult();
void doMsqlFreeResult();
void doMsqlFetchField();
void doMsqlFetchRow();
void doMsqlFieldSeek();
void doMsqlDataSeek();
void doMsqlListDBs();
void doMsqlListTables();
void doMsqlInitFieldList();
void doMsqlListField();
void doMsqlNumRows();
void doMsqlEncode();
void doMsqlUnixTimeToDate();
void doMsqlDateToUnixTime();
void doMsqlUnixTimeToTime();
void doMsqlTimeToUnixTime();

void initModMsql();


/*
** Note : Because this is a static linked module (rather than a dynamic
** loaded module) we don't need to include the CFuntName field in the
** function table)
*/

/*
** mSQL external function definitions
**
** This table maps from internal Lite function names to the C code.
** The format is :-
**
**	{LiteName, CFunctPtr, CFunctName, NumArgs, { Arg1Type, Arg2Type.., 0}}
**
**	Setting NumArgs to -1 indicates varargs
*/


efunct_t msql_efuncts[] = {
	{ "msqlConnect", doMsqlConnect, NULL, -1, {0}},
	{ "msqlClose", doMsqlClose, NULL, 1, {P_INT,0}},
	{ "msqlSelectDB", doMsqlSelectDB, NULL, 2, {P_INT,P_TEXT, 0}},
	{ "msqlQuery", doMsqlQuery, NULL, 2, {P_INT,P_TEXT, 0}},
	{ "msqlStoreResult", doMsqlStoreResult, NULL, 0, {0}},
	{ "msqlFreeResult", doMsqlFreeResult, NULL, 1, {P_INT,0}},
	{ "msqlFetchRow", doMsqlFetchRow, NULL, 1, {P_INT,0}},
	{ "msqlFetchField", doMsqlFetchField, NULL, 1, {P_INT,0}},
	{ "msqlFieldSeek", doMsqlFieldSeek, NULL, 2, {P_INT,P_INT,0}},
	{ "msqlDataSeek", doMsqlDataSeek, NULL, 2, {P_INT,P_INT,0}},
	{ "msqlListDBs", doMsqlListDBs, NULL, 1, {P_INT,0}},
	{ "msqlListTables", doMsqlListTables, NULL, 1, {P_INT,0}},
	{ "msqlInitFieldList", doMsqlInitFieldList, NULL, 2, {P_INT,P_TEXT,0}},
	{ "msqlListField", doMsqlListField, NULL, 0, {0}},
	{ "msqlNumRows", doMsqlNumRows, NULL, 1, {P_INT,0}},
	{ "msqlEncode", doMsqlEncode, NULL, 1, {P_TEXT,0}},
	{ "msqlUnixTimeToDate", doMsqlUnixTimeToDate, NULL, 1, {P_INT,0}},
	{ "msqlDateToUnixTime", doMsqlDateToUnixTime, NULL, 1, {P_TEXT,0}},
	{ "msqlUnixTimeToTime", doMsqlUnixTimeToTime, NULL, 1, {P_INT,0}},
	{ "msqlTimeToUnixTime", doMsqlTimeToUnixTime, NULL, 1, {P_TEXT,0}},

	{ NULL, 0 }
};
