;; Functions for dealing with char tables for VT-100 terminals.
;; Copyright (C) 1987 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;; Written by Howard Gayle.  See case-table.el for details.

(defun standard-char-graphic (c gc)
   "Display character C as graphic set character GC in
   backslash-char-table and ctl-arrow-char-table."
   (let	 ((r (vector (new-glyf (concat "\e(0" (char-to-string gc) "\e(B")))))
      (put-char-table-dispr (backslash-char-table) c r)
      (put-char-table-dispr (ctl-arrow-char-table) c r)
      r
   )
)

(defun standard-char-underline (c uc)
   "Display character C as character UC underlined in
   backslash-char-table and ctl-arrow-char-table."
   (let	 ((r (vector (new-glyf (concat "\e[4m" (char-to-string uc) "\e[m")))))
      (put-char-table-dispr (backslash-char-table) c r)
      (put-char-table-dispr (ctl-arrow-char-table) c r)
      r
   )
)

(defun standard-frameg-graphic (gc)
   "For the frame glyf, use graphic set character GC in
   backslash-char-table and ctl-arrow-char-table."
   (let	 ((g (new-glyf (concat "\e(0" (char-to-string gc) "\e(B"))))
      (put-char-table-frameg (backslash-char-table) g)
      (put-char-table-frameg (ctl-arrow-char-table) g)
      g
   )
)

(defun standard-truncg-graphic (gc)
   "For the truncation glyf, use graphic set character GC in
   backslash-char-table and ctl-arrow-char-table."
   (let	 ((g (new-glyf (concat "\e(0" (char-to-string gc) "\e(B"))))
      (put-char-table-truncg (backslash-char-table) g)
      (put-char-table-truncg (ctl-arrow-char-table) g)
      g
   )
)

(defun standard-wrapg-graphic (gc)
   "For the line wrap glyf, use graphic set character GC in
   backslash-char-table and ctl-arrow-char-table."
   (let	 ((g (new-glyf (concat "\e(0" (char-to-string gc) "\e(B"))))
      (put-char-table-wrapg (backslash-char-table) g)
      (put-char-table-wrapg (ctl-arrow-char-table) g)
      g
   )
)

(provide 'char-table-vt100)
