;;;;  iso-chars.el
;;;;
;;;;  Define char tables for displaying the eight bit ISO fonts.
;;;;
;;;;  Author:	Thomas Bellman
;;;;		Lysator Computer Club
;;;;		Linkoping University
;;;;		Sweden
;;;;
;;;;  email:	Bellman@Lysator.LiU.Se


(require 'char-table)

(defvar iso8859-char-table nil
  "Char table for showing ISO 8859 characters on ISO 8859 terminals.
This displays the control characters in the range [0,31] as ^X, control
characters in the range [128,159] as \\nnn, the DEL character as ^? and
all other characters are displayed directly.")

(defvar iso8859-1-ascii-char-table nil
  "Char table for showing ISO 8859-1 characters on ASCII terminals.")

(defvar iso8859-1-ascii-oneglyf-char-table nil
  "Char table for showing ISO 8859-1 characters on ASCII terminals, using
one glyf per character.")

(defvar iso8859-1-swascii-char-table nil
  "Char table for showing ISO 8859-1 characters on \"swascii\" terminals,
i e terminals using the Swedish variant of ISO 646.")

(defvar iso8859-1-swascii-oneglyf-char-table nil
  "Char table for showing ISO 8859-1 characters on \"swascii\" terminals,
using one glyf per character.")

(defvar swascii-on-iso8859-1-char-table nil
  "Char table for showing \"swascii\" characters on an ISO 8859-1 terminal.")



(setq iso8859-char-table (copy-char-table default-buffer-char-table))
(let ((ch 0))
  (while (<= ch 31)
    (if (not (or (= ch 9) (= ch 10)))
	(put-char-table-dispr iso8859-char-table ch
			      (string-to-rope (format "^%c" (+ ch 64)))))
    (setq ch (1+ ch)))
  (while (<= ch 126)
    (put-char-table-dispr iso8859-char-table ch
			  (string-to-rope (char-to-string ch)))
    (setq ch (1+ ch)))
  (put-char-table-dispr iso8859-char-table 127 (string-to-rope "^?"))
  (setq ch 128)
  (while (<= ch 159)
    (put-char-table-dispr iso8859-char-table ch
			  (string-to-rope (format "\\%3o" ch)))
    (setq ch (1+ ch)))
  (while (<= ch 255)
    (put-char-table-dispr iso8859-char-table ch
			  (string-to-rope (char-to-string ch)))
    (setq ch (1+ ch))))



(setq iso8859-1-ascii-char-table (copy-char-table iso8859-char-table))
(mapcar '(lambda (pair)
	   (put-char-table-dispr iso8859-1-ascii-char-table (car pair)
				 (string-to-rope (car (cdr pair)))))
	'((?\240 " ")     (?\241 "!")     (?\242 "c")     (?\243 "GBP")
	  (?\244 "$")     (?\245 "JPY")   (?\246 "|")     (?\247 "$)")
	  (?\250 "\"")    (?\251 "(c)")   (?\252 "_a")    (?\253 "<<")
	  (?\254 "!")     (?\255 "-")     (?\256 "(R)")   (?\257 "=")
	  (?\260 "^o")    (?\261 "+-")    (?\262 "^2")    (?\263 "^3")
	  (?\264 "'")     (?\265 "u")     (?\266 "$)")    (?\267 "*")
	  (?\270 ",")     (?\271 "^1")    (?\272 "_o")    (?\273 ">>")
	  (?\274 " 1/4")  (?\275 " 1/2")  (?\276 " 3/4")  (?\277 "?")
	  (?\300 "A`")    (?\301 "A'")    (?\302 "A^")    (?\303 "A~")
	  (?\304 "A\"")   (?\305 "AA")    (?\306 "AE")    (?\307 "C,")
	  (?\310 "E`")    (?\311 "E'")    (?\312 "E^")    (?\313 "E\"")
	  (?\314 "I`")    (?\315 "I'")    (?\316 "I^")    (?\317 "I\"")
	  (?\320 "D-")    (?\321 "N~")    (?\322 "O`")    (?\323 "O'")
	  (?\324 "O^")    (?\325 "O~")    (?\326 "O\"")   (?\327 "*")
	  (?\330 "O/")    (?\331 "U`")    (?\332 "U'")    (?\333 "U^")
	  (?\334 "U\"")   (?\335 "Y'")    (?\336 "Th")    (?\337 "ss")
	  (?\340 "a`")    (?\341 "a'")    (?\342 "a^")    (?\343 "a~")
	  (?\344 "a\"")   (?\345 "aa")    (?\346 "ae")    (?\347 "c,")
	  (?\350 "e`")    (?\351 "e'")    (?\352 "e^")    (?\353 "e\"")
	  (?\354 "i`")    (?\355 "i'")    (?\356 "i^")    (?\357 "i\"")
	  (?\360 "d-")    (?\361 "n~")    (?\362 "o`")    (?\363 "o'")
	  (?\364 "o^")    (?\365 "o~")    (?\366 "o\"")   (?\367 "-:")
	  (?\370 "o/")    (?\371 "u`")    (?\372 "u'")    (?\373 "u^")
	  (?\374 "u\"")   (?\375 "y'")    (?\376 "th")    (?\377 "y\"")))



(setq iso8859-1-ascii-oneglyf-char-table (copy-char-table iso8859-char-table))
(mapcar '(lambda (pair)
	   (put-char-table-dispr iso8859-1-ascii-oneglyf-char-table
				 (car pair) (string-to-rope (car (cdr pair)))))
	'((?\240 " ")     (?\241 "!")     (?\242 "c")     (?\243 "#")
	  (?\244 "$")     (?\245 "Y")     (?\246 "|")     (?\247 "$")
	  (?\250 "\"")    (?\251 "c")     (?\252 "+")     (?\253 "?")
	  (?\254 "!")     (?\255 "-")     (?\256 "R")     (?\257 "~")
	  (?\260 "C")     (?\261 "+")     (?\262 "2")     (?\263 "3")
	  (?\264 "'")     (?\265 "u")     (?\266 "$")     (?\267 "-")
	  (?\270 ",")     (?\271 "1")     (?\272 "0")     (?\273 "?")
	  (?\274 "?")     (?\275 "?")     (?\276 "?")     (?\277 "?")
	  (?\300 "A")     (?\301 "A")     (?\302 "A")     (?\303 "A")
	  (?\304 "A")     (?\305 "A")     (?\306 "A")     (?\307 "C")
	  (?\310 "E")     (?\311 "E")     (?\312 "E")     (?\313 "E")
	  (?\314 "I")     (?\315 "I")     (?\316 "I")     (?\317 "I")
	  (?\320 "D")     (?\321 "N")     (?\322 "O")     (?\323 "O")
	  (?\324 "O")     (?\325 "O")     (?\326 "O")     (?\327 "*")
	  (?\330 "O")     (?\331 "U")     (?\332 "U")     (?\333 "U")
	  (?\334 "U")     (?\335 "Y")     (?\336 "T")     (?\337 "B")
	  (?\340 "a")     (?\341 "a")     (?\342 "a")     (?\343 "a")
	  (?\344 "a")     (?\345 "a")     (?\346 "a")     (?\347 "c")
	  (?\350 "e")     (?\351 "e")     (?\352 "e")     (?\353 "e")
	  (?\354 "i")     (?\355 "i")     (?\356 "i")     (?\357 "i")
	  (?\360 "d")     (?\361 "n")     (?\362 "o")     (?\363 "o")
	  (?\364 "o")     (?\365 "o")     (?\366 "o")     (?\367 "/")
	  (?\370 "o")     (?\371 "u")     (?\372 "u")     (?\373 "u")
	  (?\374 "u")     (?\375 "y")     (?\376 "t")     (?\377 "y")))


(setq iso8859-1-swascii-char-table
      (copy-char-table iso8859-1-ascii-char-table))
(mapcar '(lambda (pair)
	   (put-char-table-dispr iso8859-1-swascii-char-table
				 (car pair) (string-to-rope (car (cdr pair)))))
	'((?\304 "[")     (?\305 "]")     (?\311 "@")     (?\326 "\\")
	  (?\334 "^")     (?\344 "{")     (?\345 "}")     (?\351 "`")
	  (?\366 "|")     (?\374 "~")))


(setq iso8859-1-swascii-oneglyf-char-table
      (copy-char-table iso8859-1-ascii-oneglyf-char-table))
(mapcar '(lambda (pair)
	   (put-char-table-dispr iso8859-1-swascii-oneglyf-char-table
				 (car pair) (string-to-rope (car (cdr pair)))))
	'((?\304 "[")     (?\305 "]")     (?\311 "@")     (?\326 "\\")
	  (?\334 "^")     (?\344 "{")     (?\345 "}")     (?\351 "`")
	  (?\366 "|")     (?\374 "~")))


(setq swascii-on-iso8859-1-char-table
      (copy-char-table iso8859-char-table))
(mapcar '(lambda (pair)
	   (put-char-table-dispr swascii-on-iso8859-1-char-table
				 (car pair) (string-to-rope (car (cdr pair)))))
	'((?\] "\305")    (?\[ "\304")    (?\\ "\326")    (?^ "\334")
	  (?} "\345")     (?{ "\344")     (?| "\366")     (?~ "\374")))
