;; Set up char tables for ISO 8859/1 character set for ASCII terminals.
;; Copyright (C) 1987 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;; Written by Howard Gayle.  See case-table.el for details.

;; This code sets up backslash-char-table and
;; ctl-arrow-char-table to display ISO 8859/1 characters on plain
;; ASCII terminals.  The display strings for the characters are
;; more-or-less based on TeX.

(require 'char-table)

(standard-char-ascii 160 "{_}")   ; NBSP (no-break space)
(standard-char-ascii 161 "{!}")   ; inverted exclamation mark
(standard-char-ascii 162 "{c}")   ; cent sign
(standard-char-ascii 163 "{GBP}") ; pound sign
(standard-char-ascii 164 "{$}")   ; general currency sign
(standard-char-ascii 165 "{JPY}") ; yen sign
(standard-char-ascii 166 "{|}")   ; broken vertical line
(standard-char-ascii 167 "{S}")   ; section sign
(standard-char-ascii 168 "{\"}")  ; diaeresis
(standard-char-ascii 169 "{C}")   ; copyright sign
(standard-char-ascii 170 "{_a}")  ; ordinal indicator, feminine
(standard-char-ascii 171 "{<<}")  ; left angle quotation mark
(standard-char-ascii 172 "{~}")   ; not sign
(standard-char-ascii 173 "{-}")   ; soft hyphen
(standard-char-ascii 174 "{R}")   ; registered sign
(standard-char-ascii 175 "{=}")   ; macron
(standard-char-ascii 176 "{o}")   ; degree sign
(standard-char-ascii 177 "{+-}")  ; plus or minus sign
(standard-char-ascii 178 "{2}")   ; superscript two
(standard-char-ascii 179 "{3}")   ; superscript three
(standard-char-ascii 180 "{'}")   ; acute accent
(standard-char-ascii 181 "{u}")   ; micro sign
(standard-char-ascii 182 "{P}")   ; pilcrow
(standard-char-ascii 183 "{.}")   ; middle dot
(standard-char-ascii 184 "{,}")   ; cedilla
(standard-char-ascii 185 "{1}")   ; superscript one
(standard-char-ascii 186 "{_o}")  ; ordinal indicator, masculine
(standard-char-ascii 187 "{>>}")  ; right angle quotation mark
(standard-char-ascii 188 "{1/4}") ; fraction one-quarter
(standard-char-ascii 189 "{1/2}") ; fraction one-half
(standard-char-ascii 190 "{3/4}") ; fraction three-quarters
(standard-char-ascii 191 "{?}")   ; inverted question mark
(standard-char-ascii 192 "{`A}")  ; A with grave accent
(standard-char-ascii 193 "{'A}")  ; A with acute accent
(standard-char-ascii 194 "{^A}")  ; A with circumflex accent
(standard-char-ascii 195 "{~A}")  ; A with tilde
(standard-char-ascii 196 "{\"A}") ; A with diaeresis or umlaut mark
(standard-char-ascii 197 "{AA}")  ; A with ring
(standard-char-ascii 198 "{AE}")  ; AE diphthong
(standard-char-ascii 199 "{,C}")  ; C with cedilla
(standard-char-ascii 200 "{`E}")  ; E with grave accent
(standard-char-ascii 201 "{'E}")  ; E with acute accent
(standard-char-ascii 202 "{^E}")  ; E with circumflex accent
(standard-char-ascii 203 "{\"E}") ; E with diaeresis or umlaut mark
(standard-char-ascii 204 "{`I}")  ; I with grave accent
(standard-char-ascii 205 "{'I}")  ; I with acute accent
(standard-char-ascii 206 "{^I}")  ; I with circumflex accent
(standard-char-ascii 207 "{\"I}") ; I with diaeresis or umlaut mark
(standard-char-ascii 208 "{-D}")  ; D with stroke, Icelandic eth
(standard-char-ascii 209 "{~N}")  ; N with tilde
(standard-char-ascii 210 "{`O}")  ; O with grave accent
(standard-char-ascii 211 "{'O}")  ; O with acute accent
(standard-char-ascii 212 "{^O}")  ; O with circumflex accent
(standard-char-ascii 213 "{~O}")  ; O with tilde
(standard-char-ascii 214 "{\"O}") ; O with diaeresis or umlaut mark
(standard-char-ascii 215 "{x}")   ; multiplication sign
(standard-char-ascii 216 "{/O}")  ; O with slash
(standard-char-ascii 217 "{`U}")  ; U with grave accent
(standard-char-ascii 218 "{'U}")  ; U with acute accent
(standard-char-ascii 219 "{^U}")  ; U with circumflex accent
(standard-char-ascii 220 "{\"U}") ; U with diaeresis or umlaut mark
(standard-char-ascii 221 "{'Y}")  ; Y with acute accent
(standard-char-ascii 222 "{TH}")  ; capital thorn, Icelandic
(standard-char-ascii 223 "{ss}")  ; small sharp s, German
(standard-char-ascii 224 "{`a}")  ; a with grave accent
(standard-char-ascii 225 "{'a}")  ; a with acute accent
(standard-char-ascii 226 "{^a}")  ; a with circumflex accent
(standard-char-ascii 227 "{~a}")  ; a with tilde
(standard-char-ascii 228 "{\"a}") ; a with diaeresis or umlaut mark
(standard-char-ascii 229 "{aa}")  ; a with ring
(standard-char-ascii 230 "{ae}")  ; ae diphthong
(standard-char-ascii 231 "{,c}")  ; c with cedilla
(standard-char-ascii 232 "{`e}")  ; e with grave accent
(standard-char-ascii 233 "{'e}")  ; e with acute accent
(standard-char-ascii 234 "{^e}")  ; e with circumflex accent
(standard-char-ascii 235 "{\"e}") ; e with diaeresis or umlaut mark
(standard-char-ascii 236 "{`i}")  ; i with grave accent
(standard-char-ascii 237 "{'i}")  ; i with acute accent
(standard-char-ascii 238 "{^i}")  ; i with circumflex accent
(standard-char-ascii 239 "{\"i}") ; i with diaeresis or umlaut mark
(standard-char-ascii 240 "{-d}")  ; d with stroke, Icelandic eth
(standard-char-ascii 241 "{~n}")  ; n with tilde
(standard-char-ascii 242 "{`o}")  ; o with grave accent
(standard-char-ascii 243 "{'o}")  ; o with acute accent
(standard-char-ascii 244 "{^o}")  ; o with circumflex accent
(standard-char-ascii 245 "{~o}")  ; o with tilde
(standard-char-ascii 246 "{\"o}") ; o with diaeresis or umlaut mark
(standard-char-ascii 247 "{/}")   ; division sign
(standard-char-ascii 248 "{/o}")  ; o with slash
(standard-char-ascii 249 "{`u}")  ; u with grave accent
(standard-char-ascii 250 "{'u}")  ; u with acute accent
(standard-char-ascii 251 "{^u}")  ; u with circumflex accent
(standard-char-ascii 252 "{\"u}") ; u with diaeresis or umlaut mark
(standard-char-ascii 253 "{'y}")  ; y with acute accent
(standard-char-ascii 254 "{th}")  ; small thorn, Icelandic
(standard-char-ascii 255 "{\"y}") ; small y with diaeresis or umlaut mark

(provide 'iso8859-1-ascii)
