;; Set up case, sort, trans, and syntax tables for ISO 8859/1 character set.
;; Copyright (C) 1987 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;; Written by Howard Gayle.  See case-table.el for details.

(require 'case-table)
(require 'sort-table)

(standard-case-syntax-white  160)     ; NBSP (no-break space)
(standard-case-syntax-punct  161)     ; inverted exclamation mark
(standard-case-syntax-word   162)     ; cent sign
(standard-case-syntax-word   163)     ; pound sign
(standard-case-syntax-word   164)     ; general currency sign
(standard-case-syntax-word   165)     ; yen sign
(standard-case-syntax-symb   166)     ; broken vertical line
(standard-case-syntax-word   167)     ; section sign
(standard-case-syntax-word   168)     ; diaeresis
(standard-case-syntax-symb   169)     ; copyright sign
(standard-case-syntax-word   170)     ; ordinal indicator, feminine
(standard-case-syntax-delims 171 187) ; angle quotation marks
(standard-case-syntax-symb   172)     ; not sign
(standard-case-syntax-symb   173)     ; soft hyphen
(standard-case-syntax-symb   174)     ; registered sign
(standard-case-syntax-word   175)     ; macron
(standard-case-syntax-symb   176)     ; degree sign
(standard-case-syntax-symb   177)     ; plus or minus sign
(standard-case-syntax-word   178)     ; superscript two
(standard-case-syntax-word   179)     ; superscript three
(standard-case-syntax-word   180)     ; acute accent
(standard-case-syntax-symb   181)     ; micro sign
(standard-case-syntax-word   182)     ; pilcrow
(standard-case-syntax-symb   183)     ; middle dot
(standard-case-syntax-word   184)     ; cedilla
(standard-case-syntax-word   185)     ; superscript one
(standard-case-syntax-word   186)     ; ordinal indicator, masculine
;;    	       	     	     187      ; See 171 above.
(standard-case-syntax-symb   188)     ; fraction one-quarter
(standard-case-syntax-symb   189)     ; fraction one-half
(standard-case-syntax-symb   190)     ; fraction three-quarters
(standard-case-syntax-punct  191)     ; inverted question mark
(standard-case-syntax-pair   192 224) ; A with grave accent
(standard-case-syntax-pair   193 225) ; A with acute accent
(standard-case-syntax-pair   194 226) ; A with circumflex accent
(standard-case-syntax-pair   195 227) ; A with tilde
(standard-case-syntax-pair   196 228) ; A with diaeresis or umlaut mark
(standard-case-syntax-pair   197 229) ; A with ring
(standard-case-syntax-pair   198 230) ; AE diphthong
(standard-case-syntax-pair   199 231) ; C with cedilla
(standard-case-syntax-pair   200 232) ; E with grave accent
(standard-case-syntax-pair   201 233) ; E with acute accent
(standard-case-syntax-pair   202 234) ; E with circumflex accent
(standard-case-syntax-pair   203 235) ; E with diaeresis or umlaut mark
(standard-case-syntax-pair   204 236) ; I with grave accent
(standard-case-syntax-pair   205 237) ; I with acute accent
(standard-case-syntax-pair   206 238) ; I with circumflex accent
(standard-case-syntax-pair   207 239) ; I with diaeresis or umlaut mark
(standard-case-syntax-pair   208 240) ; D with stroke, Icelandic eth
(standard-case-syntax-pair   209 241) ; N with tilde
(standard-case-syntax-pair   210 242) ; O with grave accent
(standard-case-syntax-pair   211 243) ; O with acute accent
(standard-case-syntax-pair   212 244) ; O with circumflex accent
(standard-case-syntax-pair   213 245) ; O with tilde
(standard-case-syntax-pair   214 246) ; O with diaeresis or umlaut mark
(standard-case-syntax-symb   215)     ; multiplication sign
(standard-case-syntax-pair   216 248) ; O with slash
(standard-case-syntax-pair   217 249) ; U with grave accent
(standard-case-syntax-pair   218 250) ; U with acute accent
(standard-case-syntax-pair   219 251) ; U with circumflex accent
(standard-case-syntax-pair   220 252) ; U with diaeresis or umlaut mark
(standard-case-syntax-pair   221 253) ; Y with acute accent
(standard-case-syntax-pair   222 254) ; thorn, Icelandic
(standard-case-syntax-word   223)     ; small sharp s, German
(standard-case-syntax-symb   247)     ; division sign
(standard-case-syntax-word   255)     ; small y with diaeresis or umlaut mark

(set-standard-case-fold-table (new-sort-table '(
(0 . 31)
(32 ?)
(33 . 64)
(?A ?a)
(? ?)
(? ?)
(? ?)
(? ?)
(? ?)
(? ?)
(? ?)
(?B ?b)
(?C ?c)
(? ?)
(?D ?d)
(?E ?e)
(? ?)
(? ?)
(? ?)
(? ?)
(?F ?f)
(?G ?g)
(?H ?h)
(?I ?i)
(? ?)
(? ?)
(? ?)
(? ?)
(? ?)
(?J ?j)
(?K ?k)
(?L ?l)
(?M ?m)
(?N ?n)
(? ?)
(?O ?o)
(? ?)
(? ?)
(? ?)
(? ?)
(? ?)
(? ?)
(?P ?p)
(?Q ?q)
(?R ?r)
(?S ?s)
(?T ?t)
(?U ?u)
(? ?)
(? ?)
(? ?)
(? ?)
(?V ?v)
(?W ?w)
(?X ?x)
(?Y ?y)
(? ?)
(? ?)
?
?
(?Z ?z)
(91 . 96)
(123 . 159)
(161 . 191)
?
?
)))

(provide 'iso8859-1)
