;; Display a buffer in rot13.
;; Copyright (C) 1987 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;; Written by Howard Gayle.  See case-table.el for details.

;; This hack is mainly to show off the char table stuff.

(defvar rot13-char-table nil "Char table for rot 13 display.")

(if rot13-char-table nil
   (setq rot13-char-table (copy-char-table))
   (let* (
	 (i ?A)       ; Current character.
	 (j (+ i 13)) ; Rotated character.
	 )
      (while (<= i ?Z)
	 (put-char-table-dispr rot13-char-table j
	    (get-char-table-dispr (default-value 'buffer-char-table) i))
	 (setq i (1+ i))
	 (setq j (if (= j ?Z) ?A (1+ j)))
      )
      (setq i ?a)
      (setq j (+ i 13))
      (while (<= i ?z)
	 (put-char-table-dispr rot13-char-table j
	    (get-char-table-dispr (default-value 'buffer-char-table) i))
	 (setq i (1+ i))
	 (setq j (if (= j ?z) ?a (1+ j)))
      )
   )
)

(defun rot13-other-window ()
   "Display current buffer in rot 13 in another window."
   (interactive)
   (if (one-window-p t) (split-window-vertically))
   (let	 (
      	 (w (get-lru-window))
      	 )
      (save-excursion
      	 (beginning-of-line)
	 (set-window-buffer w (current-buffer))
	 (set-window-start w (point) t)
	 (set-window-char-table rot13-char-table w)
      )
   )
)

(provide 'rot13)
