;; Miscellaneous functions for dealing with Swedish.
;; Copyright (C) 1987, 1990 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;; Written by Howard Gayle.  See case-table.el for details.

;; See iso8859-1-swedish.el for a description of the character set.

(require 'iso8859-1)
(require 'sort-table)
(require 'text-mode)

(defvar 8859-to-swascii-trans nil "8859 to SWASCII trans table.")
(if 8859-to-swascii-trans nil
   (setq 8859-to-swascii-trans (make-trans-table))
   (set-trans-table-to 164 ?$  8859-to-swascii-trans)
   (set-trans-table-to 196 ?[  8859-to-swascii-trans)
   (set-trans-table-to 197 ?]  8859-to-swascii-trans)
   (set-trans-table-to 201 ?@  8859-to-swascii-trans)
   (set-trans-table-to 214 ?\\ 8859-to-swascii-trans)
   (set-trans-table-to 220 ?^  8859-to-swascii-trans)
   (set-trans-table-to 228 ?{  8859-to-swascii-trans)
   (set-trans-table-to 229 ?}  8859-to-swascii-trans)
   (set-trans-table-to 233 ?`  8859-to-swascii-trans)
   (set-trans-table-to 246 ?|  8859-to-swascii-trans)
   (set-trans-table-to 252 ?~  8859-to-swascii-trans)
)

(defun 8859-to-swascii-buffer ()
   "Convert characters in buffer from ISO 8859/1 to
Swedish/Finnish version of ISO 646."
   (interactive "*")
   (translate-region (point-min) (point-max) 8859-to-swascii-trans)
)

(setq mail-send-hook  '8859-to-swascii-buffer)

(setq swedish-case-distinct-table (new-sort-table '(
(0 . 31)
(32 ?)
(33 . 64)
(?A ? ? ? ?)
?
?B
?D
?
(?E  ?  ?  ?  ?)
(?F . ?H)
(?I ? ? ? ?)
?J
(?C ? ?K)
?L
?M
(?N ?)
(?O ? ? ? ?)
(?P . ?T)
?
(?U ? ? ? ?)
(?V ?W)
?X
(?Y ?)
?Z
?
?
(? ?)
(91 . 96)
(?a ? ? ? ?)
?
?b
?d
?
(?e ? ? ? ?)
(?f . ?h)
(?i ? ? ? ?)
?j
(?c ? ?k)
?l
?m
(?n ?)
(?o ? ? ? ?)
(?p . ?s)
?
?t
?
(?u ? ? ? ?)
(?v ?w)
?x
(?y ? ?)
?z
?
?
(? ?)
(123 . 159)
(161 . 191)
?
?
)))

(setq swedish-case-fold-table (new-sort-table '(
(0 . 31)
(32 ?)
(33 . 64)
(?A ? ? ? ? ?a ? ? ? ?)
(? ?)
(?B ?b)
(?D ?d)
(? ?)
(?E ? ? ? ? ?e ? ? ? ?)
(?F ?f)
(?G ?g)
(?H ?h)
(?I ? ? ? ? ?i ? ? ? ?)
(?J ?j)
(?C ? ?c ? ?K ?k)
(?L ?l)
(?M ?m)
(?N ? ?n ?)
(?O ? ? ? ? ?o ? ? ? ?)
(?P ?p)
(?Q ?q)
(?R ?r)
(?S ?s)
?
(?T ?t)
(? ?)
(?U ? ? ? ? ?u ? ? ? ?)
(?V ?v ?W ?w)
(?X ?x)
(?Y ? ?y ? ?)
(?Z ?z)
(? ?)
(? ?)
(? ? ? ?)
(91 . 96)
(123 . 159)
(161 . 191)
?
?
)))

(defvar swedish-mode-abbrev-table nil
   "Abbrev table used while in swedish mode.")
(define-abbrev-table 'swedish-mode-abbrev-table ())

(defun swedish-mode ()
   "Major mode for editing Swedish text intended for humans to
read.  Special commands:\\{text-mode-map}
Turning on swedish-mode calls the value of the variable
text-mode-hook, if that value is non-nil."
   (interactive)
   (kill-all-local-variables)
   (use-local-map text-mode-map)
   (setq mode-name "Swedish")
   (setq major-mode 'swedish-mode)
   (setq local-abbrev-table swedish-mode-abbrev-table)
   (set-syntax-table text-mode-syntax-table)
   (set-case-distinct-table swedish-case-distinct-table)
   (set-case-fold-table swedish-case-fold-table)
   (run-hooks 'text-mode-hook)
)

(defun indented-swedish-mode ()
   "Major mode for editing indented Swedish text intended for
humans to read.\\{indented-text-mode-map}
Turning on indented-swedish-mode calls the value of the
variable text-mode-hook, if that value is non-nil."
   (interactive)
   (kill-all-local-variables)
   (use-local-map text-mode-map)
   (define-abbrev-table 'swedish-mode-abbrev-table ())
   (setq local-abbrev-table swedish-mode-abbrev-table)
   (set-syntax-table text-mode-syntax-table)
   (make-local-variable 'indent-line-function)
   (setq indent-line-function 'indent-relative-maybe)
   (use-local-map indented-text-mode-map)
   (setq mode-name "Indented Swedish")
   (setq major-mode 'indented-swedish-mode)
   (set-case-distinct-table swedish-case-distinct-table)
   (set-case-fold-table swedish-case-fold-table)
   (run-hooks 'text-mode-hook)
)

(provide 'swedish)
