;;; Set up ID Systems Corporation ID-100V terminal.

(require 'iso8859-1-ascii)
(require 'char-table-vt100)
(require 'keypad)
(require 'vt100-led)

(defvar CSI-map nil
  "The CSI-map maps the CSI function keys on the keyboard.
The CSI keys are the arrow keys.")

(if (not CSI-map)
    (progn
     (setq CSI-map (lookup-key global-map "\e["))
     (if (not (keymapp CSI-map))
	 (setq CSI-map (make-sparse-keymap)))  ;; <ESC>[ commands
     (setup-terminal-keymap CSI-map '(
        ("A"   . ?u) ; up arrow
	("B"   . ?d) ; down-arrow
	("C"   . ?r) ; right-arrow
	("D"   . ?l) ; left-arrow
	("H"   . ?h) ; home
))))

(defun enable-arrow-keys ()
  "Enable the use of the ID-100 arrow keys for cursor motion.
Because of the nature of the ID-100, this unavoidably breaks
the standard Emacs command ESC [; therefore, it is not done by default,
but only if you give this command."
  (interactive)
  (global-set-key "\e[" CSI-map)
)

(defvar SS3a-map nil
  "SS3a-map maps the SS3 function keys on the ID-100 keyboard.
The SS3 keys are the numeric keypad keys in keypad application mode
\(DECKPAM).  SS3 is DEC's name for the sequence <ESC>O which is
the common prefix of what these keys transmit.")

(if (not SS3a-map)
    (progn
     (setq SS3a-map (lookup-key global-map "\eO"))
     (if (not (keymapp SS3a-map))
	 (setq SS3a-map (make-keymap)))  ;; <ESC>O commands
     (setup-terminal-keymap SS3a-map
	    '(("A" . ?u)	   ; up arrow
	      ("B" . ?d)	   ; down-arrow
	      ("C" . ?r)	   ; right-arrow
	      ("D" . ?l)	   ; left-arrow
	      ("M" . ?e)	   ; Enter
	      ("P" . ?\C-a)	   ; PF1
	      ("Q" . ?\C-b)	   ; PF2
	      ("R" . ?\C-c)	   ; PF3
	      ("S" . ?\C-d)	   ; PF4
	      ("l" . ?,)	   ; ,
	      ("m" . ?-)	   ; -
	      ("n" . ?.)	   ; .
	      ("p" . ?0)	   ; 0
	      ("q" . ?1)	   ; 1
	      ("r" . ?2)	   ; 2
	      ("s" . ?3)	   ; 3
	      ("t" . ?4)	   ; 4
	      ("u" . ?5)	   ; 5
	      ("v" . ?6)	   ; 6
	      ("w" . ?7)	   ; 7
	      ("x" . ?8)	   ; 8
	      ("y" . ?9)))))       ; 9

(defun keypad-application-mode ()
  "Switch on keypad application mode."
  (interactive)
  (send-string-to-terminal "\e=")
  (global-set-key "\eO" SS3a-map))

(defvar SS3n-map nil
  "SS3n-map maps the SS3 function keys on the ID-100 keyboard.
The SS3 keys are the numeric keypad keys in keypad numeric mode
\(DECKPAM).  SS3 is DEC's name for the sequence <ESC>O which is
the common prefix of what these keys transmit.")

(if (not SS3n-map)
    (progn
     (setq SS3n-map (lookup-key global-map "\eO"))
     (if (not (keymapp SS3n-map))
	 (setq SS3n-map (make-sparse-keymap)))  ;; <ESC>O commands
     (setup-terminal-keymap SS3n-map '(
	      ("P" . ?\C-a)	   ; PF1
	      ("Q" . ?\C-b)	   ; PF2
	      ("R" . ?\C-c)	   ; PF3
	      ("S" . ?\C-d)	   ; PF4
     ))
    (global-set-key "\eO" SS3n-map)
))

(standard-char-graphic   176 ?f) ; degree sign
(standard-char-graphic   177 ?g) ; plus or minus sign
(standard-char-graphic   183 ?~) ; middle dot
(standard-frameg-graphic ?x)     ; Vertical bar.
(standard-truncg-graphic ?t)     ; Left T.
(standard-wrapg-graphic  ?k)     ; Upper right corner.

(setq start-emphasis "\e[4m") ; Foreground yellow.
(setq stop-emphasis  "\e[m")  ; Foreground white.
