;; Functions for dealing with trans tables.
;; Copyright (C) 1987 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;; Written by Howard Gayle.  See case-table.el for details.

(require 'case-table)

(defun describe-downcase-table ()
   "Describe the downcase table of the current buffer."
   (interactive)
   (describe-trans-table (downcase-table))
)

(defun describe-trans-table (tt)
   "Describe the given trans table in a help buffer.  Don't
mention identity translations."
   (let  (
      	 (i 0) ; Current character.
	 j     ; Translated character.
	 )
      (with-output-to-temp-buffer "*Help*"
	 (while (<= i 255)
	    (setq j (get-trans-table-to i tt))
	    (if (not (= i j))
	       (progn
	       	  (describe-character i)
		  (princ "->")
	       	  (describe-character j)
		  (princ "\n")
	       )
	    )
	    (setq i (1+ i))
	 )
	 (print-help-return-message)
      )
   )
)

(defun describe-upcase-table ()
   "Describe the upcase table of the current buffer."
   (interactive)
   (describe-trans-table (upcase-table))
)

(provide 'trans-table)
