/* Declarations for case tables.
   Copyright (C) 1987, 1990 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Written by Howard Gayle.  See chartab.c for details. */

#define NULL_CASE_TABLE ((struct Lisp_Casetab *) 0)

/* The following macros extract case table information: */
#define CASETAB_CASE(c,t)     (t->cas_case[c])
#define CASETAB_ISNOCASE(c,t) (nocase_e    == CASETAB_CASE(c,t))
#define CASETAB_ISLOWER(c,t)  (lowercase_e == CASETAB_CASE(c,t))
#define CASETAB_ISUPPER(c,t)  (uppercase_e == CASETAB_CASE(c,t))

/* Each buffer has an associated case table.  The following
macros use the case table of the current buffer: */
#define LOCAL_CASE(c) 	  CASETAB_CASE (c, current_buffer->case_table_v)
#define LOCAL_ISNOCASE(c) (nocase_e    == LOCAL_CASE(c))
#define LOCAL_ISLOWER(c)  (lowercase_e == LOCAL_CASE(c))
#define LOCAL_ISUPPER(c)  (uppercase_e == LOCAL_CASE(c))

/* There is also a standard case table, that is used whenever no
buffer case table is appropriate.  The following macros use the
standard case table: */
#define UPPERCASEP(c) (uppercase_e==buffer_defaults.case_table_v->cas_case[c])
#define LOWERCASEP(c) (lowercase_e==buffer_defaults.case_table_v->cas_case[c])
