/* Declarations for character tables.
   Copyright (C) 1987, 1990 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Written by Howard Gayle.  See chartab.c for details. */

/* The following definitions are placed here in order to ease
future modifications: */
#define HTAB    ('\t')
#define HYPHEN  ('-')
#define NEWLINE ('\n')
#define SPACE   (' ')

/* There are two built-in character tables, one that displays
control characters with backslash followed by an octal number,
and one that displays them with ^.  Both start off initialized
for ASCII, but can be modified. */
extern Lisp_Object Vctl_arrow_char_table;

#define NULL_CHAR_TABLE ((struct Lisp_Chartab *) 0)

/* Each window has a char table.  This macro returns the char
table of the selected window: */
#define SELECTED_CHAR_TABLE XCHARTAB ((XWINDOW (selected_window)->window_char_table))

/* This macro returns the char table of the given window. */
#define WINDOW_CHAR_TABLE(w) XCHARTAB (w->window_char_table)

Lisp_Object check_char_table ();

/* The length of the rope corresponding to character c in char table t: */
#define ROPE_LEN(c,t) (t->ct_dispr[c].r_len)

/* A glyf is represented as an index in glyf_table[].  The
first byte gives the length, followed by the characters in the
glyf.  There is no NUL at the end. */
extern char_t *glyf_table;

#define SPACEGLYF ((1 << 8) + ' ') /* Glyf for a space. */

int     glyf_len(); /* Length of a glyf. */
char_t *glyf_str(); /* Pointer to first byte in glyf. */
