/* GNU Emacs routines to deal with miscellaneous Lisp table objects.
   Copyright (C) 1987 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Written by Howard Gayle.  See chartab.c for details. */

#include "config.h"
#include "lisp.h"
#include "etctab.h"

struct Lisp_Etctab *all_etc_tables;

/* Return the char_t encoded by a Lisp integer.  Check for errors. */
char_t
get_char_arg (obj)
register Lisp_Object obj;
{
register int i;

CHECK_NUMBER (obj, 1);
i = XINT (obj);
if ((i < 0) || (i > 255)) arg_out_of_range (obj);
return ((char_t) i);
}

/* Allocate a new table. */
Lisp_Object
make_etc_table (bytes, kind)
register int   bytes; /* Size of object. */
enum Lisp_Type kind;  /* Type of object. */
{
register struct Lisp_Etctab *p; /* Points to the new table. */
register Lisp_Object         z; /* Return. */
static int     	     	     serial; /* Serial number. */

if (bytes <= sizeof (struct Lisp_Etctab)) abort ();
p = (struct Lisp_Etctab *) malloc (bytes);
consing_since_gc += bytes;
if (p == ((struct Lisp_Etctab *) 0)) memory_full ();
p->etc_ser = ++serial;
p->etc_next = all_etc_tables;
all_etc_tables = p;
XSET (z, kind, p);
return (z);
}
