/* Declarations for sort tables.
   Copyright (C) 1987 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Written by Howard Gayle.  See chartab.c for details. */

#define NULL_SORT_TABLE ((struct Lisp_Sorttab *) 0)

/* Each buffer has two sort tables: one for use when
case-fold-search is nil, and another for use when it is not
nil.  The following function returns the appropriate sort table: */
struct Lisp_Sorttab *current_sort_table ();

/* Each sort table contains an equivalence class table that
maps characters to their corresponding equivalence classes.
The following function returns the equivalence class table for
the current sort table: */
char_t *current_equiv_class_table ();
