/* Declarations for translate tables.
   Copyright (C) 1987 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Written by Howard Gayle.  See chartab.c for details. */

#define NULL_TRANS_TABLE ((struct Lisp_Transtab *) 0)

/* Associated with each buffer are two trans tables, one for
conversion to lower case and one for upper case.  The following
macros use those tables: */
#define LOCAL_TOLOWER(c) (current_buffer->downcase_table_v->trt_to[c])
#define LOCAL_TOUPPER(c) (current_buffer->upcase_table_v->trt_to[c])

/* There are also standard upper and lower case conversion
tables that are used whenever no buffer trans tables are
appropriate.  The following macros use the standard trans tables: */
#define DOWNCASE(c) (buffer_defaults.downcase_table_v->trt_to[c])
#define UPCASE(c)   (buffer_defaults.upcase_table_v->trt_to[c])
