> /***	LASER - A Single-Threaded Asynchronous Symbiont to driver *		an Apple LaserWriter  * 8 *	Copyright 1987-1990, The University of Texas at Austin * 	 * Author:  * 	Rick Watson= *   	The University of Texas Computation Center, 512/471-3241 D *   	internet: watson@utadnx.cc.utexas.edu     bitnet: watson@utadnxM *   	uucp:     ...!cs.utexas.edu!ut-emx!rick   span:   utspan::utadnx::watson  * 
 *	Revised: *	Steve Roseman  *	lusgr@vax1.cc.lehigh.edu * 
 *	Mark London  *	mrl@tardis.pfc.mit.edu *  *	Tony Brack *	brack@agrajag.yorku.ca * B *	This user-writter symbiont is tailored specifically to the AppleD *	LaserWriter and similar PostScript printers.  It has the following *	features:  * = *	1. Page counting is done by reading the page count from the ; *	   laserwriter at the beginning and the end of each file. = *	   This mechanism also "synchronizes" the user job with the = *	   laserwriter.  If the laserwriter does not respond to the > *	   first request for a page count, the symbiont notifies the> *	   operator, and continues to poll the laserwriter.  This is> *	   useful if the laserwriter is being shared with MAC users. * @ *	2. Parameters may be passed to postscript modules in the setupC *	   library via 2 mechanisms.  The text from a $PRINT /NOTE=<text>   *	   command will be sent first. * ? *	   The /PARAMETER switch may also be used.  Each entry can be > *	   one of two formats. An entry without the "=" character in? * 	   it is sent as (param<n>) <parameter>.  An entry with the  ? *	   "=" character in is is sent as (<left side>) <right side>. : *	   The parameters are defined in an array called /param.; *	   Example:  /PARAMETER=(1,SIZE=5,"str=(a+b)") generates: 1 *	   /param [(param1) 1 (size) 5 (str) (a+b)] def D *	   All alphabetics are forced to lower case.  Using the /PARAMETER? *	   switch forces sending PARSER from LASER.TLB as part of the 6 *	   PostScript program sent to the printer.  Look at > *	   other files in LASER.TLB for examples of using the PARSER *	   module. * @ *	3. If the name of a setup module ends with "_HEX" the file to C *	   be printed is "hexified" to the laser printer.  This is useful 3 *	   for sending bitimage files to the laserwriter.  * ; *	4. A log of responses from the laserwriter is created if  5 *	   /PARAMETER=MESSAGE=KEEP is specified .  This is  C *	   useful for debugging postscript programs.  The file is created A *	   as <printfilespec>.LASER_LOG.  These files are automatically  *	   deleted if empty. * ? *	5. A "%%[ Flushing:" response from the printer will abort the  *	   current file. * C *	6. Spooled files:  Spooled files normally default to FORMS=LETTER ? *	   if the recommended queue initialize procedure is followed. ? *	   By specifying special filenames, the user can override the 9 *	   forms used, and pass parameters to the setup module. 4 *	   The syntax is:  "_<formname>._<parameter list>"6 *	   where <formname> is the name of a form to use and@ *	   <parameter list> is of the form: <parameter>-<value>[_...].: *	   (Note the use of "-" instead of "=" for a separator.)? *	   For example:  $ copy zeta.plt alw:_zeta._ncopies-5_scale-2 & *	   (The kludge of the century, huh?) * 6 *	Outputs (in the following order) to the laserwriter: * " *	1. "/note <notestring> def\r\n".F *	2. /param definition and library module PARSER if /parameter switch  *	   presentG *	3. If the setup module is "HEADERS", the string "/filename <filename> , *	   def" and "/formname <name of form> def"7 *	3. The first file or forms setup module if specified. E *	4. The file to be printed itself.  If the setup module name ends in 9 *	   "_HEX" the file is hex-ified to the printer instead.  * B *	where: <notestring> is the string from $PRINT /NOTE=<notestring>G *	       <paramstring> is the string from $PRINT /PARAM=("<string>"...) D *	       <filename> is the file specification for the file to print. *  *	Limitations, bugs, etc:  *  *	1. No checkpointing is done.C *	2. $PRINT/COPIES=n sends the job to the LaserWriter n times. This B *	   is not optimal, but is how the job controller handles things.A *	   It makes sense for most printers.  Multiple copy handling is @ *	   better handled in most of the postscript setup files.  Also. *	   /note="/#copies n def" will usually work.' *	3. $PRINT/SPACE=n is not implemented. " *	4. /BURST is identical to /FLAG., *	5. Does not handle lists of setup modules. *  *	Recommended device setup:  * E *	$ define/system/exec/trans=(concealed,terminal) alw <term>: ! laser ; *	$ set term /perm /speed=9600 /nomodem /notype /nohang alw D *	$ set term /perm /hostsync /pasthru /ttsync /eightbit /nobroad alw *	$ set term /perm /noauto alw *	$ set prot=o:rwlp /dev alw0 *	$ set device /spooled=(ALW,sys$sysdevice:) alw *  *	Recommended queue initialize:  *  *	$ initialize/queue/start -; *	/default=(noburst,nofeed,noflag,notrailer,form=headers) - ' *	/separate=(noburst,noflag,trailer) -   *	/library=laser /form=letter -  *	/processor=laser /on=alw: alw  * H * NOTE: change /separate=(...trailer) to (...flag) if your laser printer *       stacks right side up.  *  * Revisions: * J *	15-Jul-1991 T. Brack	- Converted header file inclusions to be compatible. *				  with and use those provided by VAXC 3.2> *	11-Sep-1991 T. Brack	- Added code to retrieve the queue name6 *				- Added support for calling TCP/IP served devices: *			          with /ON="TCP%servername:port" (a.k.a. cisco *				  & MultiNET)I *	01-Oct-1991 T. Brack	- Moved the cancel from before the test for end of 7 *				  job, to inside it so we don't cancel Inputs from * *				  a printer we're still interested in4 *				- Replace postlaserread and laser_read_ast with8 *				  "new improved" versions, making local data static6 *				  and performing internal interpretation of break% *				  characters (needed for TCP/IP) 8 *				- Replaced numerous calls to SYS$SNDOPR with a more6 *				  "C" friendly routine. Also fixes bugs in string *				  length computations. 0 *				- Prefix OPCOM messages with the queue name5 *				- Add "reason" messages to some of the new error - *				  messages - should retrofit more later. 1 *				- Use the UCX compatible TCP/IP interface of 1 *				  MultiNET 3.0 and don't rely on TGV's NLPn: 4 *				  kluge, so that we are portable and don't have5 *				  to do lots of translations - haven't tested it  *				  with UCX though... 6 *				- Added conditional compiles for MultiNET so that3 *				  we can check for error codes and signal them * *				  since vmserrno IS MultiNET specificG *	03-Oct-1991 T. Brack	- removed the aforementioned $CANCEL completely, 0 *				  since the $DASSGN takes care of it anyway6 *				- it is not sufficent to retry "connect()" calls,4 *				  the "socket()" call must also be repeated for. *				  retries to work... make it so number 1!N *	09-Oct-1991 T. Brack    - deassign the channel after failed connect attempts *				  for MultiNET T *       07-Nov-1991 T. Brack    - rewrote openuserlog() so that it puts files in theV *                                 user's default directory instead of wherever it cameV *                                 from. Only if we can't find his default directory do9 *                                 we put it in LASER$LOG. T *                               - changed the log file extension to "LOG-PS" so thatP *                                 people can search for *.LOG*... a minor point!; *	9/25/92	MRL		- Fixed BRACK's new laser_read_ast which did 1 *				  not work with non-tcp connection properly. 0 *				- Fixed getdvi to work with spooled device.1 *				- Added hook to allow sharing of tcp device. 2 *				- Added hook to allow using it without device *				  being able to respond. - *				- Added BYPASS privs, as could not print . *				  files without system access protection.- *				- STOP/QUEUE/RESET now properly causes a ' *				  disconnection of the LTA device. / *				- An abnormal LTA disconnection now simply . *				  causes the job to abort rather than the *				  symbiont stopping. 0 *				- Changed code so that the read qio is only, *				  canceled and reissued when necessary., *				  This was causing LTA queues to stall. *  */   #include descrip #include dcdef #include dvidef  #include errno #include fscndef #include prvdef  #include rms #include in  #include iodef #include lbrdef  #include netdb #include opcdef  #include quidef  #include ttdef #include ctype #include socket  #include ssdef #include stddef  #include stdio #include stdlib  #include uaidef  #include brkdef    #include "iosb"  #include "itemlist"  #include "returncodes"   #include "smbdef.h"    #define TRUE	1 #define FALSE	0    #define DEBUG	 FALSE   #if MULTINET2 #include "multinet_root:[multinet.include]errno.h" #endif  	 #if DEBUG  FILE    debug;   #endif  : #define MAXITEMS 60			/* max expected items from jobctl */* #define min(a,b) ( ((a)<(b)) ? (a) : (b) )+ #define max(a,b) ( ((a)>(b)) ? (a) : (b) )    . #define WRITELASER(p1,p2) {if (!io_aborted) {\; stat = sys$qiow(0,laserchan, IO$_WRITEPBLK, &w_iosb, 0, 0,\ ; p1, p2, 0, 0, 0, 0);if (!(stat & 1 && w_iosb.status & 1)) \ 3 {io_aborted = !(stat & 1) ? stat : w_iosb.status; \ C if (!stop_task) stop_task = io_aborted; return FALSE;} iocount++;}}   K #define WRITELASERBUF(p1,p2) {{if (!io_aborted) olen = p2;while (olen > 0)\ < {stat = sys$qiow(0,laserchan, IO$_WRITEPBLK, &w_iosb, 0, 0,\O p1+p2-olen, min(1536,olen), 0, 0, 0, 0);if (!(stat & 1 && w_iosb.status & 1)) \ 3 {io_aborted = !(stat & 1) ? stat : w_iosb.status; \ I if (!stop_task) stop_task = stat; return FALSE;} olen -= min(1536,olen);\ 
 iocount++;}}}   1 #define WRITESTRING(p1) WRITELASER(p1,strlen(p1))   , short laserchan;			/* laserwriter channel */ 	 2 globalvalue LASER$_STREAMNOTSTART,LASER$_MAXITEMS,3 	    LASER$_CREATELOG,LASER$_STARTJOB,LASER$_ERROR, 4 	    LASER$_STALLED,LASER$_RESUMED,LASER$_NOMEMORY, , 	    LASER$_ITEMNOTFOUND,LASER$_TOOMANYTABS,> 	    LASER$_USERDATA,LASER$_JOBID,LASER$_TIMEOUT,LASER$_ABORT,+ 	    LASER$_NOTRESOLVED,LASER$_CONNREFUSED, 9 	    LASER$_FLUSHED,LASER$_SETUPNOTFOUND,LASER$_INVPARAM;    void dassgndev();  void assigndev(); 5 void jobctl_ast();			/* job controller ast routine */  void ltatimeout(); void statetimeout();   struct { 	int	item_code;		/* code */ . 	unsigned short 	item_size;	/* size of item */% 	char	*buffer;		/* address of item */  } item[MAXITEMS];   * struct io$status_block w_iosb = {0, 0, 0};  % int stop_task;			/* stop task flag */ - int stop_reason;		/* stop task reason code */ - int spooled_file;		/* TRUE if spooled file */ , int laser_efn;			/* laser read event flag */& int startpage;			/* task start page */" int endpage;			/* task end page */$ int jobstart;			/* job start page */( int ansi;			/* TRUE if ansi specified */* int ascii;			/* TRUE if ascii main file */+ int hex;			/* TRUE if hexified main file */ , int tek;			/* TRUE if tektronix main file */- int ps;				/* TRUE if postscript main file */ , int string;			/* TRUE if string main file */4 int status_idle;		/* TRUE if idle status received */7 int status_error;		/* TRUE if error message received */ 7 int land;                       /* TRUE if landscape */ 6 int port;                       /* TRUE if portrait */ int notify_qual; int nup;	 int olen;  int end_sent = FALSE;  int cancel_read = TRUE;  char queue_name[128];  int iocount,oldiocount; 3 unsigned short laser_iosb[4];	/* laser read iosb */ . char laser_buf[1024];		/* laser read buffer *// struct FAB main_fab;		/* main file rms stuff */  struct NAM main_nam; struct RAB main_rab;- struct FAB log_fab;		/* log file rms stuff */  struct RAB log_rab;   L struct dsc$descriptor_d library_spec = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};J struct dsc$descriptor_d buffer_des = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};G struct dsc$descriptor_d savelog = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; ' int userlog = -1;			/* user log file */  int notify = FALSE;   F static char msg[255] = "\007\007\007\r\n";	/* error message to user */J struct dsc$descriptor_s errmsg_dsc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};  = char user_text[20];		/* user name to send error message to */ T struct dsc$descriptor_s user_notify = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, &user_text};   int ii = 0;				/* item index */ / int start_task = FALSE;			/* start task flag */ 9 int patchneeded = FALSE;		/* TRUE if patch module sent */  int io_aborted = FALSE;  int stopoutput = FALSE;  int shared_device = FALSE; int lta_device = FALSE;  int ltaefn = 0,stateefn;5 int statetime[2]= {-1*1800000000,-1};	/* 3 minutes */  int jobnum = -1,entry_num; short msglen = 0;  char message[257]; struct dsc$descriptor_s msgd == 		{sizeof(message)-1, DSC$K_DTYPE_T, DSC$K_CLASS_S, message}; - struct {				/* operator message to printer */      char type;     char target;     short fill;      long id;     char text[257]; 0 } oprmsg = {OPC$_RQ_RQST, OPC$M_NM_PRINT, 0, 0};  % struct dsc$descriptor_s oprmsg_dsc =  , 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, &oprmsg};  F struct dsc$descriptor_s device = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};   struct {     unsigned long class;      unsigned long read_function;!     unsigned long write_function;      void   *terminators; }       devinfo;   main() { 
 	int stat; 	laserchan = 0;  	 ' 	preset();				/* initialize symbiont */  	  	do {   2 		while (!start_task) {		/* wait for start_task */ 			stat = sys$hiber();% 			checkstat(stat,"wait start_task");  		}   ! 		processtask();			/* do a job */  	} while (TRUE); }    getmsg(errmsg,addpercent)  int errmsg,addpercent; { 
 	int stat;2 	stat = sys$getmsg(errmsg, &msglen, &msgd, 15, 0); 	checkstat(stat,"$getmsg");  	message[msglen] = 0;  	if (addpercent) msg[5] = '%'; }    sndmsg(type,bells) int type,bells;  {  	int i;  /*	sys$setrwm(1); */+ 	errmsg_dsc.dsc$w_length = strlen(msg) - 5; $ 	errmsg_dsc.dsc$a_pointer = &msg[5]; 	if (type) {8 		oprmsg_dsc.dsc$w_length = errmsg_dsc.dsc$w_length + 8;/ 		strncpy(oprmsg.text,errmsg_dsc.dsc$a_pointer,  			errmsg_dsc.dsc$w_length); 		sys$sndopr(&oprmsg_dsc, 0);  	}$ 	errmsg_dsc.dsc$w_length += 5*bells;% 	errmsg_dsc.dsc$a_pointer -= 5*bells; 9 	if (type != 2) sys$brkthru(0, &errmsg_dsc, &user_notify, /  			BRK$C_USERNAME,0,32,BRK$M_CLUSTER,0,5,0,0); @ 	for (i=5;i<errmsg_dsc.dsc$w_length+5*(1-bells);i++) msg[i] = 0; /*	sys$setrwm(0); */ }    jobid(type) 	 int type;  { E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};  	static char job[255];<         if (getitemdescrip(SMBMSG$K_JOB_NAME, &temp, FALSE))D                 strncpy(job, temp.dsc$a_pointer, temp.dsc$w_length);         else&                 temp.dsc$w_length = 0; 	job[temp.dsc$w_length] = 0; 	getmsg(LASER$_JOBID, 0);  	strcat(msg,"\r\n%"); C 	sprintf(&msg[strlen(msg)],&message[1],&job,entry_num,&queue_name);  	sndmsg(type,0); }   A /**	check_operator - checks for a laserwriter message that should  *			 go to the operator.+ *	returns TRUE if message sent to operator.  */ check_operator() {  	int i,stat;  3 	if (strncmp(laser_buf, "%%[ status: ", 12) == 0) { 8 		if (strncmp(laser_buf, "%%[ status: idle", 16) == 0) { 			status_idle = TRUE; 			sys$wake(0,0);  			return TRUE;  		} else if (status_error) 			return TRUE;	@ 		else if (strncmp(laser_buf, "%%[ status: offline", 19) == 0) {* 			strcpy(&laser_buf[18],&laser_buf[12]); ( 			strcpy(&laser_buf[4],"PrinterError");
 		} else {) 			strcpy(&laser_buf[4],&laser_buf[12]);   			sys$wake(0,0);  		}  	}  7 	if (strncmp(laser_buf,"%%[ PrinterError:", 17) == 0) {  		getmsg(LASER$_ERROR, 0);2 		if (strlen(laser_buf) > 245) laser_buf[245] = 0;" 		strncpy(&msg[5],message,msglen);> 		strncpy(&msg[msglen+5],&laser_buf[17],strlen(laser_buf)-17);. 		jobid(strstr(laser_buf,"Operator") ? 1 : 0); 		status_error = TRUE; 		return TRUE; 	}  ; 	if (strncmp(laser_buf, "%%[ patch needed ]%%", 20) == 0) {  		patchneeded = TRUE;  		return TRUE; 	}  * 	if (strncmp(laser_buf, "stop", 4) == 0) { 		stopoutput = TRUE; 		return TRUE; 	}  2 	if (strstr(laser_buf, "not a known parameter")) {.                 stop_reason = LASER$_INVPARAM; 		return FALSE;  	}  G 	if (strncmp(laser_buf, "%%[ start page #=", 17) == 0 && status_idle) { + 		sscanf(&laser_buf[17], "%d", &startpage); , 		sys$wake(0,0);			/* wakeup sync waiting */ 		return TRUE; 	} 	 G 	if (strncmp(laser_buf, "%%[ end page   #=", 17) == 0 && status_idle) { ) 		sscanf(&laser_buf[17], "%d", &endpage); , 		sys$wake(0,0);			/* wakeup sync waiting */ 		return TRUE; 	}  4 /*  Abort the job if we see "%%[ Flushing:"		     */? /*  Don't override an already existing stop_reason condition */   1 	if (strncmp(laser_buf, "%%[ Flushing:", 13) == 0 2 	    && startpage && status_idle && !stopoutput) {5 		if (stop_reason == 0) stop_reason = LASER$_FLUSHED; $ 		return FALSE;			/* write in log */ 	}  0 	if (strncmp(laser_buf,"%%[ Error:", 10) == 0 &&# 		((status_idle && !stopoutput) ||  # 		strstr(laser_buf,"Operator")) &&  $ 		(userlog == 0 || userlog == -1)) { 		getmsg(LASER$_ERROR, 0);2 		if (strlen(laser_buf) > 245) laser_buf[245] = 0;" 		strncpy(&msg[5],message,msglen);> 		strncpy(&msg[msglen+5],&laser_buf[10],strlen(laser_buf)-10);. 		jobid(strstr(laser_buf,"Operator") ? 1 : 0);" 		if (userlog == -1) userlog = -2; 		status_error = TRUE; 		return FALSE;  	}  ? 	if (!stopoutput && startpage && !stop_reason && !stop_task &&   		isalpha(laser_buf[0])) { 		if (notify_qual) { 			getmsg(LASER$_USERDATA, 0);3 			if (strlen(laser_buf) > 245) laser_buf[245] = 0; # 			strncpy(&msg[5],message,msglen); 7 			strncpy(&msg[msglen+5],laser_buf,strlen(laser_buf));  			jobid(0); 		}  		return TRUE; 	}  + 	if (stopoutput || !startpage) return TRUE;  	return FALSE; }     , /**	checkspooled - check for a spooled file. * > *	If the filename has "[]_" in it, then this is a spooled file< *	that the user wants to specify the form name for. Further,8 *	if the extension starts with "_", then it contains the= *	user parameter list.  We forge the item list to make things 
 *	look right.  */ checkspooled() { E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}; E 	struct dsc$descriptor_d dynd = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  	char *cp, *pp, spoolfile[255];  	int len, i, stat; 	int ourindex;1 	char setup[257];			/* where to put setup name */ $ 	long iosb[2];				/* for $getquiw */0 	short setupl;				/* returned length of setup */) 	struct {				/* item list for $getquiw */  		short	l1;  		short	c1;  		char	*b1;  		long	*r1;  		short	l2;  		short	c2;  		char	*b2;  		long	*r2;  		long	end; ( 	} itmlst = {0,  QUI$_SEARCH_NAME, 0, 0,; 		sizeof(setup)-1, QUI$_FORM_SETUP_MODULES, setup, &setupl,  		0};    	spooled_file = FALSE; 	 ! /*  get the file specification */   H 	if (!getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &temp, FALSE)) return; 	 ; 	strncpy(spoolfile, temp.dsc$a_pointer, temp.dsc$w_length); " 	spoolfile[temp.dsc$w_length] = 0; 		 /*  check for []_ */ 	 , 	if (!(cp = strchr(spoolfile, '['))) return; 	if (!(*++cp == ']')) return; - 	spooled_file = TRUE;			/* file is spooled */  	if (!(*++cp == '_')) return;  	 8 /*  find the extension and terminate the name string */	 	 % 	if (!(pp = strchr(cp, '.'))) return; 	 	*pp = 0;  	cp++;  6 /*  translate the form name into setup module names */8 /*  If it won't translate, then pass on the form name */  . 	itmlst.l1 = strlen(cp);			/* point to name */ 	itmlst.b1 = cp;B 	stat = sys$getquiw(0, QUI$_DISPLAY_FORM, 0, &itmlst, iosb, 0, 0); 	checkstat(stat, "getquiw");2 	if ((iosb[0] & 1) != 1) 		/* if no translation */ 		strcpy(setup, cp); 	else  		setup[setupl] = 0;  @ /*  forge the file setup module to have our setup module name */H /*  Note that the forge transfers the dynamic string "dynd" to "item" */  8 	ourindex = findandclritem(SMBMSG$K_FILE_SETUP_MODULES);1 	dynd.dsc$w_length = 0;		/* get dynamic string */  	dynd.dsc$a_pointer = 0; 	len = strlen(setup);   	str$copy_r(&dynd, &len, setup);C 	item[ourindex].item_size = dynd.dsc$w_length;	/* complete forge */ , 	item[ourindex].buffer = dynd.dsc$a_pointer;  0 /*  forge the form name to have our form name */ 	 / 	ourindex = findandclritem(SMBMSG$K_FORM_NAME); 0 	dynd.dsc$w_length = 0;		/* get dyamic string */ 	dynd.dsc$a_pointer = 0;/ 	len = strlen(cp);			/* pointer to form name */  	str$copy_r(&dynd, &len, cp); C 	item[ourindex].item_size = dynd.dsc$w_length;	/* complete forge */ , 	item[ourindex].buffer = dynd.dsc$a_pointer; 	 / /*  now check to see if there are parameters */   * 	cp = ++pp;				/* set extension address */9 	if (pp = strchr(cp,';')) *pp = 0;	/* terminate at ";" */  	  	for (i = 0; i < 8; i++) {0 		if (*cp != '_') return;		/* check next char */  		cp++;				/* advance over it */  = 		/* if there is another _, point to it, else point to the */  		/* end of the string 					 */ 7 		if ((pp = strchr(cp,'_')) == 0) pp = cp + strlen(cp);   . 		len = pp - cp;			/* find length of string */2 		if (len == 0) continue;		/* if null parameter */   		/*  forge the item */ 4 		ourindex = findandclritem(SMBMSG$K_PARAMETER_1+i);2 		dynd.dsc$w_length = 0;		/* get dynamic string */ 		dynd.dsc$a_pointer = 0;  		str$copy_r(&dynd, &len, cp);/ 		item[ourindex].item_size = dynd.dsc$w_length; - 		item[ourindex].buffer = dynd.dsc$a_pointer;  		
 		cp = pp; 	} }  		 	 ) /**	findandclritem - find and clear item.  * = *	Finds an item in the item list. Releases the dynamic string < *	for that item. If the item doesn't exist in the item list, *	create it. * $ *	return:	index to item in item list */ findandclritem(whichitem)  int whichitem; {  	int i; E 	struct dsc$descriptor_d temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};   3 	for (i = 0; i < ii; i++) {		/* search item list */ , 		if (whichitem == item[i].item_code) break; 	} 	 ' 	if (i == ii) {				/* if end of list */ < 		if (++ii > MAXITEMS) exit(LASER$_MAXITEMS);	/* new item */  		item[i].item_code = whichitem; 		item[i].item_size = 0; 		item[i].buffer = 0;   		return i;			/* return index */ 	}  < 	temp.dsc$w_length = item[i].item_size;	/* release string */% 	temp.dsc$a_pointer = item[i].buffer;  	str$free1_dx(&temp);  	item[i].buffer = 0;
 	return i; }     5 /**	checkstat - check value of system service return.  */ checkstat(stat, string_dummy) 	 int stat;  char *string_dummy;  {	 	if (!(stat & 1)) { ? 		strcpy(&msg[5], "Printer symbiont crashed due to error in "); * 		strcpy(&msg[strlen(msg)], string_dummy); 		strcat(msg,"\r\n");  		getmsg(stat, 0); 		strncat(msg,message,msglen); 		sndmsg(1,1);( 		if (lta_device && jobnum && laserchan)= 			stat = sys$qiow(0, laserchan,IO$_TTY_PORT+IO$M_LT_DISCON,   				0, 0, 0,0, 0, 0, 0, 0, 0); 		if (laserchan) {  			stat = sys$dassgn(laserchan); 			laserchan = 0;  		}  	  	exit(stat); 	         }  }       /**	closefile - close main file. */ closefile()  { 
 	int stat;  # 	stat = sys$close(&main_fab, 0, 0);  	/*  ignore error */   	notify = FALSE; }     ' /**	closeuserlog - close user log file.  */ closeuserlog() { 
 	int stat;  * 	if (userlog < 0) return;		/* if no log */  5 /*  If no records written, set for delete on close */  	 2 	if (userlog == 0) log_fab.fab$l_fop |= FAB$M_DLT;   	stat = sys$close(&log_fab);   	checkstat(stat,"close log");  	 2 	str$free1_dx(&savelog);			/* release saved log */   	userlog = -1; }  	   1 /**	expand_cc - expand PRN carriage control byte.  *  *	Entry:	ccb = fab$v_prn byte " *	Exit:	commands output to printer */ expand_cc(ccb)( char ccb;				/* carriage control byte */ {  	int ic, stat; 	char obuf[40];    	if (ccb == 0) {	 		return;  	}  4 	if ((ccb & 0x80) == 0) {		/* output (n) LF, 1 CR */8 		if ((ccb & 0x7f) == 1) {	/* 1 LF, output short form */  			WRITELASER("XLF XCR\r\n", 9); 		}  		else {7 			sprintf(obuf, "%d{XLF}repeat XCR\r\n",(ccb & 0x7f)); % 			WRITELASERBUF(obuf, strlen(obuf));  		}  	} 	else { ; 		if ((ccb & 0xe0) != 0xe0) {	/* output single character */  			ic = ccb & 0x7f;  			expand_line(&ic, obuf, 1);  		}  	} }     . /**	expand_hex - expand buffer into hex bytes. */ expand_hex(ibuf, obuf, rsz) 4 unsigned char *ibuf;			/* pointer to input buffer */- char *obuf;				/* pointer to output buffer */  int rsz;				/* buffer size */  {  	int i, c, stat;, 	static char hexnums[] = "0123456789ABCDEF"; 	  	for (i = 0; i < rsz; i++) {- 		obuf[i*2] = hexnums[(ibuf[i] & 0xF0) >> 4]; ' 		obuf[i*2+1] = hexnums[ibuf[i] & 0xF];  	} 	WRITELASERBUF(obuf,rsz*2) }    	 C /**	expand_line - expand input buffer and output result to printer.r *u? *	The ()pop sequences are an obscure hack to fix an obscure bug9  *	with XON/XOFF.  It just works. */ expand_line(ibuf, obuf, rsz)" char *ibuf;					/* input buffer */ char *obuf;C int rsz;					/* buffer size */ {: 	int i, d, col, stat;s3 	static int popcount = 0;		/* XON kludge counter */. 	x* 	d = 0;					/* preset destination index */  	col = 0;				/* preset column */   	for (i = 0; i < rsz; i++) {$ 		if (ibuf[i] == 9) 		{	/* if tab */- 			if (d == 0) obuf[d++] = '(';/* if first */. 			do { & 				obuf[d++] = ' ';	/* fill spaces */
 				col++; 			} while (col & 7);a 		}i8 		else if (ibuf[i] == 8 && col > 0) {	/* if backspace */( 			obuf[d++] = 8;	/* insert backspace */	 			col--;d 		}h$ 		else if (ibuf[i] == '(') {	/* ( */- 			if (d == 0) obuf[d++] = '(';/* if first */  			obuf[d++] = '\\'; 			obuf[d++] = '('; 	 			col++;t 		} $ 		else if (ibuf[i] == ')') {	/* ) */- 			if (d == 0) obuf[d++] = '(';/* if first */f 			obuf[d++] = '\\'; 			obuf[d++] = ')'; 	 			col++;o 		}d% 		else if (ibuf[i] == '\\') {	/* \ */i- 			if (d == 0) obuf[d++] = '(';/* if first */h 			obuf[d++] = '\\'; 			obuf[d++] = '\\';	 			col++;  		}s& 		else if (ibuf[i] == 0x0d) { /* CR */) 			if (d) {		/* if string to terminate */T 				WRITELASERBUF(obuf,d)d 				if (++popcount == 20) {  					popcount = 0;$ 					WRITELASER(")XSTR()pop\r\n",12) 				} 
 				else { 					WRITELASER(")XSTR\r\n",7) 				}c
 				d = 0; 			} 			WRITELASER("XCR\r\n",5) 		} '  		else if (ibuf[i] == 0x0a) { /* LF */i) 			if (d) {		/* if string to terminate */  				WRITELASERBUF(obuf,d)e 				if (++popcount == 20) {a 					popcount = 0;$ 					WRITELASER(")XSTR()pop\r\n",12) 				} 
 				else { 					WRITELASER(")XSTR\r\n",7) 				} 
 				d = 0; 			} 			WRITELASER("XLF\r\n",5) 		}n'  		else if (ibuf[i] == 0x0c) { /* FF */i) 			if (d) {		/* if string to terminate */	 				WRITELASERBUF(obuf,d)t 				if (++popcount == 20) {  					popcount = 0;$ 					WRITELASER(")XSTR()pop\r\n",12) 				}m
 				else { 					WRITELASER(")XSTR\r\n",7) 				} 
 				d = 0; 			} 			WRITELASER("XFF\r\n",5) 		}i' 		else if (ibuf[i] < 32) { 		/* ctrl */ . 			if (d == 0) obuf[d++] = '(';	/* if first */ 			obuf[d++] = '^';g! 			obuf[d++] = ibuf[i] + 'A' - 1;i	 			col++;f 		}	 		else {- 			if (d == 0) obuf[d++] = '(';/* if first */ ' 			obuf[d++] = ibuf[i];	/* move char */.	 			col++;i 		}a 	}	 	if (d) {p 		obuf[d++] = ')'; 		obuf[d++] = 'X'; 		obuf[d++] = 'S'; 		obuf[d++] = 'T'; 		obuf[d++] = 'R'; 		obuf[d++] = '\r';m 		obuf[d++] = '\n';r 	} 	WRITELASERBUF(obuf,d) }     1 /**	getitems - get item list from job controller.F */
 getitems() {i
 	int stat;/ 	int	context;			/* read_message_item context */	! 	int	item_code;			/* item code */ + 	unsigned short item_size;		/* item size */a& 	struct dsc$descriptor_d item_buffer =) 				{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};e  # 	context = 0;				/* init context */e   /*  Save each item in a list */a 	e 	do {t@ 		item_buffer.dsc$a_pointer = 0;	/* force d string allocation */  5 		stat = smb$read_message_item(&buffer_des, &context, ( 		&item_code, &item_buffer, &item_size);  ! 		item[ii].item_code = item_code;,! 		item[ii].item_size = item_size;w. 		item[ii].buffer = item_buffer.dsc$a_pointer;- 		if (++ii > MAXITEMS) exit(LASER$_MAXITEMS);a 	} while (stat == SS$_NORMAL); }t    , /**	getitemdescrip - return item descriptor. *  *	return:	TRUE if item found) *		FALSE if (item not found) && NOT FATALa$ *		exit if (item not found) && FATAL */$ getitemdescrip(code, descrip, fatal)+ int code;					/* item code to search for */ > struct dsc$descriptor_s *descrip;		/* pointer to descriptor */# int fatal;					/* error severity */t {g 	int	i;s   	for (i = 0; i < ii; i++) {r1 		if (item[i].item_code == code) {	/* if found */I- 			descrip->dsc$w_length = item[i].item_size; + 			descrip->dsc$a_pointer = item[i].buffer;n 			return TRUE;i 		}b 	}= 	if (fatal) exit(LASER$_ITEMNOTFOUND);	/* item not in list */n 	else return FALSE;  }e    / /**	getcopies - send copy count to laserwriter.o *h< *	Leave this here for now, but unfortunately, if you specify9 *	/copies=n to the print command, the job contoller sends . *	the file that many times.  Not what we want. */ getcopies()s {d
 	int stat, n;yE 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};c 	char defcopy[80];  9 	if (!getitemdescrip(SMBMSG$K_FILE_COPIES, &temp, FALSE))i9 		if (!getitemdescrip(SMBMSG$K_JOB_COPIES, &temp, FALSE))m 			return;			/* if no copies */e  " 	n = * (long*) temp.dsc$a_pointer;+ 	if (n == 1) return;			/* if only 1 copy */c, 	sprintf(defcopy, "/#copies %d def\r\n", n);  $ 	WRITELASER(defcopy,strlen(defcopy)) }r    . /**	getnote - get /note=<Text> to laserwriter. */	 getnote()  {e
 	int stat;E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};, 	eE 	if (!getitemdescrip(SMBMSG$K_NOTE, &temp, FALSE)) return; /* none */e      /*6 * KLUDGE ALERT: Multinet LPD puts a /note on its jobs.- *               Don't send it to the printer.l */> 	if (strncmp(temp.dsc$a_pointer, "Remote LPD request", 18)==0)	 		return;e 	i1 	WRITELASER(temp.dsc$a_pointer,temp.dsc$w_length) $ 	WRITELASER(&0x0A0D,2)			/* cr-lf */ }w    $ /**	getparams - get user parameters. */ getparams()a {-
 	int stat; 	int i, j, k, l, ctl;a+ 	int first=TRUE,startend=FALSE,border=TRUE;eE 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};o; 	char param[255], str[255+15], *eq, start[8],end[8],num[6];e, 	static $DESCRIPTOR(number_up, "NUMBER_UP");,  	static $DESCRIPTOR(start_end, "STARTEND");$ 	static $DESCRIPTOR(sides, "SIDES");% 	static $DESCRIPTOR(parser,"PARSER");d   	temp.dsc$w_length = 0;    	for (i = 0; i < 8; i++) { 		if (!temp.dsc$w_length &&a9 			!getitemdescrip(SMBMSG$K_PARAMETER_1+i, &temp, FALSE))a! 				break;		/* if no parameter */R  9 		if (temp.dsc$w_length == 0) break;	/* if null string */f   		k = 0; 		l = 0;& 	        for (j = temp.dsc$a_pointer ;3 			j < temp.dsc$a_pointer+temp.dsc$w_length; j++) {u* 			if (!l && !strncmp(j,",",1) && k == 0) 
 				break;$ 			else if (!l && !strncmp(j,"(",1)) 				k++;$ 			else if (!l && !strncmp(j,")",1)) 				k--; 			else if (!strncmp(j,"\"",1))n 				l = 1 - l; 		}   $ 		strncpy(param, temp.dsc$a_pointer,& 						(int)j-(int)temp.dsc$a_pointer);, 		param[(int)j-(int)temp.dsc$a_pointer] = 0;5 		temp.dsc$w_length = max(0,(int)temp.dsc$w_length - o) 			((int)j-(int)temp.dsc$a_pointer) - 1);  		temp.dsc$a_pointer = j + 1;	 		if (temp.dsc$w_length) i--;  		 		eq = strchr(param, '='); -T                 if (eq && !casefree_strncmp(param,"DATA_TYPE",(int)eq-(int)param)) {                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0; I                         if (!casefree_strncmp(eq,"TEK4014",strlen(eq))) { $                         	tek = TRUE;.                                 ascii = FALSE;N                         } else if (!casefree_strncmp(eq,"ANSI",strlen(eq)) || 0 				 !casefree_strncmp(eq,"ASCII",strlen(eq))) {,                                 ansi = TRUE;L                         } else if (!casefree_strncmp(eq,"PS",strlen(eq)) || 5 				 !casefree_strncmp(eq,"POSTSCRIPT",strlen(eq))) { *                                 ps = TRUE;                          } else {" 				stop_reason = LASER$_INVPARAM; 				return FALSE;  			}                  } else if (eq &&D 			!casefree_strncmp(param,"PAGE_ORIENTATION",(int)eq-(int)param)) {                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0;oK                         if (!casefree_strncmp(eq,"LANDSCAPE",strlen(eq))) { ,                                 land = TRUE;-                                 port = FALSE;AQ                         } else if (!casefree_strncmp(eq,"PORTRAIT",strlen(eq))) {o-                                 land = FALSE; ,                                 port = TRUE;                          } else {" 				stop_reason = LASER$_INVPARAM; 				return FALSE;h 			}                  } else if (eq &&8 			!casefree_strncmp(param,"WIDE",(int)eq-(int)param)) {                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0;iF                         if (!casefree_strncmp(eq,"TRUE",strlen(eq))) {,                                 land = TRUE;-                                 port = FALSE;iN                         } else if (!casefree_strncmp(eq,"FALSE",strlen(eq))) {-                                 land = FALSE;d,                                 port = TRUE;                          } else {" 				stop_reason = LASER$_INVPARAM; 				return FALSE;o 			}                  } else if (eq &&9 			!casefree_strncmp(param,"SIDES",(int)eq-(int)param)) {T                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0;uD                         if (!casefree_strncmp(eq,"2",strlen(eq)) || 1 			    !casefree_strncmp(eq,"TWO",strlen(eq)) || d= 			    !casefree_strncmp(eq,"TWO_SIDED_DUPLEX",strlen(eq))) {R=                                 WRITESTRING("false true\r\n")WP                         } else if (!casefree_strncmp(eq,"TUMBLE",strlen(eq)) || @ 			   	   !casefree_strncmp(eq,"TWO_SIDED_TUMBLE",strlen(eq))) {<                                 WRITESTRING("true true\r\n")                          } else {" 				stop_reason = LASER$_INVPARAM; 				return FALSE;  			}  			if (!writemodule(sides)) {' 				stop_reason = LASER$_SETUPNOTFOUND;e 				return FALSE;( 			} 		} else if (eq &&> 			!casefree_strncmp(param,"PAGE_LIMIT",(int)eq-(int)param)) {
 			int i = 0;k 			startend = TRUE;e                         *eq++; 			if (*eq == '(') *eq++;d4 			while (i < 5 && isdigit(*eq)) start[i++] = *eq++; 			if (*eq++ != ',') { 				strncpy(end,start,i);b! 				strncpy(start,"1\r\n\000",4);$ 			} else { $ 				strncpy(&start[i],"\r\n\000",3);
 				i = 0;3 				while (i < 5 && isdigit(*eq)) end[i++] = *eq++;  			} 			if (!i) O# 				strncpy(end,"10000\r\n\000",8);R 			elseA?                                 strncpy(&end[i],"\r\n\000",3); E 		} else if (eq &&6 			!casefree_strncmp(param,"LW",(int)eq-(int)param)) {                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0;t 			WRITESTRING("/lw ") 			WRITESTRING(eq) 			WRITESTRING(" def\r\n")                  } else if (eq &&= 			!casefree_strncmp(param,"NUMBER_UP",(int)eq-(int)param)) {e
 			int i = 0;  			nup = TRUE;                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0;  			if (*eq == '(') *eq++;a2 			while (i < 3 && isdigit(*eq)) num[i++] = *eq++; 			if (!i) num[i++] = '1';7                         strncpy(&num[i],"\r\n\000",3); kM                 } else if (!casefree_strncmp(param,"BORDER",strlen(param))) {t 			border = TRUE;	                  } else if (eq &&: 			!casefree_strncmp(param,"BORDER",(int)eq-(int)param)) {                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0;E/ 			if (!casefree_strncmp(eq,"NONE",strlen(eq)))U 				border = FALSE;                          else {>                                 stop_reason = LASER$_INVPARAM;-                                 return FALSE;                          }                   } else if (eq &&< 			!casefree_strncmp(param,"MESSAGES",(int)eq-(int)param)) {                         *eq++;9 			if (j=strchr(param,',')) param[(int)j-(int)param] = 0;iE                         if (!casefree_strncmp(eq,"KEEP",strlen(eq))) s, 				openuserlog();		/* open user log file */                         else {>                                 stop_reason = LASER$_INVPARAM;-                                 return FALSE;R                         }d 		}p 	}   	temp.dsc$w_length = 0;D   	for (i = 0; i < 8; i++) { 		if (!temp.dsc$w_length &&d9 			!getitemdescrip(SMBMSG$K_PARAMETER_1+i, &temp, FALSE))r! 				break;		/* if no parameter */,  9 		if (temp.dsc$w_length == 0) break;	/* if null string */    		k = 0; 		l = 0;& 	        for (j = temp.dsc$a_pointer ;3 			j < temp.dsc$a_pointer+temp.dsc$w_length; j++) {p* 			if (!l && !strncmp(j,",",1) && k == 0) 
 				break;$ 			else if (!l && !strncmp(j,"(",1)) 				k++;$ 			else if (!l && !strncmp(j,")",1)) 				k--; 			else if (!strncmp(j,"\"",1))K 				l = 1 - l; 		};  $ 		strncpy(param, temp.dsc$a_pointer,& 						(int)j-(int)temp.dsc$a_pointer);, 		param[(int)j-(int)temp.dsc$a_pointer] = 0;5 		temp.dsc$w_length = max(0,(int)temp.dsc$w_length - p) 			((int)j-(int)temp.dsc$a_pointer) - 1);; 		temp.dsc$a_pointer = j + 1;  		if (temp.dsc$w_length) i--;t   		eq = strchr(param, '=');& 		if (!eq) eq = strchr(param, '\000');K                 if (!casefree_strncmp(param,"DATA_TYPE",(int)eq-(int)param)	7  		 || !casefree_strncmp(param,"LW",(int)eq-(int)param)}9 		 || !casefree_strncmp(param,"SIDES",(int)eq-(int)param)r> 		 || !casefree_strncmp(param,"PAGE_LIMIT",(int)eq-(int)param)= 		 || !casefree_strncmp(param,"NUMBER_UP",(int)eq-(int)param);: 		 || !casefree_strncmp(param,"BORDER",(int)eq-(int)param)? 		 || !casefree_strncmp(param,"MESSAGES",(int)eq-(int)param)) {{
 		} else {2 			if (!casefree_strncmp(param,"PAGE_ORIENTATION", 			    (int)eq-(int)param)) ( 				if (land) strcpy(param,"WIDE=TRUE");$ 				else strcpy(param,"WIDE=FALSE");$ 			if (first) {			/* if first one */ 				first = FALSE;" 				WRITELASER("/params [\r\n",11) 			}  7 			for (j= 0; (j < strlen(param)) && (param[j] != '(');a" 				 j++) {	/* lowercase string */, 				if (isupper(param[j])) param[j] ^= 0x20; 			}       s 		B /*  if there is an = separator (or - for spooled files), use it */ 		  			if ((eq = strchr(param, '='))  				|| (eq = strchr(param, '-'))# 				|| (eq = strchr(param, ':'))) {a& 				*eq++ = 0;		/* bust string in 2 */+ 				sprintf(str, "(%s) %s\r\n", param, eq);t 			}5 			else sprintf(str, "(param%d) %s\r\n", i+1, param);    			WRITELASER(str,strlen(str)) 		}s 	}         <         getitemdescrip(SMBMSG$K_PRINT_CONTROL, &temp, TRUE);+         ctl = * (long*) temp.dsc$a_pointer;	  " 	if (ctl & SMBMSG$M_PAGE_HEADER) {$ 		if (first) {				/* if first one */ 			first = FALSE;m! 			WRITELASER("/params [\r\n",11)_ 		}h  ! 		WRITESTRING("(title) true\r\n")e 	} 	b, 	if (!first) {				/* if some params found */ 		WRITELASER("] def\r\n",7)$5 		writemodule(parser);		/* write the parser module */r 	}   	if (nup) {t  		if (!writemodule(number_up)) {& 			stop_reason = LASER$_SETUPNOTFOUND; 			return FALSE; 		}  		WRITELASER(num,strlen(num))$B 		WRITELASER("false\r\n",7)  /* true to transpose row/col order */
   		if (port)S# 	       		WRITELASER("false\r\n",7)  		else" 	       		WRITELASER("true\r\n",6)@ 	       	WRITELASER("false\r\n",7)  /* true for Mac landscape */B 	       	WRITELASER("false\r\n",7)  /* true to disable clipping */ 		if (border)  	       		WRITELASER("0\r\n",3)] 		else  	       		WRITELASER("-1\r\n",4) 		if (startend) { ) 		       	WRITELASER(start,strlen(start))e% 		       	WRITELASER(end,strlen(end))o
 		} else { 			WRITELASER("1\r\n",3) 			WRITELASER("10000\r\n",7) 		}p" 		WRITELASER("DMM-nup-pre\r\n",13)         } else if (startend) {! 		WRITELASER(start,strlen(start))_ 		WRITELASER(end,strlen(end))   		if (!writemodule(start_end)) {& 			stop_reason = LASER$_SETUPNOTFOUND; 			return FALSE; 		}	 	}  
 	return TRUE;e }     / /**	getsetup - get setup module to laserwriter.{ *	0 *	return:	TRUE if no problems with setup module.+ *	        FALSE if setup module nonexistant  */
 getsetup() {f 	int stat, len;] 	int library_index;) 	long txtrfa[2]; 	char inbuf[255];fY 	struct dsc$descriptor_s inbufdes = {sizeof(inbuf), DSC$K_DTYPE_T, DSC$K_CLASS_S, inbuf};4# 	struct dsc$descriptor_s outbufdes;gD 	struct dsc$descriptor_s key = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};s  J /*  Try for a file setup module first, then a form setup module.  For now,H     we only support one setup module, the first found. We should support-     lists of setup modules, and all found. */p 	=? 	if (!getitemdescrip(SMBMSG$K_FILE_SETUP_MODULES, &key, FALSE)) @ 		if (!getitemdescrip(SMBMSG$K_FORM_SETUP_MODULES, &key, FALSE))" 			return TRUE;		/* if no setup */  : 	if (key.dsc$w_length == 0) return TRUE;	/* if no setup */ 	a; 	if (!getparams()) return FALSE;		/* get user parameters */    	if (ps) return TRUE;	  G /*  Get out if no library. Error because the user specified a setup. */   ' 	if (library_spec.dsc$a_pointer == 0) {,% 		stop_reason = LASER$_SETUPNOTFOUND;/ 		return FALSE;t 	}  < /*  Check to see if the setup module ends in _HEX or _STR */> 	if (!tek && getitemdescrip(SMBMSG$K_FORM_NAME, &temp, FALSE))C     	   if (strncmp(temp.dsc$a_pointer, "TEK", 3) == 0) tek = TRUE;   7         if (tek && (main_fab.fab$b_rfm == FAB$C_STM || (9                     main_fab.fab$b_rfm == FAB$C_STMCR || F9                     main_fab.fab$b_rfm == FAB$C_STMLF)) {% 		sys$close(&main_fab, 0, 0);t
 		openfile();p 	}  $ 	if (!tek && key.dsc$w_length >= 4){H 	   if (strncmp(&key.dsc$a_pointer[key.dsc$w_length-4],"_HEX", 4) == 0){ 		ascii = FALSE;
 		hex = TRUE;s 	   }2 	   H 	   if (strncmp(&key.dsc$a_pointer[key.dsc$w_length-4],"_STR", 4) == 0){ 		ascii = FALSE; 		string = TRUE; 	   }r         }        r           if (!tek && string) {); 		getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &temp, TRUE);  		strcpy(inbuf, "/filename (");&8 		strncat(inbuf, temp.dsc$a_pointer, temp.dsc$w_length); 		strcat(inbuf, ") def\r\n");t! 		WRITELASER(inbuf,strlen(inbuf))r  + /*  Also send the form name if it exists */s  9 		if (getitemdescrip(SMBMSG$K_FORM_NAME, &temp, FALSE)) {a"   			strcpy(inbuf, "/formname (");9 			strncat(inbuf, temp.dsc$a_pointer, temp.dsc$w_length);r 			strcat(inbuf, ") def \r\n");S" 			WRITELASER(inbuf,strlen(inbuf)) 		}a 	}   /*  Send the setup module */   	if (tek) {i 		strcpy(inbuf,"TEK4014"); 		key.dsc$a_pointer = &inbuf;e# 		key.dsc$w_length = strlen(inbuf);f 	}    	if (!writemodule(key)) {% 		stop_reason = LASER$_SETUPNOTFOUND;s 		return FALSE;i 	} 	t3         if (tek && port) WRITELASER("portrait\n",9) %         if (tek) WRITELASER("NP\n",3)   
 	return TRUE;C }C    % /**	inititems - initialize item list.  */ inititems()_ {D 	int	i;S  3 	for (i = 0; i < MAXITEMS; i++) item[i].buffer = 0;, }a    + /**	initsymb - initialize printer symbiont.t */
 initsymb() { 
 	int stat;  A 	stat = smb$initialize(&SMBMSG$K_STRUCTURE_LEVEL, jobctl_ast, 0);e 	checkstat(stat, "initsymb");s }o    : /**	jobctl_ast - ast routine called by the job controller. */ void jobctl_ast()	 {	 	int	stat,stream; $ 	int	request;			/* jobctl request */E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};D  9 	stat = smb$read_message(&stream, &buffer_des, &request); $ 	if (stat != SS$_NORMAL) exit(stat);   /*  Process the request */   	switch (request) {m 		 		case SMBMSG$K_START_STREAM:o
 		getitems();c 		startstream(); 		break;   		case SMBMSG$K_START_TASK:g
 		getitems();* 		start_task = TRUE; 		stop_task = 0; 		stop_reason = 0; 		break;   		case SMBMSG$K_RESUME_TASK:
 		getitems();  		break;   		case SMBMSG$K_RESET_STREAM:p 		resetstream(); 		break;   		case SMBMSG$K_STOP_STREAM: 		stopstream();* 		break;   		case SMBMSG$K_PAUSE_TASK:u 		break;   		case SMBMSG$K_STOP_TASK:
 		getitems(); 7 		getitemdescrip(SMBMSG$K_STOP_CONDITION, &temp, TRUE);e8 		stopoutput = stop_task = * (long*) temp.dsc$a_pointer; 		break; 	} 	sys$wake(0,0);= };    7 /**	laser_read_ast - laser read ast completion routine.  */   static void laser_read_ast ()  { "     register unsigned long status;       static char buffer[1024];          static int position      = 0;  &     static struct io$status_block iosb     = {0, 0, 0};         /*J      * Validate the I/O completion status for the previous I/O. If it is aN      * cancel or abort, clear out the status and don't issue any more I/O's...      */g  /     if (FAILURE (iosb.status) && iosb.status) {)   	switch (iosb.status) {,   	case SS$_ABORT: 	case SS$_CANCEL:yB 	    iosb.status = 0;	       /* reset status to 0 so we re-init */ 	    return;   	case SS$_DATAOVERUN:n 	    break;u  	 	default:/- 	    if (!stop_task) stop_task = iosb.status;N%             io_aborted = iosb.status; B 	    iosb.status = 0;	       /* reset status to 0 so we re-init */ 	    iosb.length = 0;  	    sys$wake(0,0);&& 	    if (!devinfo.terminators) return; 	};d     };         /*N      * Now press on and buffer up characters. When we hit a control character,)      * pass the buffer on to the scanner.       *//  G     if (iosb.length && !cancel_read) {		       /* if bytes in buffer */    	register int i;  $ 	for (i = 0; i < iosb.length; i++) {  ' 	    laser_buf[position++] = buffer[i];	  7 	    if (!devinfo.terminators && iscntrl (buffer[i])) {    		laser_buf[position] = '\000';e 		if (!check_operator ())  		    writeuserlog ();   		position = 0;  	    };) 	};   !        if (devinfo.terminators) {s  	  laser_buf[position] = '\000'; 	  if (!check_operator ())   	     writeuserlog ();           position = 0;i	        };K     };         /*J      * Issue a non-blocking read to the port and call ourselves as the I/ON      * completion routine... this is self perpetuating unless something messes      * up badly.      */   O     if (FAILURE (status = sys$qio (laser_efn, laserchan, devinfo.read_function,n! 				   &iosb, &laser_read_ast, 0, @ 		    buffer, sizeof (buffer), 0, devinfo.terminators, 0, 0))) { 	checkstat(status, "qio");     }; }s    " /**	openfile - open the main file. *e! *	return:	FALSE if open problems.w */
 openfile() {c
 	int stat;E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};S 	struct dsc$descriptor_s fid =9 		{28, DSC$K_DTYPE_T, DSC$K_CLASS_S, main_nam.nam$t_dvi};]  ; 	getitemdescrip(SMBMSG$K_FILE_IDENTIFICATION, &temp, TRUE);t 	 ( 	main_fab = cc$rms_fab;			/* init fab */> 	main_fab.fab$l_nam = &main_nam;		/* use NAM to open by FID */! 	main_fab.fab$l_fop |= FAB$M_NAM;=         main_fab.fab$b_fac = 0;e:         if (tek) main_fab.fab$b_fac = FAB$M_BIO|FAB$M_GET; 	s( 	main_nam = cc$rms_nam;			/* init nam */ 	str$copy_dx(&fid, &temp); 	  	stat = sys$open(&main_fab);) 	if (!(stat & 1)) {			/* if open error */s 		stop_reason = stat;  	    	return FALSE;t 	}	d 	y. 	main_rab = cc$rms_rab;			/* initialize rab */  	main_rab.rab$l_fab = &main_fab;   	stat = sys$connect(&main_rab);r, 	if (!(stat & 1)) {			/* if connect error */ 		stop_reason = stat;" 		return FALSE;g 	}
 	return TRUE;a }s    % /**	openuserlog - open user log file.t *e> *	Create a file using the file spec of the file to be printed,7 *	changing the EXT to .LASER_LOG.  Try the logical name0< *	LASER$LOG if this does not work (probably a spooled file). *r */
 openuserlog()  {x     register int status; #if 0*  H /*  This is old code which put message file in same directory as printedJ     file, but was eliminated because there is no code to check if user has      access to write into it.  */   	int i;  	struct dsc$descriptor_s temp;( 	char filename[256], filespec[255], *cp;  & 	log_fab = cc$rms_fab;		/* init fab */  H /*  Build log file name.  If a spooled file, prepend the job name and */+ /*  put the file in LASER$LOG:					      */t 	s 	filename[0] = 0; i = 0; 	if (spooled_file) {2 		getitemdescrip(SMBMSG$K_USER_NAME, &temp, TRUE);; 		strncpy(filename, temp.dsc$a_pointer, temp.dsc$w_length);	4 		i = temp.dsc$w_length;		/* trim trailing blanks */ 		do { 			filename[i] = 0;)# 			if (filename[--i] != ' ') break;t 		} while (i > 0); 		strcat(filename, "-"); 	} 	b: 	getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &temp, TRUE);: 	strncpy(filespec, temp.dsc$a_pointer, temp.dsc$w_length);! 	filespec[temp.dsc$w_length] = 0;X2 	if (spooled_file) cp = strchr(filespec, ']') + 1; 	else cp = filespec; 	strcat(filename, cp); 	A 	log_fab.fab$l_dna = filename;& 	log_fab.fab$b_dns = strlen(filename); 	if (spooled_file) {/ 		log_fab.fab$l_fna = "LASER$LOG:.laser_log;0";_ 		log_fab.fab$b_fns = 22;  	} 	else {*% 		log_fab.fab$l_fna = ".laser_log;0";y 		log_fab.fab$b_fns = 12;o 	} #else L     struct dsc$descriptor_d username = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  !     struct dsc$descriptor_s temp;*     char    filetype[64];i       static char filespec[255];  3     userlog = -1;		       /* flag not opened yet */{       /*-2I      *  +---------------------------------------------------------------+]I      *  |       First of all, find out the username, then determine     |tI      *  |       where his default directory is... this in turn will     |sI      *  |       be where we place the journal. Otherwise, pick the      |aI      *  |       default path provided by laser$log.                     | I      *  +---------------------------------------------------------------+c      */	$     strcpy (filespec, "LASER$LOG:"); #if LASER_PS!     strcpy (filetype, ".LOG-PS");	 #elses$     strcpy (filetype, ".LASER_LOG"); #endif@     if (getitemdescrip (SMBMSG$K_USER_NAME, &username, FALSE)) {   	char    default_device[32]; 	char    default_directory[64];   # 	struct ss$item_list getuailist[3];   " 	getuailist[0].code = UAI$_DEFDEV;0 	getuailist[0].length = sizeof (default_device);( 	getuailist[0].address = default_device;% 	getuailist[0].length_address = NULL;d  " 	getuailist[1].code = UAI$_DEFDIR;3 	getuailist[1].length = sizeof (default_directory);++ 	getuailist[1].address = default_directory;/% 	getuailist[1].length_address = NULL;f   	getuailist[2].length = 0; 	getuailist[2].code = 0; 	getuailist[2].address = NULL;% 	getuailist[2].length_address = NULL;o  L 	if (SUCCESS (status = SYS$GETUAI (0, 0, &username, getuailist, 0, 0, 0))) {   	    filespec[0] = '\0';? 	    strncat (filespec, &default_device[1], default_device[0]);*E 	    strncat (filespec, &default_directory[1], default_directory[0]);o  	 	} else {	   	    strcat (filetype, "_");F 	    strcat (filetype, username.dsc$a_pointer, username.dsc$w_length);   	};      }E     /*-RI      *  +---------------------------------------------------------------+fI      *  |       Now that we know where to put it, let's find out        | I      *  |       it's called and append the filename (if we get it)      |	I      *  |       to as much of the filename as we already have, then     |EI      *  |       tack on the extension ".LOG-PS[_username]"              |dI      *  +---------------------------------------------------------------+o      */   E     if (getitemdescrip (SMBMSG$K_FILE_SPECIFICATION, &temp, FALSE)) {   	 	struct {	 	    unsigned short length;  	    unsigned short code;	 	    char   *address;) 	}       fscnitmlst[2];]  ! 	fscnitmlst[0].code = FSCN$_NAME;)   	fscnitmlst[1].length = 0; 	fscnitmlst[1].code = 0; 	fscnitmlst[1].address = NULL;    < 	if (SUCCESS (status = SYS$FILESCAN (&temp, fscnitmlst, 0))) 	    if (fscnitmlst[0].length)B 		strncat (filespec, fscnitmlst[0].address, fscnitmlst[0].length);     };        strcat (filespec, filetype);       /*-fI      *  +---------------------------------------------------------------+rI      *  |       Create a new version of the file we just generated      | I      *  |       a name for with CR format variable length records.      |gI      *  +---------------------------------------------------------------+m      */*       log_fab = cc$rms_fab;e  !     log_fab.fab$l_fna = filespec;$*     log_fab.fab$b_fns = strlen (filespec); #endif"     log_fab.fab$b_rfm = FAB$C_VAR;!     log_fab.fab$b_rat = FAB$M_CR;t     log_fab.fab$w_mrs = 512;  3     if (SUCCESS (status = sys$create (&log_fab))) {s  2 	log_rab = cc$rms_rab;	       /* initialize rab */ 	log_rab.rab$l_fab = &log_fab;  ! 	status = sys$connect (&log_rab);]     };       if (SUCCESS (status))b1 	userlog = 0;		       /* flag open, no records */X }M    ! /**	preset - preset the symbiont.t */ preset() {;
 	int stat;  9 	stat = lib$get_ef(&laser_efn);	/* allocate event flag */E 	stat = lib$get_ef(&stateefn); 	o& 	setprivs();			/* set process privs */$ 	inititems();			/* init item list */# 	initsymb();			/* do jobctl init */	 }*   void ltatimeout(param)
 int param; {d
 	dassgndev();s
  	jobnum = 0;e }o   void statetimeout(param)  
 int param; {i
 	int stat;2 	if (oldiocount < 0 && iocount != -oldiocount-1) { 		getmsg(LASER$_RESUMED, 1);+ 		sprintf(&msg[6],&message[1],&queue_name);] 		sndmsg(1,0); 		oldiocount = iocount; $ 	} else if (iocount == oldiocount) { 		getmsg(LASER$_STALLED, 1);+ 		sprintf(&msg[6],&message[1],&queue_name);s 		sndmsg(1,1); 		oldiocount = -oldiocount-1;c 	} else if (oldiocount >= 0) 		oldiocount = iocount;o: 	sys$setimr(stateefn,&statetime,&statetimeout,stateefn,0); }c  ! /**	processtask - process a file.h */
 processtask()m {    	int stat, np, request;c4 	int svector[2] = {1, SS$_NORMAL};	/* stat vector */5 	int acctrec[4] = {0,0,0,0};		/* accounting record */e% 	struct dsc$descriptor_s accounting =S; 		{sizeof(acctrec), DSC$K_DTYPE_T, DSC$K_CLASS_S, acctrec};GE 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};= 	static int assigned = FALSE;   # 	int ltatime[2]= {-1*100000000,-1};y 	int retries = 0;o   	notify_qual = FALSE;,  1 	ascii = TRUE;				/* assume main file is ascii */ 
 	hex = FALSE;e 	string = FALSE;         port = FALSE;t 	land = FALSE; 	ps = FALSE;
 	tek = FALSE;s 	ansi = FALSE; 	stopoutput = FALSE;
 	nup = FALSE;i 	notify = FALSE;* 	userlog = -1;			/* flag not opened yet */ 	* #if 0      if (laserchan == 0)t 	exit (LASER$_STREAMNOTSTART); #endif   	if (shared_device) { 7 	   getitemdescrip(SMBMSG$K_ENTRY_NUMBER, &temp, TRUE);e' 	   memcpy(&stat,temp.dsc$a_pointer,4);i 	   if (stat == jobnum)pH 	      sys$cantim(ltaefn,0);      /* Cancel ast that deassigns device */< 	   else if (!jobnum) {		 /* Deassigning ast already run? */? 	      jobnum = stat;		 /* Yes, so just store new job number */b 	      assigned = FALSE; 	   } else { 	      jobnum = stat;,D 	      sys$cantim(ltaefn,0);  /* Cancel ast that deassigns device */C 	      dassgndev();	     /* Deassign to allow other nodes access */$ 	      assigned = FALSE; 	   }; 	}  8 	getitemdescrip(SMBMSG$K_USER_NAME, &user_notify, TRUE);+ 					/* Get username for error messages. */   
 	retries = 0;8   retry:       if (!assigned) {   	register unsigned long status;A   	struct ss$item_list itmlst[2];r   #if TCP || MULTINETr   	/* H 	 * Check what kind of device we're after. If the name starts with TCP%,9 	 * then assume we are making a TCP/IP type connection.... 	 */  7 	if (!casefree_strcmp ("TCP%", device.dsc$a_pointer)) {,   	    register char *d;   	    register char *text;c 	    register char *hostname;    	    unsigned long address;	 	    unsigned long port;   	    struct hostent *host; 	    struct sockaddr_in sin;     	    /*e- 	     * Break down the device name string as:a 	     *  	     * <type>%<host>:<port> 	     */  > 	    if (!(text = malloc (strlen (device.dsc$a_pointer) + 1))) 		exit(LASER$_NOMEMORY);  ) 	    strcpy (text, device.dsc$a_pointer);c  " 	    if (d = strchr (text, '%')) { 		*d = '\0'; 		hostname = ++d;(
 	    } else {_ 		d = hostname = text; 	    };-  . 	    if (strstr (d,"/S") || strstr (d,"/s")) {+                 char *d1 = strchr (d, '/');a
 		*d1 = '\0'; %                 shared_device = TRUE;m
             }s   	    if (d = strchr (d, ':')) {  		*d = '\0'; 		port = atoi (++d);
 	    } else {s 		port = 0;  	    };    	    /* = 	     * Now translate the host address portion into a hostent!A 	     * structure... If it is not a numeric Internet address, try F 	     * calling the resolver. If neither works then punt, we're losing 	     * bad! 	     */  6 	    host = ((address = inet_addr (hostname)) == -1) ? 		gethostbyname (hostname) :6 		gethostbyaddr (&address, sizeof (address), AF_INET);   	    if (!host) {V   #if MULTINETK 		sprintf (&msg[5], "*** Unable to resolve address for \"%s\" ***\r\n\t%s",m
 			 hostname,I 			 vms_errno_string ());  		status = vmserrno; #else;C 		sprintf (&msg[5], "*** Unable to resolve address for \"%s\" ***",  			 hostname); 		status = LASER$_NOTRESOLVED; #endif 		sndmsg(1,0);   		exit (status); 	    };      	    /* H 	     * Finally now, assign a socket (channel) to the link and establish< 	     * connection to the other side with a call to connect. 	     */  ; 	    laserchan = socket (host->h_addrtype, SOCK_STREAM, 0);   ' 	    sin.sin_family = host->h_addrtype;l9 	    bcopy (host->h_addr, &sin.sin_addr, host->h_length);h! 	    sin.sin_port = htons (port);e  6 	    status = connect (laserchan, &sin, sizeof (sin));     #if MULTINET   	    /* H 	     * So long as we get a status of "connection refused" we can assumeH 	     * that the remote port is busy, so it is safe to retry it. After aD 	     * sufficently large of attempts though, we'll want to give up,D 	     * 'cause it becomes obvious the other guy just doesn't want to 	     * talk to us...{ 	     */   	    while (status == -1)  {   		/*@ 		 * If we got here, the channel wasn't connected, so get rid of 		 * the channel in question.  		 */I  % 		if (socket_close (laserchan) < 0) {   > 		    sprintf (&msg[5], "*** socket close failed ***\r\n\t%s", 			     vms_errno_string ());  		    sndmsg(2,0); 		};     		/*@ 		 * Now wait 15 seconds and try again... every 10 minutes (40 *9 		 * 15 sec) we will send an opcom message indicating howa 		 * dilligently we tried. 		 */   
 		sleep (15);e  8 		laserchan = socket (host->h_addrtype, SOCK_STREAM, 0);  $ 		sin.sin_family = host->h_addrtype;6 		bcopy (host->h_addr, &sin.sin_addr, host->h_length); 		sin.sin_port = htons (port);  3 		status = connect (laserchan, &sin, sizeof (sin));B  = 		if (status && (!(++retries % 40))) {	/* complain once everyt 							 * 10 minutes. */  c 		    sprintf (&msg[5], "*** %d retries of connect to \"%s\" [%s] port %d have failed ***\r\n\t%s",u 			     retries, 			     host->h_name,T4 			     inet_ntoa (*(unsigned long *) host->h_addr),
 			     port,r 			     vms_errno_string ());i   		    sndmsg(2,0); 		};   	    };	     	    /*RF 	     * If the connection request returns a non-zero code, it means weB 	     * got here without assigning the channel so pass on whatever) 	     * information we can and punt on...( 	     */   	    if (status) {  b 		sprintf (&msg[5], "*** Connect to \"%s\" [%s] port %d has failed after %d attempts ***\r\n\t%s", 			 host->h_name, 0 			 inet_ntoa (*(unsigned long *) host->h_addr),	 			 port,  			 1 + retries, 			 vms_errno_string ());\ 		sndmsg(1,0);  > 		status = FAILURE (vmserrno) ? vmserrno : LASER$_CONNREFUSED; 		socket_close (laserchan);  		shared_device = FALSE;   	    } elsea$                 status = SS$_NORMAL;     #else)   	    /*TH 	     * So long as we get a status of "connection refused" we can assumeH 	     * that the remote port is busy, so it is safe to retry it. After aD 	     * sufficently large of attempts though, we'll want to give up,D 	     * 'cause it becomes obvious the other guy just doesn't want to 	     * talk to us...g 	     */   	    while (status == -1)  {   		/*@ 		 * If we got here, the channel wasn't connected, so get rid of 		 * the channel in question.r 		 */c   		if (close (laserchan) < 0) {  > 		    sprintf (&msg[5], "*** socket close failed ***\r\n\t%s", 			     vms_errno_string ());t 		    sndmsg(2,0);   		};     		/*@ 		 * Now wait 15 seconds and try again... every 10 minutes (40 *9 		 * 15 sec) we will send an opcom message indicating how	 		 * dilligently we tried. 		 */   
 		sleep (15);   8 		laserchan = socket (host->h_addrtype, SOCK_STREAM, 0);  $ 		sin.sin_family = host->h_addrtype;6 		bcopy (host->h_addr, &sin.sin_addr, host->h_length); 		sin.sin_port = htons (port);  3 		status = connect (laserchan, &sin, sizeof (sin));   9 		if (status && (!(++retries % 40))) {	/* complain once aj 							 * minute... */  [ 		    sprintf (&msg[5], "*** %d retries of connect to \"%s\" [%s] port %d have failed ***",  			     retries, 			     host->h_name, 4 			     inet_ntoa (*(unsigned long *) host->h_addr), 			     port);   		    sndmsg(2,0); 		};   	    };n   	    /* F 	     * If the connection request returns a non-zero code, it means weC 	     * got here without assigniong the channel so pass on whateverp) 	     * information we can and punt on...	 	     */   	    if (status) {  U 		sprintf (&msg[5], "*** Connect to \"%s\" [%s] port %d failed after attempt %d ***",  			 host->h_name,d0 			 inet_ntoa (*(unsigned long *) host->h_addr),	 			 port,j 			 1 + retries);& 		sndmsg(1,0);   		status = LASER$_CONNREFUSED; 		socket_close (laserchan);) 		shared_device = FALSE;   	    } else" 		status = SS$_NORMAL; #endif2 	    if ((status & 1) && ltaefn) laser_read_ast(); 	} elset #endif 	{   	  if (!laserchan) { 	    /*cH 	     * Assign the printer.  If already allocated, wait for it. Warn theB 	     * operator if we have to wait too long. This should probablyG 	     * exponentially delay longer. We wait since we may be sharing the)% 	     * printer with other symbionts.	 	     */. 	    status = sys$alloc(&device, 0, 0, 0, 0);    	    retries = 0;a  % 	    while (status == SS$_DEVALLOC) {|   		++retries;  0 		if (!(retries % 4 * 10)) {	/* if 10 minutes */  P 		    sprintf (&msg[5], "*** Unable to assign printer %s after %d attempts ***", 			     device.dsc$a_pointer,c 			     retries);a 		    sndmsg(2,0); 		};  
 		sleep (15);c2 	        status = sys$alloc(&device, 0, 0, 0, 0);  	    };s   	    if (FAILURE (status)) {  L 		sprintf (&msg[5], "*** Connect to printer %s failed after attempt %d ***", 			 device.dsc$a_pointer,) 			 1 + retries);a 		sndmsg(1,0);   	    };"  5 	    status = sys$assign (&device, &laserchan, 0, 0);	 	  }; - 	  if (lta_device) {assigndev(); status = 1;}R 	};r   	if ((status & 1) && !ltaefn) {0   	/*sD 	 * Determine the device class so that we can determine what kind of 	 * device we're talking to... 	 */  4 	    itmlst[0].code = DVI$_DEVCLASS|DVI$C_SECONDARY;/ 	    itmlst[0].length = sizeof (devinfo.class);i( 	    itmlst[0].address = &devinfo.class;% 	    itmlst[0].length_address = NULL;h   	    itmlst[1].code = 0; 	    itmlst[1].length = 0; 	    itmlst[1].address = NULL;% 	    itmlst[1].length_address = NULL;(  M 	    if (FAILURE (status = SYS$GETDVIW(0, laserchan, 0, itmlst, 0, 0, 0, 0)))}! 	    checkstat(status, "getdvi");S   	    switch (devinfo.class) {E  ) 	    static int terminators[2] = {0, -1};r   	    case DC$_TERM:$  , 	    devinfo.write_function = IO$_WRITEPBLK;: 	    devinfo.read_function = (IO$_READPBLK | IO$M_NOECHO);' 	    devinfo.terminators = terminators;\ 	    set_typeahead (laserchan);*E 	    shared_device = lta_device = strstr(device.dsc$a_pointer,"LTA");a! 	    if (lta_device) assigndev();* 	    break;   
 	    default:w  , 	    devinfo.write_function = IO$_WRITEVBLK;* 	    devinfo.read_function = IO$_READVBLK;  	    devinfo.terminators = NULL;   	    };a                lib$get_ef(&ltaefn); 	    if (shared_device) {t; 	       getitemdescrip(SMBMSG$K_ENTRY_NUMBER, &temp, TRUE);R+ 	       memcpy(&stat,temp.dsc$a_pointer,4);f 	       jobnum = stat;
             }  	    laser_read_ast ();f 	}   	if (!(status & 1))s 	    stop_reason = status;         else 	    assigned = TRUE;]       }   A 	stat = smb$send_to_jobctl(&0, &SMBMSG$K_START_TASK, 0, 0, 0, 0);L4     	checkstat(stat, "processtask: send to jobctl");  3 	if (!(stop_reason & 1) && stop_reason) goto skip1;W   	if (!notify_qual &&  8 		getitemdescrip(SMBMSG$K_PRINT_CONTROL, &temp, TRUE)) { 		int flags;- 	        memcpy(&flags,temp.dsc$a_pointer,4);S( 		notify_qual = flags & SMBMSG$M_NOTIFY; 		if (notify_qual) { 	       		char job[255];@ 		       	if (getitemdescrip(SMBMSG$K_JOB_NAME, &temp, FALSE))  8 				strncpy(job, temp.dsc$a_pointer, temp.dsc$w_length); 			elseo 				temp.dsc$w_length = 0; 			job[temp.dsc$w_length] = 0; 			getmsg(LASER$_STARTJOB,1); 6 			getitemdescrip(SMBMSG$K_ENTRY_NUMBER, &temp, TRUE);G                         if (strncmp(&entry_num,temp.dsc$a_pointer,4)) {u3 		        	memcpy(&entry_num,temp.dsc$a_pointer,4);s< 				sprintf(&msg[6],&message[1],&job,entry_num,&queue_name); 				sndmsg(0,0); 			} 	        } else { 6 			getitemdescrip(SMBMSG$K_ENTRY_NUMBER, &temp, TRUE);2 		        memcpy(&entry_num,temp.dsc$a_pointer,4); 		}o 	}   	status_error = FALSE; #if !NOREADp         status_idle = FALSE; #endif	W 	cancel_read = FALSE;iB 	if (!syncprinter() || stop_task) {	/* synchronize with printer */ #if TCP || MULTINET     , 	 	if (!devinfo.terminators && io_aborted && 			io_aborted == stop_task) {L! 	 		stat = sys$cancel(laserchan);u 			dassgndev();d. 	 		io_aborted = stop_task = assigned = FALSE;
 			retries++;p 			sleep (15); 			goto retry;  		} #endif
 		goto skip1;) 	}0 	checkspooled();				/* check for spooled file */ 	oldiocount = iocount = 0;: 	sys$setimr(stateefn,&statetime,&statetimeout,stateefn,0);  	trailer(0);				/* flag pages */2 	if (!openfile()) goto skip;		/* open main file */* /*	getcopies();*/				/* send copy count */ #if !NONOTEc) 	getnote();				/* output possible note */  #endif7 	if (!getsetup()) goto skip;		/* output setup module */ $ 	sendfile();				/* send main file */ skip:A& 	closefile();				/* close main file */" 	trailer(1);				/* send trailer */ 	sys$cantim(stateefn,0);- 	sendendsequence();			/* send job sequence */i9 	if (notify_qual && userlog > 0) {	/* if errors logged */w 		getmsg(LASER$_CREATELOG,0);(" 		strncpy(&msg[5],message,msglen); 		sndmsg(0,0);	         }i( 	closeuserlog();				/* close user log */ skip1: #if TCP || MULTINET     * 	if (!devinfo.terminators && io_aborted) { 		dassgndev(); 		assigned = FALSE;r 	} #endif 	io_aborted = FALSE; 	cancel_read = TRUE;' 	start_task = FALSE;			/* clear flag */I 	 5 	np = endpage - startpage;		 /* compute page count */n8 	if (np >0) acctrec[0] = np;		 /* if no obvious error */  ; /*  If stop_task, we were stopped by the job controller.	*/ B /*  Else, we were stopped by some other error condition	        */  " 	request = SMBMSG$K_TASK_COMPLETE;* 	if (stop_task) {			 /* if task aborted */ 		request = SMBMSG$K_STOP_TASK;e 		svector[1] = stop_task;a 	} 	else if (stop_reason) {( 		if (stop_reason == LASER$_MAXITEMS || , 		    stop_reason == LASER$_ITEMNOTFOUND || + 		    stop_reason == LASER$_TOOMANYTABS || n' 		    stop_reason == LASER$_FLUSHED || e- 		    stop_reason == LASER$_SETUPNOTFOUND || 	( 		    stop_reason == LASER$_INVPARAM) {  			getmsg(stop_reason,0); # 			strncpy(&msg[5],message,msglen);i 			jobid(0);                 }A 		svector[1] = SS$_ABORT;R 	}  , 	releaseitems();				 /* release item list */ 	/5 	stat = smb$send_to_jobctl(&0, &request, &accounting,M 		0, 0, svector);f0 	checkstat(stat, "processtask: send to jobctl");   	if (shared_device) {b; 	   sys$cantim(ltaefn,0);	/* Cancel deassign lta routine */U5 	   sys$setimr(ltaefn,&ltatime,&ltatimeout,ltaefn,0);) 					/* Requeue timer ast */ 	} }i    % /**	releaseitems - release item list.j *t/ *	release dynamic strings gotten by read_items.	 */ releaseitems() {s 	int	i;$E 	struct dsc$descriptor_d temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};m 	e$ 	ii = 0;					 /* clear item index */  ! 	for (i = 0; i < MAXITEMS; i++) {(7 		if (item[i].buffer == 0) return;	/* if end of list */ ( 		temp.dsc$w_length = item[i].item_size;& 		temp.dsc$a_pointer = item[i].buffer; 		str$free1_dx(&temp); 		item[i].buffer = 0;* 	} }r    # /**	resetstream - reset the stream.r */
 resetstream(); { 
 	int stat;  ' 	if (lta_device && jobnum && laserchan) < 		stat = sys$qiow(0, laserchan,IO$_TTY_PORT+IO$M_LT_DISCON,  			0, 0, 0,0, 0, 0, 0, 0, 0);    	if (laserchan) {r 		stat = sys$dassgn(laserchan);K 		laserchan = 0; 	}  C 	stat = smb$send_to_jobctl(&0, &SMBMSG$K_RESET_STREAM, 0, 0, 0, 0);N0 	checkstat(stat, "resetstream: send to jobctl"); 	( 	exit (SS$_NORMAL);n };    / /**	sendendsequence - send end of job sequence.e */ sendendsequence()  {pI static char getend[] = {"\004statusdict begin (%%[ end page   #=) print \s* pagecount pstack pop flush end \r\n\004"};  
 	int stat;/ 	int daytim[2];				/* quadword time interval */s 	int abort_sent = FALSE;; 	static $DESCRIPTOR(timetowait, "0 :1:30");	/* +1:30 min */e 	n
 	endpage = 0;   , 	sys$wake(0,0);				/* eat pending wakeups */(  	sys$hiber();				/* (instant return) */ 	r 	if (!end_sent) {g& 		WRITELASER(&0X04,1)	/* end of job */& 		lib$wait(&1.0);		/* wait 1 second */ 		end_sent = FALSE;  	}
 #if NOREAD 	endpage = TRUE; #else	; 	WRITELASER(getend,strlen(getend))	/* write end sequence */  #endif	_ 	A 	do {n  ) 		stat = sys$bintim(&timetowait, daytim);t 		checkstat(stat, "bintim");9 		stat = sys$schdwk(0, 0, daytim, 0);	/* wake up later */= 		checkstat(stat, "schdwk"); 	o9 		if (endpage || io_aborted) break;	/* if sync occured */& 		stat = sys$hiber();m9 		if (endpage || io_aborted) break;	/* if sync occured */s  6 		stat = sys$canwak(0,0);	/* cancel wakeup requests */   		if (!notify && abort_sent) { 			getmsg(LASER$_STALLED,1);, 			sprintf(&msg[6],&message[1],&queue_name); 			sndmsg(1,1);f 			notify = TRUE;  		};   		if (!abort_sent) { 			abort_sent = TRUE; , /*			WRITELASER(&0X03,1)  *//*	 control-c */* /*			lib$wait(&1.0);	*//* wait 1 second */+ /*			WRITELASER(&0X04,1)	*//* end of job */	* /*			lib$wait(&1.0);	*//* wait 1 second */ 			cancel_read = TRUE;! 	 		stat = sys$cancel(laserchan);n$ 			WRITELASER(getend,strlen(getend)) 			cancel_read = FALSE;h 			laser_read_ast (); 	 		} else l 			abort_sent = FALSE; 		 	} while (TRUE);   	if (notify) { 		getmsg(LASER$_RESUMED,1); + 		sprintf(&msg[6],&message[1],&queue_name);O 		sndmsg(0,0); 		notify = FALSE;  	} }     1 /**	sendfile - send the main file to the printer.  */
 sendfile() {( #define IBUFSIZE (32767)6 #define PREFIX_LEN (1)				/* max extra prefix chars */ 	int stat, end;_ #if 0 * 	char ibuf[IBUFSIZE];			/* input buffer */. 	char obuf[IBUFSIZE*2+2];		/* output buffer */ #else  	char *ibuf; 	char *obuf; #endif
 	char *cp;$ 	int rsz = 0,i;				/* record size */0 	char prn_ctl[2];			/* PRN file control bytes */ 	int first = TRUE, orsz = 0; 	,B 	ibuf = malloc(IBUFSIZE+PREFIX_LEN);	/* extra for prefix chars */  	obuf = malloc(IBUFSIZE*2 + 2);a  & 	main_rab.rab$l_ubf = ibuf+PREFIX_LEN; 	main_rab.rab$w_usz = IBUFSIZE;   J /*	For PRN type records, set up a pointer to the carriage control byte  */? /*	pair, or initialize the control byte pair manually.		     */= 		G         if (tek)                       /* if file is tektronix, init */$%                tek2ps(cp, obuf, &-1);s  & 	if (main_fab.fab$b_rat & FAB$M_PRN) {  		if (main_fab.fab$b_fsz == 2) {7 			main_rab.rab$l_rhb = &prn_ctl;	/* ptr to PRN ctrl */t 		     } 		else {( 			prn_ctl[0] = 0x01;	/* LF CR before */$ 			prn_ctl[1] = 0x8d;	/* CR after */ 		     } 	}   	do {					/* send the file */$& 		if (main_fab.fab$b_fac & FAB$M_BIO) 7 			stat = sys$read(&main_rab, 0, 0);	/* get a record */u 		else6 			stat = sys$get(&main_rab, 0, 0);	/* get a record */  # 		if (!first || stat != RMS$_RTB) {n> 			if ((stat == RMS$_EOF) || (stop_task | stop_reason)) break;& 			if (!(stat & 1)) {			/* if error */ 				stop_reason = stat;t
 				break; 			} 		}e   		if (stopoutput) break; 		 		rsz = main_rab.rab$w_rsz;; 		8 		cp = ibuf+PREFIX_LEN;		/* Leave room for prefix chs */  & 		if (first && !tek && !ps && !ansi) {+ 		 	if (stat != RMS$_RTB &&rsz && string &&i7 			   (((main_fab.fab$b_rat & FAB$M_FTN) && cp[1]=='%') < 	                   || (!(main_fab.fab$b_rat & FAB$M_FTN) && 			   (cp[0]=='%' ||0 			   (rsz > 1 && cp[0]==10 && cp[1]=='%'))))) {-                                 ascii = TRUE;m( 	                        string = FALSE; 				ps = TRUE; 	                }
 			if (!ps) {o 				tek = (stat == RMS$_RTB);S 				if (!tek && rsz) {$ 					for (i=0; i<rsz && !tek; i++) {B 						if (cp[i] == 27 && i < rsz - 1 && cp[i+1] == 12) tek = TRUE;" 						if (cp[i] == 29) tek = TRUE; 					} 				}	 			}
 			if (tek) { $ 				$DESCRIPTOR(tek4014, "TEK4014");5 				if (stat == RMS$_RTB) sys$close(&main_fab, 0, 0);F 				tek = TRUE;, 			        hex = FALSE;f 		        	string = FALSE; 			        ps = FALSE; 				if (stat == RMS$_RTB) {0 					openfile();* 					main_rab.rab$l_ubf = ibuf+PREFIX_LEN; 					main_rab.rab$w_usz = 512;;         	                	stat = sys$read(&main_rab, 0, 0);s 					rsz = main_rab.rab$w_rsz;! 					if (stat == RMS$_EOF) break;L 					if (!(stat & 1)) {  						stop_reason = stat;  						break; 					} 				}_  				if (!writemodule(tek4014)) {( 					stop_reason = LASER$_SETUPNOTFOUND; 					free(ibuf); 					free(obuf);	D 					return FALSE; 				} / 			        if (port) WRITELASER("portrait\n",9)  			        WRITELASER("NP\n",3) ( 		                tek2ps(cp, obuf, &-1); 	                }                 }2   		first = FALSE; /*  Process record control. */   		if (ascii || string) {1 		        /* if FTN (Fortran) carriage control */t( 			if (main_fab.fab$b_rat & FAB$M_FTN) {9 			       if (rsz == 0) {	/* Null record => blank line */  				 cp[rsz++] = ' ';  			       }r 			       switch(*cp) { ' 			       case 0:		/* (null) - No CC */i! 				 cp++;		/* ignore column 1 */  				 rsz--;  				 break;-* 			       case '0':	/* 0 - Double Space *// 				 *cp = '\n';	/* 2 LF in front, CR at end */L 				 *--cp = '\n';       				 rsz++;y 				 cp[rsz++] = '\r'; 				 break;(( 			       case '1':	/* 1 - Page Eject */ 				 *cp = '\n'; 				 *--cp = '\f'; 				 rsz++;E 				 cp[rsz++] = '\r'; 				 break; ' 			       case '+':	/* + - overprint */c! 				 cp++;		/* ignore column 1 */g 				 cp[rsz-1] = '\r'; 				 break;t, 			       case '$':	/* $ - no trailing CC */+ 				 *cp = '\r';	/* LF, CR before record */t 				 *--cp = '\n';       				 rsz++;g 				 break;c% 			       default :	/* space, etc. */t 				 *cp = '\n'; 				 cp[rsz++] = '\r'; 				 }   			}  % 			/*  if implied carriage control */t( 			if (main_fab.fab$b_rat & FAB$M_CR || 5 			    (!string && main_fab.fab$b_rat & FAB$M_PRN)) {s, 				*--cp = '\n';	/* prefix LF, suffix CR */
 				rsz++; 				cp[rsz++] = '\r';T 			}  6 			/*  print carriage control.  Expand and output	  */7 			/* leading carriage control, then expand trailing */e- 			/* control to output after the text.		  */f- 			else if (main_fab.fab$b_rat & FAB$M_PRN) {} 				expand_cc(prn_ctl[0]); 			} 			; 			if (string) l 				expand_line(cp, obuf, rsz);e	 			else {_  				if (orsz + rsz > IBUFSIZE) { 					WRITELASERBUF(obuf,orsz) 1                                         orsz = 0;* 	                        } 				memcpy(&obuf[orsz],cp,rsz); 2                                 orsz = orsz + rsz;& 				if (ps) for (i=orsz-rsz;i<orsz;) {, 					if (obuf[i] < 32 && obuf[i] != '\r' &&  					   obuf[i] != 9 && - 					   obuf[i] != '\n' && obuf[i] != '\f') {rK                                                 memcpy(&obuf[i],&obuf[i+1],- 						       orsz-i-1); 
 						orsz--;(' 	                                } elseO 					   i++; 				}                          }   0 			if (string && main_fab.fab$b_rat & FAB$M_PRN) 				expand_cc(prn_ctl[1]); 		}s 		I                 if (tek)                       /* if file is tektronix */c/                         tek2ps(cp, obuf, &rsz);L. 		else if (hex)			/* if file to be hexified */ 			expand_hex(cp, obuf, rsz);f   	} while (TRUE);  6         if (!(stop_task | stop_reason | stopoutput)) {2                 if (orsz) WRITELASERBUF(obuf,orsz)  C                 if (tek && rsz != -1) tek2ps("\037\014", obuf, &2);-  3                 if (string) WRITELASER("EOF\r\n",5)n  X                 if (nup) WRITESTRING("userdict /DMM-nup-post known{DMM-nup-post}if\r\n")	         }d  " 	if (!ascii) WRITELASER(&0x0A0D,2)  - 	free(ibuf);
 	free(obuf);	-  2 /*  send abort (^C) if stop_task, else eof (^D) */ /*5 	if (stop_task || stop_reason) end = 3; else end = 4;n 	WRITELASER(&end,1); */% 	WRITELASER(&0X04,1)		/* control-d */;         end_sent = TRUE; }$    ! /**	setprivs - set process privs.  */
 setprivs() {a
 	int stat; 	static int privs[2] =: 	   {PRV$M_BYPASS+PRV$M_ALLSPOOL+PRV$M_PHY_IO+PRV$M_SYSPRV 		+PRV$M_OPER+PRV$M_WORLD,0};u  # 	stat = sys$setprv(1, privs, 0, 0);  	checkstat(stat, "set privs"); }g       /**	set_typeahead. *o= *	Set /typeahead on the terminal device so characters will ber *	buffered.i */ set_typeahead(chan)e' int chan;					/* laserwriter channel */* { 
 	int mode[3];_
 	int stat;  1 	stat = sys$qiow(0, chan, IO$_SENSEMODE, 0, 0, 0,i 		mode, 12, 0, 0, 0, 0); 	if (!(stat & 1)) return stat; 	n7 	mode[1] &= ~(TT$M_NOTYPEAHD);		/* clear notypeahead */s0 	stat = sys$qiow(0, chan, IO$_SETMODE, 0, 0, 0,	 		mode, 12, 0, 0, 0, 0);  
 	return stat;  }d    # /**	startstream - start the stream.{ */
 startstream()E {E
 	int	stat;4 	static int svector[2] = {1,0};		/* status vector */  E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};m 	L       /*J      * Retrieve the device name string so that we know what device to openJ      * up... If it is a quoted string, strip off the quotes and shift case      * appropriately.t      */t    9     getitemdescrip (SMBMSG$K_DEVICE_NAME, &device, TRUE);s     {e 	register char *name;   / 	if (name = malloc (device.dsc$w_length + 1)) {1  " 	    register unsigned short last;   	    register char *d; 	    register char *n;   	    register int i;   	    register int quoted;c   	    d = device.dsc$a_pointer; 	    n = name;   	    quoted = 0; 	    last = -1;S  0 	    for (i = 0; i < device.dsc$w_length; i++) {   		switch (d[i]) {l   		case '\"': 		    quoted = (!quoted);s 		    if (last != '\"')F	 			break;a  
 		default:, 		    *n++ = quoted ? d[i] : toupper (d[i]); 		};   		last = d[i]; 	    };o 	    *n = '\0';n  ) 	    device.dsc$w_length = strlen (name);s  C 	    if (device.dsc$a_pointer = malloc (device.dsc$w_length + 1)) {e& 		strcpy (device.dsc$a_pointer, name); 		free (name); 	    } else  		device.dsc$a_pointer = name;   	} elsed 	    exit (LASER$_NOMEMORY);     };  7 	getitemdescrip (SMBMSG$K_EXECUTOR_QUEUE, &temp, TRUE);y9 	memcpy(queue_name,temp.dsc$a_pointer,temp.dsc$w_length); # 	queue_name[temp.dsc$w_length] = 0;n  8 /*  Copy the library file specification, if it exists */ 	DB 	if (getitemdescrip(SMBMSG$K_LIBRARY_SPECIFICATION, &temp, FALSE))$ 		str$copy_dx(&library_spec, &temp);   #if 0 - 	svector[1] = sys$alloc(&device, 0, 0, 0, 0);  	if (svector[1] == SS$_NORMAL) n5 		svector[1] = sys$assign(&device, &laserchan, 0, 0);   	if (svector[1] != SS$_NORMAL) {7 		stat = smb$send_to_jobctl(&0, &SMBMSG$K_START_STREAM,t 			0, 0, 0, svector);E1 		checkstat(stat, "startstream: send to jobctl");f	 		return;s 	}  8 	set_typeahead(laserchan);		/* set terminal typeahead */ #endif 	 6 	stat = smb$send_to_jobctl(&0, &SMBMSG$K_START_STREAM, 		0, 0, 0, 0);			/* ok */ 0 	checkstat(stat, "startstream: send to jobctl"); }    void dassgndev() {P
 	int stat; 	if (devinfo.terminators) 	P< 		stat = sys$qiow(0, laserchan,IO$_TTY_PORT+IO$M_LT_DISCON,  				0, 0, 0, 0, 0, 0, 0, 0, 0);r #if TCP || MULTINET  	elses 		socket_close (laserchan);e #endif }t   void assigndev() {  	int stat, send = 1; 	unsigned short iosb[4];
 	iosb[0] = 0;  	while (!(iosb[0] & 1)) {rH 		stat = sys$qiow(0, laserchan,IO$_TTY_PORT+IO$M_LT_CONNECT, iosb, 0, 0, 				0, 0, 0, 0, 0, 0);' 		if (send && iosb[0] == SS$_TIMEOUT) {  			getmsg(LASER$_TIMEOUT, 1);p, 			sprintf(&msg[6],&message[1],&queue_name); 			sndmsg(1,0);d 			send = 0;, 		} else if (send && iosb[0] == SS$_ABORT) { 			getmsg(LASER$_ABORT,1);4 			sprintf(&msg[6],&message[1],&queue_name,iosb[1]); 			sndmsg(1,0);r 			send = 0; 		}s9 		if (!(iosb[0] & 1)) lib$wait(&1.0);	/* wait 1 second */a 	} }     ! /**	stopstream - stop the stream.  */ stopstream() { 
 	int stat;  ' 	if (lta_device && jobnum && laserchan)	< 		stat = sys$qiow(0, laserchan,IO$_TTY_PORT+IO$M_LT_DISCON,  			0, 0, 0,0, 0, 0, 0, 0, 0);    	if (laserchan) {i 		stat = sys$dassgn(laserchan);t 		laserchan = 0; 	}  B 	stat = smb$send_to_jobctl(&0, &SMBMSG$K_STOP_STREAM, 0, 0, 0, 0);/ 	checkstat(stat, "stopstream: send to jobctl");  	  	exit(SS$_NORMAL); }r    0 /**	syncprinter - get synchronized with printer. */
 syncprinter()h {b static char getstart[] = { "\004\= version (23.0) eq { statusdict /Patch1Installed known not { \[* (%%[ patch needed ]%%\n) print } if } if \, statusdict begin (%%[ start page #=) print \* pagecount pstack pop flush end \r\n\004"};  
 	int stat;/ 	int daytim[2];				/* quadword time interval */ , 	static $DESCRIPTOR(timetowait, "0 :00:15");$ 	static $DESCRIPTOR(patch, "PATCH"); 	int firstabort;X 	static int expiretime[] = {1,1*60/10,5*60/10,10*60/10,60*60/10}; /* notify intervals */1 #define NEXPIRES (sizeof(expiretime)/sizeof(int))a 	startpage = 0;    	firstabort = TRUE;n   	do { ' 		lib$wait(&1.0);			/* wait 1 second */   
 #if NOREAD#                 status_idle = TRUE;( #else_ 		WRITELASER(&0x14,1)		/* ^T */t  ) 		stat = sys$bintim(&timetowait, daytim);  		checkstat(stat, "bintim");9 		stat = sys$schdwk(0, 0, daytim, 0);	/* wake up later */  		checkstat(stat, "schdwk");   		stat = sys$hiber(); 6 		stat = sys$canwak(0,0);	/* cancel wakeup requests */ #endif< 		if (status_idle || stop_task) break;	/* if sync occured */  " /*  Abort whatever is happening */   		if (!status_error) { 			if (!firstabort) {n' 				WRITELASER(&0X03,1)	/* control-c */ ( 				lib$wait(&1.0);		/* wait 1 second */ 			}( 			WRITELASER(&0X04,1)		/* end of job */( 			lib$wait(&1.0);			/* wait 1 second */ 		} else 			status_error = FALSE;   /*  Notify the user. */	 		- 		if (!notify && !firstabort && !stop_task) {r 			getmsg(LASER$_STALLED,1);, 			sprintf(&msg[6],&message[1],&queue_name); 			sndmsg(1,1);5 			notify = TRUE;a 		}    		firstabort = FALSE;	 		 	} while (TRUE);  $         if (stop_task) return FALSE;   	if (status_idle && notify) {  		getmsg(LASER$_RESUMED,1); + 		sprintf(&msg[6],&message[1],&queue_name);  		sndmsg(0,0); 		notify = FALSE;p 	} 	c 	do {s
 #if NOREAD 		startpage = TRUE;_ #else;' 		WRITELASER(getstart,strlen(getstart))t  ) 		stat = sys$bintim(&timetowait, daytim);B 		checkstat(stat, "bintim");9 		stat = sys$schdwk(0, 0, daytim, 0);	/* wake up later */  		checkstat(stat, "schdwk");   		stat = sys$hiber();t6 		stat = sys$canwak(0,0);	/* cancel wakeup requests */ #endif: 		if (startpage || stop_task) break;	/* if sync occured */   /*  Notify the user. */  		 		if (!notify && !stop_task) { 			getmsg(LASER$_STALLED,1);, 			sprintf(&msg[6],&message[1],&queue_name); 			sndmsg(1,1);s 			notify = TRUE;o 		}, 		 	} while (TRUE);  $         if (stop_task) return FALSE;   	if (startpage && notify) {o 		getmsg(LASER$_RESUMED, 1);+ 		sprintf(&msg[6],&message[1],&queue_name);  		sndmsg(0,0); 		notify = FALSE;s 	} 	%< /*  This looks like a good place to send the patch module */  + 	if (patchneeded) {			/* if patch needed */d 		patchneeded = FALSE;3 		writemodule(patch);		/* write the patch module */; 		WRITELASER(&4, 1)E 	}  
 	return TRUE;o }L 	R    /**	trailer - issue job trailer. */ trailer(which), int which;					/* 0 if flag, 1 if trailer */ {t 	int ctl, stat, stop;  	short msglen;( 	char buf[1024];				/* scratch buffer */ 	char time[24];e1 	char user[20],job[255], file[255], message[257];u
 	char *cp; 	static char z = 0;t$ 	static $DESCRIPTOR(key, "TRAILER");E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}; G 	struct dsc$descriptor_s date={23, DSC$K_DTYPE_T, DSC$K_CLASS_S, time};  	struct dsc$descriptor_s msgd =*= 		{sizeof(message)-1, DSC$K_DTYPE_T, DSC$K_CLASS_S, message}; & 	static struct dsc$descriptor_s zero =* 				{1, DSC$K_DTYPE_T, DSC$K_CLASS_S, &z};  ) /*  Check to see if we need a trailer. */*  : 	getitemdescrip(SMBMSG$K_SEPARATION_CONTROL, &temp, TRUE);$ 	ctl = * (long*) temp.dsc$a_pointer;  , 	/*  save page count if first file of job */< 	if (ctl & SMBMSG$M_FIRST_FILE_OF_JOB) jobstart = startpage; 	*' 	if (which == 0) {			/* if flag page */ 6 		if ((ctl & (SMBMSG$M_FILE_FLAG | SMBMSG$M_JOB_FLAG |F 			SMBMSG$M_FILE_BURST | SMBMSG$M_JOB_BURST))  == 0) /* if no flags */
 			return;  P 		if ((ctl & (SMBMSG$M_FILE_BURST | SMBMSG$M_FILE_FLAG)) == 0) /* if job only */G 			if ((ctl & SMBMSG$M_FIRST_FILE_OF_JOB) == 0) /* if not first file */o 				return;j 	} 	else {					/* trailer page */E 		if (((ctl & (SMBMSG$M_JOB_TRAILER | SMBMSG$M_FILE_TRAILER))== 0) &&f, 			((stop_task | stop_reason) == 0)) return;  7 		if ((stop_task | stop_reason) == 0) /* if no error */r< 			if ((ctl & SMBMSG$M_FILE_TRAILER) == 0) /* if job only */F 				if ((ctl & SMBMSG$M_LAST_FILE_OF_JOB) == 0) /* if not last file */ 					return; 	} 	 / /*  send the trailer module from the library */a  % 	WRITELASER(&4,1)			/* leading EOF */n 	if(!writemodule(key)) return;  1 	getitemdescrip(SMBMSG$K_USER_NAME, &temp, TRUE);"6 	strncpy(user, temp.dsc$a_pointer, temp.dsc$w_length); 	user[temp.dsc$w_length] = 0;g  <         if (getitemdescrip(SMBMSG$K_JOB_NAME, &temp, FALSE))D                 strncpy(job, temp.dsc$a_pointer, temp.dsc$w_length);         else&                 temp.dsc$w_length = 0; 	job[temp.dsc$w_length] = 0;  : 	getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &temp, TRUE);6 	strncpy(file, temp.dsc$a_pointer, temp.dsc$w_length); 	file[temp.dsc$w_length] = 0;a   	lib$date_time(&date); 	time[23] = 0;  
 	sprintf(buf,w? 	 "setuppage (%s) h-job (%s) h-user (%s) h-file (%s) h-time  ",o 	  job, user, file, time); 	WRITELASER(buf,strlen(buf)) 	i1 /*  only print page count on last trailer page */l 	(K 	if ((which == 1) && (ctl & SMBMSG$M_LAST_FILE_OF_JOB)) { /* if last one */A* 		sprintf(buf, "(%d) h-pages ", jobstart); 		WRITELASER(buf,strlen(buf))/ 	} 	  	p1 	if ((which == 1) && (stop_task | stop_reason)) {t; 		if (stop_task) stop = stop_task; else stop = stop_reason; & 		msglen = 0;			/* in case of error */ 		getmsg(stop, 0);) 		sprintf(buf, "(%s) h-error ", message);) 		WRITELASER(buf,strlen(buf))E 	} 	s' 	if (userlog > 0) {			/* if log file */t 		str$append(&savelog, &zero);9 		for (cp=savelog.dsc$a_pointer; *cp; cp+=strlen(cp)+1) { ( 			sprintf(buf, "(%s) h-logline\n", cp); 			WRITELASER(buf,strlen(buf)) 		}  	} 	   	sprintf(buf, " showpage \004"); 	WRITELASER(buf,strlen(buf)) }(    , /**	writemodule - write module from library. * - *	return:	TRUE if module written, else FALSE.  */ writemodule(key) struct dsc$descriptor_s key; {[ 	int stat, len;V 	int library_index;; 	long txtrfa[2]; 	char inbuf[255];iY 	struct dsc$descriptor_s inbufdes = {sizeof(inbuf), DSC$K_DTYPE_T, DSC$K_CLASS_S, inbuf};L# 	struct dsc$descriptor_s outbufdes;i  3 	if (library_spec.dsc$a_pointer == 0) return FALSE;  	iH 	stat = lbr$ini_control(&library_index, &LBR$C_READ, &LBR$C_TYP_TXT, 0);  	checkstat(stat, "ini_control");  ? 	stat = lbr$open(&library_index, &library_spec, 0, 0, 0, 0, 0);c 	checkstat(stat, "open");   5 	stat = lbr$lookup_key(&library_index, &key, txtrfa); * 	if ((stat & 1) != 1) {			/* if bad key */# 		stat = lbr$close(&library_index);B# 		checkstat(stat, "close library");i 		return FALSE;o 	}   	do {t? 		stat = lbr$get_record(&library_index, &inbufdes, &outbufdes);r 		if (stat == RMS$_EOF) break; 		 		len = outbufdes.dsc$w_length;  		inbuf[len++] = '\r'; 		inbuf[len++] = '\n';   		WRITELASER(inbuf,len); 		
 	} while (1);_  " 	stat = lbr$close(&library_index); 	checkstat(stat, "close"); }a    / /**	writeuserlog - write line to user log file._ */ writeuserlog() {i
 	int stat;& 	static struct dsc$descriptor_s temp =) 				{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};   / 	if (userlog < 0) return;		/* if no log file */r 	_ 	sys$setast(0);i 	! 	userlog++;				/* bump flag */   	log_rab.rab$l_rbf = laser_buf;g' 	log_rab.rab$w_rsz = strlen(laser_buf);d    	stat = sys$put(&log_rab, 0, 0); 	 / 	if (userlog <= 5) {			/* save first 5 lines */n9 		temp.dsc$w_length = strlen(laser_buf) + 1;	/* incl 0 */o! 		temp.dsc$a_pointer = laser_buf;  		str$append(&savelog, &temp); 	}   	sys$setast(1);)   	checkstat(stat, "write log"); }a    < /**	casefree_strcmp - compare source string against a target& *				independent of case sensitivities' *				(for length of source string only)S */  0 static int casefree_strcmp (source, destination)     char   *source;.     char   *destination; {	     register int result;  ,     for (; *source; source++, destination++)9 	if (result = tolower (*source) - tolower (*destination))p 	    return (result);        return (0);m }e    < /**	casefree_strcmp - compare source string against a target& *				independent of case sensitivities' *				(for length of source string only)e */  9 static int casefree_strncmp (source, destination, length)(     char   *source;,     char   *destination; {c     register int result, i;t                              for (i=0; i < length; i++)= 	if (result = tolower (source[i]) - tolower (destination[i]))  	    return (result);s       return (0);h }i