#include <stdio.h>
#include <ctype.h>
#include <iodef.h>
#include "tek.h"
extern short laserchan;		/* laserwriter channel */
extern int iocount;
#define WRITELASER(p1) orsz += p1; if (orsz > 1536 - 64) {stat = \
sys$qiow(0,laserchan, IO$_WRITEPBLK, 0, 0, 0, obuf, orsz, 0, 0, 0, 0);\
checkstat(stat,"writelaser"); iocount++; orsz = 0;}

extern double atof();

/* output filter for tektronics 4010-graphics files to generate postscript
 * files.  This does a simple-minded byte by byte translation to predefined
 * PS routines, contained in a prolog file.
 * Defaults:
 * input:	stdin
 * output:	stdout
 * prolog:	~msf/tek2ps/pstek.pro
 */

tek2ps(ibuf,obuf,rsz)
  char *ibuf;
  char *obuf;
  int *rsz;
{
  static int mode = ALPHA,tsizex = CHUGEX,tsizey = CHUGEY,oldmode;
  static int ncx,ncy,cx = 0,cy = YDIM - CHUGEY,leftmargin = 0;
  static int used_large = FALSE,used_med = FALSE,used_small = FALSE;
  static int num_vector = -1,i;
  static int HiX = 0,HiY = 0,LoY = 0,LoX = 0,BX = 0,BY = 0;
  static int gotLoY = FALSE,debug = FALSE,beamon,pr_on_er = TRUE;
  static double scale_factor = 1.0;
  static char c; static int tekdata = FALSE;
  static int stat, orsz;

  if (*rsz == -1)
  {
    mode = ALPHA,tsizex = CHUGEX,tsizey = CHUGEY; tekdata = FALSE;
    cx = 0,cy = YDIM - CHUGEY,leftmargin = 0;
    used_large = FALSE,used_med = FALSE,used_small = FALSE;
    num_vector = -1;
    HiX = 0,HiY = 0,LoY = 0,LoX = 0,BX = 0,BY = 0;
    gotLoY = FALSE,debug = FALSE,pr_on_er = TRUE;
    scale_factor = 1.0;
    orsz = 0;
  }

  for (i = 0; i < *rsz; i++)
  {
    c = ibuf[i]; 
    switch (mode)
    {
      case ALPHA:
	if (isgraph((char) c))
	{			/* normal printing char */
	  /* put char at current position */
          if (c == '(' || c == ')' || c == '\\') 
	    sprintf(&obuf[orsz],"(\\%c) %d %d PR\n",(char) c,cx,cy);
          else
	    sprintf(&obuf[orsz],"(%c) %d %d PR\n",(char) c,cx,cy);
	  WRITELASER(strlen(&obuf[orsz]));
	  tekdata = TRUE;

	  /* increment current postion, wrt type size */
	  if ((cx += tsizex) > XDIM)
	  {
	    /* new line or margin */
	    if ((cy -= tsizey) < 0)
	    {
	      cy = YDIM - tsizey;
	      leftmargin = leftmargin ? 0 : XDIM / 2;
	    }
	    cx = leftmargin;
	  }
	}
	else
	{			/* isn't normal printing character */
	  switch (c)
	  {
	    case (HT):
	    case (SPACE):
	      if ((cx += tsizex) > XDIM)
	      {
		/* new line or margin */
		if ((cy -= tsizey) < 0)
		{
		  cy = YDIM - tsizey;
		  leftmargin = leftmargin ? 0 : XDIM / 2;
		}
		cx = leftmargin;
	      }
	      break;

	    case (CR):
	    case (LF):
	      if ((cy -= tsizey) < 0)
	      {
		cy = YDIM - tsizey;
		leftmargin = leftmargin ? 0 : XDIM / 2;
	      }
	      cx = leftmargin;
	      break;

	    case (BS):
	      if ((cx -= tsizex) < 0)
	      {
		cx = XDIM;
	      }
	      break;

	    case (VT):
	      if ((cy += tsizey) > YDIM)
	      {
		cy = 0;
	      }
	      break;

	    case (GS):
	      mode = GRAPH;
	      num_vector = -1;
	      break;

	    case (RS):
	      mode = INCRE;
	      break;

	    case (FS):
	      mode = PTPLT;
	      break;

	    case (US):		/* put in ALPHA mode, already there */
	    case (BEL):
	    case (SYN):	/* padding character, ignore*/
	    case (NUL):	/* padding character, ignore*/
	      break;

	    case (ESC):
	      oldmode = ALPHA;
	      mode = LCEMD;
	      break;

	    case (FF):		/* erase */
	      if (pr_on_er && (cx || cy != YDIM - tsizey) && tekdata)
	      {
		sprintf(&obuf[orsz],"showpage\nNP\n");
		WRITELASER(strlen(&obuf[orsz]));
                tekdata = FALSE;
		if (scale_factor != 1.0)
		{
		  sprintf(&obuf[orsz],"%f %f scale\n",scale_factor,scale_factor);
		}
	      }
	      pr_on_er = TRUE;
	      if (cx || cy != YDIM - tsizey) {
		      sprintf(&obuf[orsz],"%d DP\n",tsizey);
		      WRITELASER(strlen(&obuf[orsz]));
	      }
	      cx = 0;
	      cy = YDIM - tsizey;
	      break;

	    default:
	      if (debug) fprintf(stderr,"Unknown ALPHA mode character 0x%02x\n",c);
	      break;
	  }			/* end of switch on non-printing char in ALPHA mode */
	}			/* end of printing vs non-printing char in ALPHA mode */
	break;			/* end of ALPHA mode */

      case PTPLT:
      case GRAPH:
	oldmode = mode;
	if ((char) c > US)
	{			/* first, handle vector case */
	  if ((char) c < '@')
	  {			/* High byte */
	    if (gotLoY)
	    {			/* must be HiX */
	      HiX = ((char) c & 0x1f) << 7;
	    }
	    else
	    {			/* must be HiY */
	      HiY = ((char) c & 0x1f) << 7;
	    }
	  }
	  else if ((char) c < '`')
	  {			/* Lo X: plot */
	    gotLoY = FALSE;
	    LoX = (c & 0x1f) << 2;
	    /* now actually do a plot */
	    if (num_vector == -1)
	    {
	      num_vector = 0;
	      ncx = HiX + LoX + BX;
	      ncy = HiY + LoY + BY;
	      if (mode != GRAPH)
	      {
		sprintf(&obuf[orsz],"%d %d m\n",ncx,ncy);
		WRITELASER(strlen(&obuf[orsz]));
	      }
	      cx = ncx;
	      cy = ncy;
	    }
	    else
	    {			/* draw the line */
              if (num_vector > 99) {
	        sprintf(&obuf[orsz],"%d %d %d v\n",num_vector,ncx,ncy);
                WRITELASER(strlen(&obuf[orsz]));
                num_vector = 0;
              }
	      num_vector++;
	      ncx = HiX + LoX + BX;
	      ncy = HiY + LoY + BY;
	      if (mode == GRAPH)
	      {
		sprintf(&obuf[orsz],"%d %d\n",cx - ncx,cy - ncy);
		WRITELASER(strlen(&obuf[orsz]));
	      }
	      else
	      {			/* mode == PTPLT */
		sprintf(&obuf[orsz],"%d %d m %d %d 1 0 360 arnc\n",ncx,ncy,ncx,ncy);
		WRITELASER(strlen(&obuf[orsz]));
	      }
       	      tekdata = TRUE;
	      cx = ncx;
	      cy = ncy;
	    }
	  }
	  else
	  {			/* Lo Y or extra byte */
	    if (gotLoY)
	    {			/* previous LoY => extra byte */
	      BX = (LoY & 0x0c) >> 2;
	      BY = (LoY & 0x30) >> 4;
	      LoY = (c & 0x1f) << 2;
	      /* gotLoY stays TRUE */
	    }
	    else
	    {			/* assume is LoY */
	      LoY = (c & 0x1f) << 2;
	      gotLoY = TRUE;
	    }
	  }
	}
	else			/* end of GRAPH mode vector address parsing*/
	  /* so, it isn't a vector address */
	  switch (c)
	  {
	    case (NUL):	/* padding */
	    case (SYN):	/* padding */
	    case (BEL):	/* ignore */
	      break;

	    case (LF):  /* ignore */
	      break;

	    case (CR):
	      mode = ALPHA;
	      leftmargin = 0;
	      break;

	    case (RS):
	      mode = INCRE;
	      break;

	    case (FS):
	      if (debug) fprintf(stderr,"special point plot not implemented\n");
	      break;

	    case (GS):
	      if (num_vector >= 0)
	      {
		if (mode == GRAPH)
			if (num_vector > 0)
		       		sprintf(&obuf[orsz],"%d %d %d v\n",num_vector,ncx,ncy);
			else
				sprintf(&obuf[orsz],"%d %d m\n",ncx,ncy);
                else
 			sprintf(&obuf[orsz],"s\n");
		WRITELASER(strlen(&obuf[orsz]));
	      }
	      num_vector = -1;
	      break;

	    case (US):
	      mode = ALPHA;
	      break;

	    case (ESC):
	      mode = LCEMD;
	      break;

	    default:
	      if (debug) fprintf(stderr,"Unknown GRAPH mode character 0x%02x\n",c);
	      break;
	  }			/* end of switch on non-vector char in GRAPH mode */
	if (mode != oldmode && num_vector >= 0)
        {
		if (oldmode == GRAPH)
			if (num_vector > 0)
		       		sprintf(&obuf[orsz],"%d %d %d v\n",num_vector,ncx,ncy);
			else
				sprintf(&obuf[orsz],"%d %d m\n",ncx,ncy);
                else
                        sprintf(&obuf[orsz],"s\n"); 
                WRITELASER(strlen(&obuf[orsz]));
		num_vector = -1;
	}
	break;			/* end of GRAPH mode */

      case INCRE:
	/* could do with bit masking and check for control, */
	/* but this is is simpler. (Let the compiler work). */
	switch (c)
	{
	  case (32):
	    sprintf(&obuf[orsz],"stroke %d %d m\n",cx,cy);
	    WRITELASER(strlen(&obuf[orsz]));
	    beamon = FALSE;
	    break;

	  case (80):
	    sprintf(&obuf[orsz],"%d %d m\n",cx,cy);
	    WRITELASER(strlen(&obuf[orsz]));
	    beamon = TRUE;
	    break;

	  case (68):		/* N */
	    if (++cy > YDIM) cy = YDIM;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (69):		/* NE */
	    if (++cy > YDIM) cy = YDIM;
	    if (++cx > XDIM) cx = XDIM;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (65):		/* E */
	    if (++cx > XDIM) cx = XDIM;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (73):		/* SE */
	    if (--cy < 0) cy = 0;
	    if (++cx > XDIM) cx = XDIM;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (72):		/* S */
	    if (--cy < 0) cy = 0;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (74):		/* SW */
	    if (--cy < 0) cy = 0;
	    if (--cx < 0) cx = 0;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (66):		/* W */
	    if (--cx < 0) cx = 0;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (70):		/* NW */
	    if (++cy > YDIM) cy = YDIM;
	    if (--cx < 0) cx = 0;
	    if (beamon) sprintf(&obuf[orsz],"%d %d lineto\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    break;

	  case (ESC):
	    if (beamon) sprintf(&obuf[orsz],"stroke %d %d m\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    oldmode = INCRE;
	    mode = LCEMD;
	    break;

	  case (FS):
	    if (beamon) sprintf(&obuf[orsz],"stroke %d %d m\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    mode = PTPLT;
	    break;

	  case (GS):
	    if (beamon) sprintf(&obuf[orsz],"stroke %d %d m\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    mode = GRAPH;
	    num_vector = -1;
	    break;

	  case (RS):
	    break;

	  case (US):
	    if (beamon) sprintf(&obuf[orsz],"stroke %d %d m\n",cx,cy);
	    if (beamon) WRITELASER(strlen(&obuf[orsz]));
	    mode = ALPHA;
	    break;

	  default:
	    if (debug) fprintf(stderr,"Unknown incremental mode character 0x%02x\n",c);
	    break;
	}			/* end of INCR switch on c */
	break;			/* end of INCREmental mode */

      case LCEMD:
	if ((c > 95) && (c < 117))
	{
	  /* set Z axis */
	  if ((char) c & 0x08)
	  {
	    sprintf(&obuf[orsz],"DZ\n");
	  }
	  else
	  {
	    sprintf(&obuf[orsz],"FZ\n");
	  }
	  WRITELASER(strlen(&obuf[orsz]));
	  /* set vector type */
	  switch ((char) c & 0x07)
	  {
	    case 0:		/* normal vectors */
	    case 5:
	    case 6:
	    case 7:
	      sprintf(&obuf[orsz],"NV\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      break;

	    case 1:		/* dotted vectors */
	      sprintf(&obuf[orsz],"DV\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      break;

	    case 2:		/* dot-dash vectors */
	      sprintf(&obuf[orsz],"DDV\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      break;

	    case 3:		/* short-dash vectors */
	      sprintf(&obuf[orsz],"SDV\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      break;

	    case 4:		/* long-dash vectors */
	      sprintf(&obuf[orsz],"LDV\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      break;

	    default:		/* error */
	      if (debug) fprintf(stderr,"Unknown beam selector 0x%02x\n",(char) c);
	      break;
	  }
	}
	else
	{
	  switch (c)
	  {
	    case (FF):		/* erase */
	      if (pr_on_er && (cx || cy != YDIM - tsizey) && tekdata)
	      {
		if (num_vector >= 0) {
		  if (oldmode == GRAPH)
			if (num_vector > 0)
		       		sprintf(&obuf[orsz],"%d %d %d v\n",num_vector,ncx,ncy);
			else
				sprintf(&obuf[orsz],"%d %d m\n",ncx,ncy);
                  else
                    sprintf(&obuf[orsz],"s\n"); 
                  num_vector = -1;
                  WRITELASER(strlen(&obuf[orsz]));
                }
		sprintf(&obuf[orsz],"showpage\nNP\n");
		WRITELASER(strlen(&obuf[orsz]));
                tekdata = FALSE;
		if (scale_factor != 1.0)
		{
		  sprintf(&obuf[orsz],"%f %f scale\n",scale_factor,scale_factor);
		  WRITELASER(strlen(&obuf[orsz]));
		}
	      }
	      pr_on_er = TRUE;
	      if (cx || cy != YDIM - tsizey) {
		      sprintf(&obuf[orsz],"%d DP\n",tsizey);
		      WRITELASER(strlen(&obuf[orsz]));
	      }
	      cx = 0;
	      cy = YDIM - tsizey;
	      break;

	    case ('8'):
	      /* default size */
	      sprintf(&obuf[orsz],"FntH setfont\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      tsizex = CHUGEX;
	      tsizey = CHUGEY;
	      break;

	    case ('9'):
	      if (!used_large)
	      {
		used_large = TRUE;
		sprintf(&obuf[orsz],"DFntL\n");
		WRITELASER(strlen(&obuf[orsz]));
	      }
	      sprintf(&obuf[orsz],"FntL setfont\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      tsizex = CLARGEX;
	      tsizey = CLARGEY;
	      break;

	    case (':'):
	      tsizex = CMEDX;
	      tsizey = CMEDY;
	      if (!used_med)
	      {
		used_med = TRUE;
		sprintf(&obuf[orsz],"DFntM\n");
		WRITELASER(strlen(&obuf[orsz]));
	      }
	      sprintf(&obuf[orsz],"FntM setfont\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      break;

	    case (';'):
	      tsizex = CSMALLX;
	      tsizey = CSMALLY;
	      if (!used_small)
	      {
		used_small = TRUE;
		sprintf(&obuf[orsz],"DFntS\n");
		WRITELASER(strlen(&obuf[orsz]));
	      }
	      sprintf(&obuf[orsz],"FntS setfont\n");
	      WRITELASER(strlen(&obuf[orsz]));
	      break;

	    case (BS):
	      if ((cx -= tsizex) < 0)
	      {
		cx = XDIM;
	      }
	      break;

	    case (HT):
	    case (SPACE):
	      if ((cx += tsizex) > XDIM)
	      {
		/* new line or margin */
		if ((cy -= tsizey) < 0)
		{
		  cy = YDIM - tsizey;
		  leftmargin = leftmargin ? 0 : XDIM / 2;
		}
		cx = leftmargin;
	      }
	      break;

	    case (VT):
	      if ((cy += tsizey) > YDIM)
	      {
		cy = 0;
	      }
	      break;

	    case (GS):
	      mode = GRAPH;
	      num_vector = -1;
	      break;

	    case (LF):
	    case (CR):
	    case (DEL):
	    case (NUL):
	    case (ESC):
	    case (BEL):
	    case (SYN):
	      /*	      ungetc((char) ESC,infile);           */
	      break;

	    case (ETB):	/* make copy: print & start new page */
	      if (pr_on_er)
	      {
		if (cx || cy != YDIM - tsizey && tekdata) {
			if (num_vector >= 0) {
		  	  if (oldmode == GRAPH)
			    if (num_vector > 0)
		       	      sprintf(&obuf[orsz],"%d %d %d v\n",num_vector,ncx,ncy);
			    else
			      sprintf(&obuf[orsz],"%d %d m\n",ncx,ncy);
                  	  else
                    	    sprintf(&obuf[orsz],"s\n"); 
                  	  num_vector = -1;
			  WRITELASER(strlen(&obuf[orsz]));
                	}
			sprintf(&obuf[orsz],"showpage\nNP\n");
			WRITELASER(strlen(&obuf[orsz]));
                        tekdata = FALSE;
			if (scale_factor != 1.0)
			{
				sprintf(&obuf[orsz],"%f %f scale\n",scale_factor,scale_factor);
				WRITELASER(strlen(&obuf[orsz]));
			}
		}
		cx = 0;
		cy = YDIM - tsizey;
	      }
	      else
	      {
		sprintf(&obuf[orsz],"copypage\n");
		WRITELASER(strlen(&obuf[orsz]));
	      }
	      break;

	    case (SO):
	    case (SI):
	      if (debug) fprintf(stderr,"No alternate character set implemented\n");
	      break;

	    case (CAN):
	    case (SUB):
	    case (ENQ):
	      if (debug) fprintf(stderr,"GIN and BYPASS  modes not implemented\n");
	      break;

	    case ('?'):
	      /*	      ungetc((char) DEL,infile);        */
	      break;

	    default:
	      if (debug) fprintf(stderr,"Unknown LCE mode character 0x%02x ignored\n",c);
	      break;
	  }			/* end of LCE mode switch */
	}
	mode = oldmode;
	break;

      default:
	if (debug) fprintf(stderr,"Unknown major mode %d\n",mode);
	break;
    }				/* end of mode switch */
  }				/* end of main input loop */
  if (!cx && cy == YDIM - tsizey) {
    *rsz = -1;
    if (orsz) {
      stat = sys$qiow(0,laserchan, IO$_WRITEPBLK, 0, 0, 0, obuf, orsz, 0, 0, 0, 0);
      checkstat(stat,"writelaser"); iocount++; orsz = 0;
    }
  }
}
