&       INTEGER FUNCTION ASSIGN(SYSUSER) C ; C     W.S.Bonnett   23 Dec 1980   VAX/VMS1.6   Tape library D C     Routine used to remove a given reel (or set of reels) from theF C        pool of available tapes.  This function can only be performed? C        by a System user.  Tapes of POOL "A" or "R" may not be 2 C        reassigned.  Tape sets are assigned here. C        EXTERNAL FOR$_ATTACCNON        INCLUDE 'TAPELBR.EXT'        INCLUDE 'RECORD.DEC'       LOGICAL*1 SYSUSER  C				Local storage0       CHARACTER TIME*23,LINE*72,USER*12,LABEL*6,"      #   REELS(10)*(TLP$K_REELFLD)'       INTEGER CONFIRM,STATUS,SYS$ASCTIM        INTEGER*2 NSET C   1000 FORMAT(A) !  2000 FORMAT(1X,'Username?   ',$) )  2100 FORMAT(1X,'Label (6 chars.)?   ',$) 1  2210 FORMAT(1X,'What reel #(s) in this set?   ')  C-----       IF(.NOT.SYSUSER) THEN %          CALL LIB$SIGNAL(TLP$_NOPRIV)  C				OK to run, system runner 
       ELSE"          ASSIGN = %LOC(SS$_NORMAL)" C				Get remainder of input string          CALL GETTAPE(LINE)           IF(LINE.EQ.' ') THEN  C				Start prompt, reel #s             WRITE(6,2210) #             READ(5,1000,END=4) LINE $ C				Generate all inputs from string
          ELSE              L=INDEX(LINE,' ') '             M=L + INDEX(LINE(L+1:),' ')              USER=LINE(L+1:M-1)             LABEL=LINE(M+1:)             LINE=LINE(:L-1)           ENDIF C				Parse out reel #s          NSET=0           DO WHILE (LINE.NE.' ')              NSET=NSET+1               REELS(NSET)=LINE(:4)             LINE=LINE(6:)           ENDDO C				Confirm all reels released           DO I=1,NSET6             READ(1,KEYID=0,KEY=REELS(I),ERR=10) RECORD!             IF(RPOOL.NE.'S') THEN ?                CALL LIB$SIGNAL(TLP$_ATTASSRES,%VAL(1),REELS(I))                 RETURN              ENDIF           ENDDO! C				All reels ok, get other data           IF(USER.EQ.' ') THEN      1       WRITE(6,2000) $             READ(5,1000,END=4) RUSER$             IF(RUSER.EQ.' ') GO TO 4
          ELSE              RUSER=USER          ENDIF C				Confirm name is a VAX user           RUIC=0 %          STATUS = CONFIRM(RUSER,RUIC) ,          IF(STATUS.NE.%LOC(SS$_NORMAL)) THEN;             CALL LIB$SIGNAL(%VAL(IAND(STATUS,'1FFFFFF8'X)))              GO TO 1           ENDIF! C				OK user, have UIC, get label           IF(LABEL.EQ.' ') THEN             WRITE(6,2100)              READ(5,1000) RLABEL 
          ELSE              RLABEL=LABEL          ENDIF C				Now for the date %          STATUS = SYS$ASCTIM(,TIME,,) ,          IF(STATUS.NE.%LOC(SS$_NORMAL)) THEN)             CALL LIB$SIGNAL(%VAL(STATUS))              RETURN          ENDIF          RDATE=TIME(:11)* C				All OK, construct & write head record          RSET=NSET          RNEXT=' '%          IF(NSET.GT.1) RNEXT=REELS(2)           RPOOL='U' C				Set up characteristics           J=RCHAR8          RCHAR = IAND(J,NOT(TLP$M_AVAIL+TLP$M_CONTINUE))          RCOMM=' '          REEL=REELS(1)          READ(1,KEY=REEL)           REWRITE(1) RECORD( C				Write continuation records, if nec.          IF(NSET.GT.1) THEN  C				Clear out end of record             RUSER=' '              RLABEL=' '*             RCHAR = RCHAR + TLP$M_CONTINUE             RHEAD=REELS(1) C				Construct & write records             DO I=2,NSET                 RNEXT=' '-                IF(I.LT.NSET) RNEXT=REELS(I+1)                 RSET=I                 REEL=REELS(I)                READ(1,KEY=REEL)                  REWRITE(1) RECORD             ENDDO           ENDIF       ENDIF  C				All done.     4 RETURN C				Read errors    10 CALL ERRSNS(,,,,STATUS) -       IF(STATUS.EQ.%LOC(FOR$_ATTACCNON)) THEN (          CALL LIB$SIGNAL(TLP$_NONEXITAP)
       ELSE$          CALL LIB$STOP(%VAL(STATUS))       ENDIF        RETURN	       END         INTEGER FUNCTION HELP(KEY) C < C     W.S.Bonnett   20 Jan 1981   VAX/VMS 2.1   Tape LibraryE C     Routine to access the HELP library and perform the INSTRUCTIONS  C        and HELP requests.  C        INCLUDE 'TAPELBR.EXT'        INTEGER*2 KEY  C				Local variables$       INCLUDE 'TAPLIBDEF.FOR/NOLIST'       EXTERNAL LBR$C_READ ;       INTEGER STATUS,LBR$INI_CONTROL,LBR$OPEN,LBR$GET_HELP,       #   LIBINDEX,FUNCTION*       CHARACTER HKEY1*4,HKEY2*4,REQUEST*40 C-----       HELP = %LOC(SS$_NORMAL)  C				Set up library index ;       STATUS = LBR$INI_CONTROL(LIBINDEX,%LOC(LBR$C_READ),,)        IF(.NOT.STATUS) THEN5          CALL LIB$SIGNAL(TLP$_PROINIHEL,%VAL(STATUS))           RETURN        ENDIF " C				Open the TAPELIB help library-       STATUS = LBR$OPEN(LIBINDEX,'TAPE$HELP')        IF(.NOT.STATUS) THEN5          CALL LIB$SIGNAL(TLP$_PROOPEHEL,%VAL(STATUS))           RETURN        ENDIF  C				INSTRUCTIONS?#       IF(KEY.EQ.TLP$C_INSTRUC) THEN .          STATUS = LBR$GET_HELP(LIBINDEX,72,,,)          GO TO 2       ENDIF  C				Get remainder of request        CALL GETTAPE(REQUEST)  C				Change '/' to ' /' 	       M=0        L=INDEX(REQUEST,'/')       DO WHILE (L.GT.0)           M=M+L%          REQUEST(M:)=' '//REQUEST(M:)           M=M+1#          L=INDEX(REQUEST(M+1:),'/')        ENDDO ' C				Remove multiple blanks from string        L=INDEX(REQUEST,'  ')        DO WHILE (L.GT.0) $          IF(REQUEST(L:).EQ.' ') THEN C				End of string             L=0  C				Not end of string
          ELSE %             REQUEST(L:)=REQUEST(L+1:) !             L=INDEX(REQUEST,'  ')           ENDIF       ENDDO 2       IF(REQUEST(:1).EQ.' ') REQUEST = REQUEST(2:) C				HELP something        IF(REQUEST.NE.' ') THEN           L=INDEX(REQUEST,' ')           HKEY1=REQUEST(:L-1) C				Look for a sub-key $          IF(REQUEST(L:).NE.' ') THEN!             REQUEST=REQUEST(L+1:)               L=INDEX(REQUEST,' ')             HKEY2=REQUEST(:L-1) <             STATUS = LBR$GET_HELP(LIBINDEX,72,,,HKEY1,HKEY2)             GO TO 2           ENDIF C				Blank subject
       ELSE          HKEY1='HELP'        ENDIF 0     1 STATUS = LBR$GET_HELP(LIBINDEX,72,,,HKEY1) C				Check for errors      2 IF(.NOT.STATUS) 5      #   CALL LIB$SIGNAL(TLP$_PROGETHEL,%VAL(STATUS))        CALL LBR$CLOSE(LIBINDEX)       RETURN	       END .       INTEGER FUNCTION MODIFY(KEY,SYSUSER,UIC) C < C     W.S.Bonnett   19 Jan 1981   VAX/VMS 2.1   Tape Library@ C     Routine to validate requests to modify the Tape Library to5 C        RELEASE, change the LABEL, or add a COMMENT.  C        EXTERNAL FOR$_ATTACCNON        INCLUDE 'TAPELBR.EXT'        LOGICAL*1 SYSUSER        INTEGER UIC        INTEGER*2 KEY  C				Local variables       BYTE BLANK(0:123)        INTEGER STATUS       CHARACTER TAPE*4       INCLUDE 'RECORD.DEC'       DATA BLANK/124*' '/   1000 FORMAT(A)   2100 FORMAT(2X,'Reel #?   ',$)  C-----       MODIFY = %LOC(SS$_NORMAL)  C				Get tape number, if any       CALL GETTAPE(TAPE) C				Prompt for tape number        IF(TAPE.EQ.' ') THEN          WRITE(6,2100)           READ(5,1000,END=2) TAPE       ENDIF ,       READ(1,KEYID=0,KEY=TAPE,ERR=10) RECORD C				Check for already scratch       IF(RPOOL.EQ.'S') THEN &          IF(KEY.EQ.TLP$C_RELEASE) THEN8             CALL LIB$SIGNAL(TLP$_TAPALRREL,%VAL(1),TAPE)
          ELSE 8             CALL LIB$SIGNAL(TLP$_NOTYOUTAP,%VAL(1),TAPE)          ENDIF          RETURN        ENDIF  C				Check for correct owner       IF(RUIC.NE.UIC) THEN5          CALL LIB$SIGNAL(TLP$_NOTYOUTAP,%VAL(1),TAPE) %          CALL LIB$SIGNAL(TLP$_NOPRIV)           RETURN " C				Check for a continuation reel
       ELSE          K = RCHAR-          IF(IAND(K,TLP$M_CONTINUE).NE.0) THEN A             IF(KEY.EQ.TLP$C_RELEASE.OR.KEY.EQ.TLP$C_INITIAL) THEN G                CALL LIB$SIGNAL(TLP$_ATTRELMID,%VAL(2),%VAL(RSET),RHEAD)                 RETURN ,             ELSE IF(KEY.EQ.TLP$C_LABEL) THEN.                CALL LIB$SIGNAL(TLP$_ALLREELAB)                RETURN              ENDIF  C				Check for 'A' or 'R' 3          ELSE IF(RPOOL.EQ.'A'.OR.RPOOL.EQ.'R') THEN !             IF(.NOT.SYSUSER) THEN +                CALL LIB$SIGNAL(TLP$_NOPRIV)                 RETURN              ELSE,                IF(KEY.EQ.TLP$C_RELEASE) THEN1                   CALL LIB$SIGNAL(TLP$_RESNOTREL)                    RETURN                ENDIF             ENDIF           ENDIF       ENDIF  C				All clear, do it        STATUS = MODCOM(KEY,TAPE) D       IF(STATUS.NE.%LOC(SS$_NORMAL)) CALL LIB$SIGNAL(TLP$_OPENOTCOM) C      2 RETURN C				Read errors    10 CALL ERRSNS(,,,,STATUS) -       IF(STATUS.EQ.%LOC(FOR$_ATTACCNON)) THEN           I=%LOC(TLP$_NOSUCHTAP) 6          IF(KEY.EQ.TLP$C_HANG.OR.KEY.EQ.TLP$C_INITIAL);      #      I=IAND(I,'FFFFFFF8'X) + 4	! Make a severe error =          CALL LIB$SIGNAL(%VAL(I),%VAL(1),TAPE,TLP$_OPENOTCOM) 
       ELSE&          CALL LIB$SIGNAL(%VAL(STATUS))       ENDIF        RETURN	       END '       INTEGER FUNCTION MODCOM(KEY,TAPE)  C < C     W.S.Bonnett   28 Jan 1981   VAX/VMS 2.1   Tape LibraryB C     Routine to accomplish the modifying of the Tape library file C        for user functions. C        INCLUDE 'TAPELBR.EXT'        INTEGER*2 KEY        CHARACTER TAPE*(*) C				Local variables       INCLUDE 'RECORD.DEC':       CHARACTER SAVE*(TLP$K_REELFLD),NEXT*(TLP$K_REELFLD),      #   TODAY*23,USER*12        INTEGER*2 NSET       BYTE BLANK(0:199)        DATA BLANK/200*' '/   1000 FORMAT(A)   2000 FORMAT(2X,'Label?   ',$)4  2100 FORMAT(2X,'Comments? (80 characters or less)') C-----       MODCOM = %LOC(SS$_NORMAL) %       READ(1,KEYID=0,KEY=TAPE) RECORD 
 C				RELEASE? #       IF(KEY.EQ.TLP$C_RELEASE) THEN   C				Go ahead an release the set          SAVE=TAPE     1    NEXT=RNEXT " C				Clear & re-write blank record             K=RCHAR 0             CALL MOVC(TLP$K_LENGTH,BLANK,RECORD)             REEL=SAVE              RPOOL='S' ;             RCHAR = IAND(K,NOT(TLP$M_AVAIL+TLP$M_CONTINUE))              REWRITE(1) RECORD  C				Do continuation reels              IF(NEXT.NE.' ') THEN                SAVE=NEXT&                READ(1,KEY=SAVE) RECORD                GO TO 1             ENDIF  C				LABEL? &       ELSE IF(KEY.EQ.TLP$C_LABEL) THEN          CALL GETTAPE(RLABEL)           IF(RLABEL.EQ.' ') THEN              WRITE(6,2000) %             READ(5,1000,END=2) RLABEL           ENDIF          REWRITE(1) RECORD C				COMMENTS?(       ELSE IF(KEY.EQ.TLP$C_COMMENT) THEN5          OPEN(UNIT=4,NAME='SYS$INPUT',TYPE='UNKNOWN')           WRITE(6,2100)          READ(4,1000) RCOMM           REWRITE(1) RECORD
 C				HANG?%       ELSE IF(KEY.EQ.TLP$C_HANG) THEN           RMOUNT = RMOUNT + 1           RACCDAY = JULIAN(0,0,0)             K=RCHAR ,             RCHAR = IAND(K,NOT(TLP$M_AVAIL))          REWRITE(1) RECORD C				INITIALIZE?(       ELSE IF(KEY.EQ.TLP$C_INITIAL) THEN C				Get new label          CALL GETTAPE(RLABEL)           IF(RLABEL.EQ.' ') THEN              WRITE(6,2000) %             READ(5,1000,END=2) RLABEL           ENDIF  C				Clear comments & reset date          RCOMM=' '"          CALL SYS$ASCTIM(,TODAY,,)          RDATE=TODAY(:11)           REWRITE(1) RECORD C				Fix rest of set (if any)            DO WHILE (RNEXT.NE.' ')$             READ(1,KEY=RNEXT) RECORD             RCOMM = ' '              RDATE = TODAY(:11)             REWRITE(1) RECORD           ENDDO C				DISCONNECT?(       ELSE IF(KEY.EQ.TLP$C_DISCONN) THEN          K=RCHAR-          IF(IAND(K,TLP$M_CONTINUE).EQ.0) THEN 8             CALL LIB$SIGNAL(TLP$_TAPNOTCON,%VAL(1),TAPE) C				Check for last reel
          ELSE !             IF(RNEXT.NE.' ') THEN .                CALL LIB$SIGNAL(TLP$_CANDISMID) C				OK, fix up head reel              ELSE                NSET = RSET'                READ(1,KEY=RHEAD) RECORD                 RSET = NSET-1                USER = RUSER %                IF(RNEXT.NE.TAPE) THEN #                   REWRITE(1) RECORD ! C				Chase down next-to-last reel *                   DO WHILE (RNEXT.NE.TAPE)-                      READ(1,KEY=RNEXT) RECORD                    ENDDO                 ENDIF                RNEXT = ' '                 REWRITE(1) RECORD C				Fix up disconnected reel &                READ(1,KEY=TAPE) RECORD                RUSER = USER                 RLABEL = ' '                 RSET = 1 2                RCHAR = IAND(K,NOT(TLP$M_CONTINUE))                 REWRITE(1) RECORD             ENDIF           ENDIF C				Something else???
       ELSE:          CALL LIB$SIGNAL(TLP$_STRMODCOM,%VAL(1),%VAL(KEY)) C        ENDIF      2 RETURN	       END '       INTEGER FUNCTION CONNECT(SYSUSER)  C ; C     W.S.Bonnett   4 Feb 1981   VAX/VMS 2.1   Tape library D C     Routine connects new reel (NEWREEL) to the tape set containingG C        reel number HEAD (fastest operation occurs when HEAD is indeed E C        the head of the tape set, but it is not required.)  Both the B C        set and the new reel must belong to the same user - whichG C        means the new reel must already have been ASSIGNed and scratch $ C        reels may not be connected. C        EXTERNAL FOR$_ATTACCNON        INCLUDE 'TAPELBR.EXT'        LOGICAL*1 SYSUSER  C				Local variables'       CHARACTER NEWREEL*4,HEAD*4,POOL*1        INTEGER UIC,STATUS       INTEGER*2 NSET       INCLUDE 'RECORD.DEC' C   1000 FORMAT(A)   2000 FORMAT(' Reel #?   ',$) <  2100 FORMAT(' Reel number of set to be connected to?   ',$) C-----       IF(.NOT.SYSUSER) THEN %          CALL LIB$SIGNAL(TLP$_NOPRIV)  C				Adequate privilege 
       ELSE C				Get reel # to be connected           CALL GETTAPE(NEWREEL)           IF(NEWREEL.EQ.' ') THEN             WRITE(6,2000) &             READ(5,1000,END=1) NEWREEL          ENDIF C				Check for tape, get owner8          HEAD=NEWREEL		! For possible signal output only2          READ(1,KEYID=0,KEY=NEWREEL,ERR=10) RECORD          K = RCHAR          IF(RPOOL.EQ.'S') THEN+             CALL LIB$SIGNAL(TLP$_CANCONSCR)              RETURN2          ELSE IF(IAND(K,TLP$M_CONTINUE).NE.0) THEN+             CALL LIB$SIGNAL(TLP$_TAPALRCON, 0      #         %VAL(3),NEWREEL,%VAL(RSET),RHEAD)             RETURN          ENDIF          UIC=RUIC           POOL = RPOOL   C				Get tape # in set somewhere          CALL GETTAPE(HEAD)           IF(HEAD.EQ.' ') THEN              WRITE(6,2100) #             READ(5,1000,END=1) HEAD           ENDIF C				Check for tape & owner '          READ(1,KEY=HEAD,ERR=10) RECORD           IF(RUIC.NE.UIC) THEN +             CALL LIB$SIGNAL(TLP$_MISMATOWN)              RETURN          ENDIF C				Find head of set           K = RCHAR-          IF(IAND(K,TLP$M_CONTINUE).NE.0) THEN              HEAD=RHEAD#             READ(1,KEY=HEAD) RECORD           ENDIF:          IF(RPOOL.NE.POOL) CALL LIB$SIGNAL(TLP$_ATTCONMIS) C				Adding to single volume          IF(RNEXT.EQ.' ') THEN             NSET=2             RSET=2             RNEXT = NEWREEL              REWRITE(1) RECORD ( C				Multi-volume set, fix count in head
          ELSE              RSET=RSET+1              NSET=RSET              REWRITE(1) RECORD  C				Find last volume of set#             DO WHILE (RNEXT.NE.' ') '                READ(1,KEY=RNEXT) RECORD              ENDDO              RNEXT = NEWREEL              REWRITE(1) RECORD           ENDIF C				Add NEWREEL to set #          READ(1,KEY=NEWREEL) RECORD '          RCHAR = RCHAR + TLP$M_CONTINUE           RUSER=' '          RLABEL=' '           RSET = NSET          RHEAD = HEAD           REWRITE(1) RECORD
 C				All done        ENDIF      1 RETURN C				Read errors    10 CALL ERRSNS(,,,,STATUS) -       IF(STATUS.EQ.%LOC(FOR$_ATTACCNON)) THEN D          CALL LIB$SIGNAL(TLP$_NOSUCHTAP,%VAL(1),HEAD,TLP$_CONNOTCOM)
       ELSE&          CALL LIB$SIGNAL(%VAL(STATUS))       ENDIF        RETURN	       END $       INTEGER FUNCTION PACK(SYSUSER) C < C     W.S.Bonnett   10 Apr 1981   VAX/VMS 2.1   Tape library? C     Routine to write information on non-scratch tape reels to A C        a sequential (editable) file.  The file may then be used B C        to REBUILD the tape library at a later date, for whatever C        reason. C        INCLUDE 'TAPELBR.EXT'        INCLUDE 'RECORD.DEC'       LOGICAL*1 SYSUSER  C				Local variables,       CHARACTER SAVE*(TLP$K_REELFLD),USER*12 C-----       IF(.NOT.SYSUSER) THEN %          CALL LIB$SIGNAL(TLP$_NOPRIV)  C				Adequate privilege 
       ELSE!          J = (TLP$K_LENGTH-1)/4+1 1          OPEN(UNIT=2,NAME='TAPE$PACK',TYPE='NEW', ,      #      RECORDTYPE='FIXED',RECORDSIZE=J,6      #      FORM='UNFORMATTED',CARRIAGECONTROL='LIST')  C				If here then file opened OK,          READ(1,KEYID=0,KEYGT='    ') RECORD          DO WHILE (.TRUE.)% C				Scratch pool has no useful info. 2             IF(RPOOL.NE.'S'.AND.RDATE.NE.' ') THEN& C				Fix up data on continuation reels                K=RCHAR3                IF(IAND(K,TLP$M_CONTINUE).NE.0) THEN                    SAVE = REEL *                   READ(1,KEY=RHEAD) RECORD                   USER = RUSER)                   READ(1,KEY=SAVE) RECORD                    RUSER = USER                   RLABEL = ' '                ENDIF C				Write it out A                WRITE(2) REEL,RUSER,RPOOL,RNEXT,RDATE,RLABEL,RCOMM              ENDIF   C				Get next reel (if not done)              READ(1,END=1) RECORD          ENDDO       ENDIF 
 C				All done      1 CLOSE(UNIT=2)        PACK = %LOC(SS$_NORMAL)        RETURN	       END 