&       INTEGER FUNCTION CREATE(SYSUSER) C ; C     W.S.Bonnett   22 Dec 1980   VAX/VMS1.6   Tape library ? C     Routine to create a new tape library data file.  First it A C        checks the user for adequate privilege, then prompts for > C        desireable info., creates a new RELATIVE organization@ C        file, and fills it with reserved, archived, and scratch C        tapes.  C        INCLUDE 'TAPELBR.EXT'        INCLUDE 'RECORD.DEC'       LOGICAL*1 SYSUSER  C				Local variables&       CHARACTER REELNO*(TLP$K_REELFLD)       BYTE BLANK(0:200)        INTEGER STATUS,CNVREEL       DATA BLANK/201*' '/  C >  2000 FORMAT(2X,'How many tapes will be in the library?   ',$)D  2100 FORMAT(2X,' and how many of these will be reserved for system'      #   ' use?   ',$)H  2200 FORMAT(2X,' and how many more will be reserved for archiving?   ',      #   $) B  3000 FORMAT(/1X,'** You are now referring to the newly created ',E      #   'tape library. **'/3X,'To recover the old library you must', (      #   ' delete the current version.') C-----       CREATE = %LOC(SS$_NORMAL)        IF(SYSUSER) THEN C				Adequate privilege.     1    WRITE(6,2000)%          READ(5,*,END=3,ERR=1) NTAPES  C				How many reserved?           WRITE(6,2100)#          READ(5,*,END=3,ERR=1) NRES            IF(NRES.GT.NTAPES) THEN(          CALL LIB$SIGNAL(TLP$_MORTAPRES)             GO TO 1           ENDIF! C				How many for system backups?           WRITE(6,2200)$          READ(5,*,END=3,ERR=1) NARCH!          IF(NARCH.GT.NTAPES) THEN (          CALL LIB$SIGNAL(TLP$_MORTAPARC)             GO TO 1 
          ELSE )             IF(NARCH+NRES.GT.NTAPES) THEN (          CALL LIB$SIGNAL(TLP$_TOOMANTAP)                GO TO 1             ENDIF           ENDIF C				Create a new file'          I= TLP$K_LENGTH*NTAPES/512 + 3            J= (TLP$K_LENGTH-1)/4+1<          OPEN(UNIT=2,NAME='TAPE$LIBRARY',FORM='UNFORMATTED',0      #      ORGANIZATION='INDEXED',RECORDSIZE=J,%      #      TYPE='NEW',INITIALSIZE=I, -      #      KEY=(1:4,7:10:INTEGER,15:25,6:6))  C				Clear out record -          CALL MOVC(TLP$K_LENGTH,BLANK,RECORD)  C				Fill up file           DO 2 I=1,NTAPES C				Create our type of reel #$             STATUS = CNVREEL(REEL,I) C				Parcel out tapes              RCHAR = TLP$M_AVAIL -             IF(I.LT.NTAPES-(NARCH+NRES)) THEN                 RPOOL='S'             ELSE7                RUIC='10004'X		! Owned by System Manager +                RCHAR = RCHAR + TLP$M_SYSTEM                 RUSER = 'SYSTEM' (                IF(I.LT.NTAPES-NRES) THEN                   RPOOL='A'                 ELSE                    RPOOL='R'                 ENDIF             ENDIF              WRITE(2) RECORD 
 C				All done      2    CONTINUE           CLOSE(UNIT=2)          CLOSE(UNIT=1)C          OPEN(UNIT=1,NAME='TAPE$LIBRARY',TYPE='OLD',ACCESS='KEYED')           WRITE(6,3000) C				Non-privileged user
       ELSE%          CALL LIB$SIGNAL(TLP$_NOPRIV)        ENDIF  C      3 RETURN	       END '       INTEGER FUNCTION REBUILD(SYSUSER)  C < C     W.S.Bonnett   12 Jan 1981   VAX/VMS 2.1   Tape libraryB C     Routine to acquire existing data from a tape library already1 C        in existence, and rebuild a new library.  C        INCLUDE 'TAPELBR.EXT'        INCLUDE 'RECORD.DEC'       LOGICAL*1 SYSUSER  C				Local variables       LOGICAL*1 NEWREEL .       BYTE INPUT(0:TLP$C_RECSIZE),BLANK(0:200)$       INTEGER STATUS,CONFIRM,CNVREEL:       CHARACTER FILE*40,FIELD(7)*10,POSCH*3,TODAY*23,NOY*3$       CHARACTER SAVE*(TLP$K_REELFLD),       INTEGER*2 TPL(7),LENGTH(7),PLC(7),SIZE C ;       DATA LENGTH/TLP$K_REELFLD,12,1,TLP$K_REELFLD,11,80,6/        DATA TPL/ @      #   TLP$T_REELNUM,TLP$T_USERNAME,TLP$T_POOL,TLP$T_NEXTREEL,.      #   TLP$T_DATE,TLP$T_COMMENTS,TLP$T_LABEL
      #   /"       DATA PLC/1,5,17,18,22,39,33/8       DATA FIELD/'Reel #','Username','Pool','Next reel',#      #   'Date','Comments','Label'/        DATA BLANK/201*' '/  C   1000 FORMAT(A)   1100 FORMAT(I3)  1200 FORMAT(Q,<SIZE>A1)9  2000 FORMAT(/2X,'Enter the name of the data file.   ',$) =  2100 FORMAT(2X,'Is this a rebuild of a previous PACK?   ',$) 0  2200 FORMAT(5X,A10,' at position: ',I3,'   ',$)B  2300 FORMAT(2X,'Do you need to convert old reel #s to new?   ',$) C-----       IF(.NOT.SYSUSER) THEN %          CALL LIB$SIGNAL(TLP$_NOPRIV) % C				Adequate priv., start the set up 
       ELSE"          CALL SYS$ASCTIM(,TODAY,,)$ C				Check for rebuild of known file          WRITE(6,2100)          READ(5,1000) NOY            IF(NOY(:1).EQ.'Y') THEN4             OPEN(UNIT=3,NAME='TAPE$PACK',TYPE='OLD') C				Different file structure 
          ELSE              WRITE(6,2000) $             READ(5,1000,END=10) FILE C				Open the file-             OPEN(UNIT=3,NAME=FILE,TYPE='OLD') % C				Determine fields in strange file              DO I=1,7,                WRITE(6,2200) FIELD(I),PLC(I)"                READ(5,1100) PLC(I)             ENDDO ! C				Confirm REQUIRED information               IF(PLC(1).LE.0) THEN.                CALL LIB$SIGNAL(TLP$_REENUMMUS)                GO TO 10 %             ELSE IF(PLC(2).LE.0) THEN 1                   CALL LIB$SIGNAL(TLP$_USENAMMUS)                    GO TO 10             ENDIF           ENDIF  C				Use new-style reel numbers?          NEWREEL=.FALSE.          WRITE(6,2300)          READ(5,1000) NOY *          IF(NOY(:1).EQ.'Y') NEWREEL=.TRUE. C				Start reading=          WRITE(6,*) '* REBUILD beginning  to read old file.*'           DO 7 WHILE (.TRUE.)9             READ(3,1200,END=3) SIZE,(INPUT(J),J=0,SIZE-1)  C				Clear output record0             CALL MOVC(TLP$K_LENGTH,BLANK,RECORD)             RCHAR=0  C				Generate output record              DO I=1,7                IF(PLC(I).GT.0)E      #            CALL MOVC(LENGTH(I),INPUT(PLC(I)-1),RECORD(TPL(I)))              ENDDO  C				Convert reel #s             IF(NEWREEL) THEN'                STATUS = CNVREEL(REEL,0) 9                IF(RNEXT.NE.' ') STATUS = CNVREEL(RNEXT,0) 9                IF(RHEAD.NE.' ') STATUS = CNVREEL(RHEAD,0) 2                IF(STATUS.NE.%LOC(SS$_NORMAL)) THEN1                   CALL LIB$SIGNAL(TLP$_TAPNOTENT, "      #               %VAL(1),REEL)                   GO TO 7                 ENDIF             ENDIF  C				Fill up blank spots-             IF(RDATE.EQ.' ') RDATE=TODAY(:11) D             IF(RDATE(8:9).NE.'19') RDATE=RDATE(:7)//'19'//RDATE(8:9)&             IF(RPOOL.EQ.' ') RPOOL='U' C				Fix up characteristics              I = RCHAR ,             RCHAR = IAND(NOT(TLP$M_AVAIL),I),             IF(RPOOL.EQ.'A'.OR.RPOOL.EQ.'R')+      #         RCHAR = RCHAR + TLP$M_SYSTEM  C				Check for still valid user              RUIC = 0(             STATUS = CONFIRM(RUSER,RUIC)/             IF(STATUS.NE.%LOC(SS$_NORMAL)) THEN                 RUIC='10003'X             ENDIF ' C				Locate record & write string to it +             READ(1,KEYID=0,KEY=REEL,ERR=10)              REWRITE(1) RECORD      7    ENDDO  C				Start tape set constructionA     3    WRITE(6,*) '* REBUILD starting to construct tape sets.*' 4          READ(1,KEYID=0,KEYGT='    ') RECORD	!Rewind          DO WHILE (.TRUE.) C				Check for unused tapes $             IF(RPOOL.EQ.'S') GO TO 4             SAVE = REEL  C				Check for type set              I = RCHAR A             IF(RNEXT.NE.' '.AND.IAND(I,TLP$M_CONTINUE).EQ.0) THEN                 NSET=1 &                DO WHILE (RNEXT.NE.' ')# C				Chase down reel #s of this set                    NSET=NSET+1 *                   READ(1,KEY=RNEXT) RECORD C				Modify data & rewrite0                   RCHAR = RCHAR + TLP$M_CONTINUE                   RSET=NSET                    RLABEL=' '                   RUSER=' '                    RHEAD=SAVE#                   REWRITE(1) RECORD                 ENDDO C				Go back to head of set &                READ(1,KEY=SAVE) RECORD                RSET=NSET                 REWRITE(1) RECORD             ENDIF       4       READ(1,END=5) RECORD          ENDDO
 C				All done *     5    WRITE(6,*) '* REBUILD complete.*'#          REBUILD = %LOC(SS$_NORMAL)        ENDIF        RETURN C				Reead error - key = reel #     10 CALL ERRSNS(,,,,STATUS) -       IF(STATUS.EQ.%LOC(FOR$_ATTACCNON)) THEN 5          CALL LIB$SIGNAL(TLP$_TAPNOTENT,%VAL(1),REEL)           GO TO 7
       ELSE$          CALL LIB$STOP(%VAL(STATUS))       ENDIF        RETURN	       END (       INTEGER FUNCTION CNVREEL(REEL,NUM) C < C     W.S.Bonnett   17 Jan 1981   VAX/VMS 2.1   Tape libraryA C     Routine to convert either an old-style reel number to a new A C        reel number (NUM<=0), or generate the NUM-th reel number  C        in the new style. C (       EXTERNAL SS$_NORMAL,TLP$_FAICONREE       CHARACTER REEL*4,TEMP*4        INTEGER NUM   1000 FORMAT('V',I3.3) C-----        CNVREEL = %LOC(SS$_NORMAL) C				Generate new        IF(NUM.GT.0) THEN           IF(NUM.GT.999) THEN             CNVREEL = 0 +             CALL LIB$SIGNAL(TLP$_FAICONREE)              TEMP = ' '
          ELSE               WRITE(TEMP,1000) NUM          ENDIF C				Old reel # to new
       ELSE          TEMP=REEL'          IF(INDEX(REEL,'  ').GT.0) THEN !             TEMP='V00'//REEL(2:2) +          ELSE IF(INDEX(REEL,' ').GT.0) THEN               TEMP='V0'//REEL(2:3)          ENDIF       ENDIF  C        REEL=TEMP        RETURN	       END 