/*******************************************************************************
*									       *
* menu.c -- Nirvana Editor menus					       *
*									       *
* Copyright (c) 1991 Universities Research Association, Inc.		       *
* All rights reserved.							       *
* 									       *
* This material resulted from work developed under a Government Contract and   *
* is subject to the following license:  The Government retains a paid-up,      *
* nonexclusive, irrevocable worldwide license to reproduce, prepare derivative *
* works, perform publicly and display publicly by or for the Government,       *
* including the right to distribute to other Government contractors.  Neither  *
* the United States nor the United States Department of Energy, nor any of     *
* their employees, makes any warrenty, express or implied, or assumes any      *
* legal liability or responsibility for the accuracy, completeness, or         *
* usefulness of any information, apparatus, product, or process disclosed, or  *
* represents that its use would not infringe privately owned rights.           *
*                                        				       *
* Fermilab Nirvana GUI Library						       *
* May 10, 1991								       *
*									       *
* Written by Mark Edel							       *
*									       *
*******************************************************************************/
static char SCCSID[] = "@(#)menu.c	1.13     10/8/93";
#ifdef VMS
#include "../util/VMSparam.h"
#else
#include <sys/param.h>
#endif /*VMS*/
#include <X11/X.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include "../util/getfiles.h"
#include "../util/fontsel.h"
#include "../util/DialogF.h"
#include "nedit.h"
#include "file.h"
#include "menu.h"
#include "window.h"
#include "search.h"
#include "clipboard.h"
#include <Xm/Text.h>
#include "undo.h"
#include "shift.h"
#include "help.h"
#include "preferences.h"
#include "tags.h"

#define PERMANENT 1
#define WINDOW_NAME 2

static void newCB(Widget w, WindowInfo *window, caddr_t callData);
static void openCB(Widget w, WindowInfo *window, caddr_t callData);
static void closeCB(Widget w, WindowInfo *window, caddr_t callData);
static void saveCB(Widget w, WindowInfo *window, caddr_t callData);
static void saveAsCB(Widget w, WindowInfo *window, caddr_t callData); 
static void revertCB(Widget w, WindowInfo *window, caddr_t callData); 
static void loadTagsCB(Widget w, WindowInfo *window, caddr_t callData);
static void printCB(Widget w, WindowInfo *window, caddr_t callData);
static void printSelCB(Widget w, WindowInfo *window, caddr_t callData);
static void exitCB(Widget w, WindowInfo *window, caddr_t callData);
static void undoCB(Widget w, WindowInfo *window, caddr_t callData);
static void cutCB(Widget w, WindowInfo *window,XmAnyCallbackStruct *callData); 
static void copyCB(Widget w,WindowInfo *window,XmAnyCallbackStruct *callData);
static void pasteCB(Widget w,WindowInfo *window, XmAnyCallbackStruct *callData);
static void clearCB(Widget w, WindowInfo *window, caddr_t callData);
static void shiftLeftCB(Widget w, WindowInfo *window, caddr_t callData);
static void shiftRightCB(Widget w, WindowInfo *window, caddr_t callData);
static void findCB(Widget w, WindowInfo *window,XmAnyCallbackStruct *callData); 
static void findSameCB(Widget w, WindowInfo *window,
		       XmAnyCallbackStruct *callData);
static void findSelCB(Widget w, WindowInfo *window,
		      XmAnyCallbackStruct *callData);
static void replaceCB(Widget w, WindowInfo *window,
		      XmAnyCallbackStruct *callData);
static void replaceSameCB(Widget w, WindowInfo *window,
			  XmAnyCallbackStruct *callData); 
static void gotoCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData); 
static void gotoSelectedCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData); 
static void findMatchingCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData); 
static void findDefCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData);
static void autoIndentCB(Widget w, WindowInfo *window, caddr_t callData);
static void autoSaveCB(Widget w, WindowInfo *window, caddr_t callData);
static void wrapCB(Widget w, WindowInfo *window, caddr_t callData);
static void fontCB(Widget w, WindowInfo *window, caddr_t callData);
static void statsCB(Widget w, WindowInfo *window, caddr_t callData);
static void autoIndentDefCB(Widget w, WindowInfo *window, caddr_t callData);
static void autoSaveDefCB(Widget w, WindowInfo *window, caddr_t callData);
static void wrapDefCB(Widget w, WindowInfo *window, caddr_t callData);
static void fontDefCB(Widget w, WindowInfo *window, caddr_t callData);
static void searchDlogsDefCB(Widget w, WindowInfo *window, caddr_t callData);
static void searchLiteralCB(Widget w, WindowInfo *window, caddr_t callData);
static void searchCaseSenseCB(Widget w, WindowInfo *window, caddr_t callData);
static void searchRegexCB(Widget w, WindowInfo *window, caddr_t callData);
static void size24x80CB(Widget w, WindowInfo *window, caddr_t callData);
static void size40x80CB(Widget w, WindowInfo *window, caddr_t callData);
static void size60x80CB(Widget w, WindowInfo *window, caddr_t callData);
static void size80x80CB(Widget w, WindowInfo *window, caddr_t callData);
static void sizeCustomCB(Widget w, WindowInfo *window, caddr_t callData);
static void savePrefCB(Widget w, WindowInfo *window, caddr_t callData);
static void splitWindowCB(Widget w, WindowInfo *window, caddr_t callData);
static void closePaneCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpStartCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpSearchCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpSelectCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpClipCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpProgCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpNavCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpRecoveryCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpPrefCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpCmdLineCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpCustCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpVerCB(Widget w, WindowInfo *window, caddr_t callData);
static void helpBugsCB(Widget w, WindowInfo *window, caddr_t callData);
static void windowMenuCB(Widget w, WindowInfo *window, caddr_t callData);
static void checkCloseDim(void);
static void updateWindowMenu(WindowInfo *window);
static void raiseCB(Widget w, WindowInfo *window, caddr_t callData);
static void setWindowSizeDefault(int rows, int cols);
static void updateWindowSizeMenus();
static void updateWindowSizeMenu(WindowInfo *win);

/*
** Create the menu bar
*/
Widget CreateMenuBar(Widget parent, WindowInfo *window)
{
    Widget	menuBar;	/*  RowColumn	 		*/
    Widget	cascade;	/*  CascadeButton		*/
    Widget	menuPane;	/*  RowColumn	 		*/
    Widget	subPane;	/*  RowColumn	 		*/
    Widget	subSubPane;	/*  RowColumn	 		*/
    Widget	button;		/*  PushButton			*/
    Widget	fakeBtn1;	/*  PushButton			*/
    Widget	fakeBtn2;	/*  PushButton			*/
    Widget	fakeBtn3;	/*  PushButton			*/
    Widget	fakeBtn4;	/*  PushButton			*/
    Widget	fakeBtn5;	/*  PushButton			*/

    Arg		al[10];		/*  arg list			*/
    int		ac;		/*  arg count			*/
    XmString	st1, st2;

    /*
    ** Create MenuArea.
    */
    ac = 0;
    menuBar = XmCreateMenuBar(parent, "menuBar", al, ac);

    /*
    ** Create "File" pull down menu.
    */
    ac = 0;
    menuPane = XmCreatePulldownMenu(menuBar, "file", al, ac);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("New")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'N'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+N")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl <Key> n"); ac++;
    button = XmCreatePushButton(menuPane, "new", al, ac);
    XtAddCallback (button, XmNactivateCallback, newCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Open...")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'O'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+O")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl <Key> o"); ac++;
    button = XmCreatePushButton(menuPane, "open", al, ac);
    XtAddCallback (button, XmNactivateCallback, openCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator1", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Close")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'C'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+W")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl <Key> w"); ac++;
    button = XmCreatePushButton(menuPane, "close", al, ac);
    XtAddCallback (button, XmNactivateCallback, closeCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);
    checkCloseDim();
    window->closeItem = button;

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Save")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'S'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+S")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl <Key> s"); ac++;
    button = XmCreatePushButton (menuPane, "save", al, ac);
    XtAddCallback (button, XmNactivateCallback, saveCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Save As...")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'A'); ac++;
    button = XmCreatePushButton (menuPane, "saveAs", al, ac);
    XtAddCallback (button, XmNactivateCallback, saveAsCB, window);
    XtManageChild (button);
    XmStringFree(st1);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Revert to Saved")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'R'); ac++;
    button = XmCreatePushButton (menuPane, "revert", al, ac);
    XtAddCallback (button, XmNactivateCallback, revertCB, window);
    XtManageChild (button);
    XmStringFree(st1);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator2", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Load Tags File...")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'L'); ac++;
    button = XmCreatePushButton (menuPane, "loadTags", al, ac);
    XtAddCallback (button, XmNactivateCallback, loadTagsCB, window);
    XtManageChild (button);
    XmStringFree(st1);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator3", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Print...")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'P'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+P")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl <Key> p"); ac++;
    button = XmCreatePushButton (menuPane, "print", al, ac);
    XtAddCallback (button, XmNactivateCallback, printCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Print Selection...")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 't'); ac++;
    button = XmCreatePushButton (menuPane, "printSel", al, ac);
    XtAddCallback (button, XmNactivateCallback, printSelCB, window);
    XtManageChild (button);
    XmStringFree(st1);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator4", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Exit")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'E'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("F3")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "<Key>F3:"); ac++;
    button = XmCreatePushButton (menuPane, "exit", al, ac);
    XtAddCallback (button, XmNactivateCallback, exitCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg (al[ac], XmNsubMenuId, menuPane);  ac++;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("File")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'F'); ac++;
    cascade = XmCreateCascadeButton (menuBar, "fileB", al, ac);
    XtManageChild (cascade);
    XmStringFree(st1);

    /* 
    ** Create "Edit" pull down menu.
    */
    ac = 0;
    menuPane = XmCreatePulldownMenu (menuBar, "edit", al, ac);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Undo")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'U'); ac++;
#ifndef MOTIF10
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Alt+Backspace")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Alt<Key>BackSpace:"); ac++;
#else
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+Z")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>z"); ac++;
#endif
    XtSetArg(al[ac], XmNsensitive, False); ac++;
    button = XmCreatePushButton (menuPane, "undo", al, ac);
    XtAddCallback (button, XmNactivateCallback, undoCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);
    window->undoItem = button;

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator1", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Cut")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 't'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Shift+Del")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Shift<Key>Delete:"); ac++;
    button = XmCreatePushButton (menuPane, "cut", al, ac);
    XtAddCallback (button, XmNactivateCallback, cutCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Copy")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'C'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+Ins")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>Insert:"); ac++;
    button = XmCreatePushButton (menuPane, "copy", al, ac);
    XtAddCallback (button, XmNactivateCallback, copyCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Paste")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'P'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Shift+Ins")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Shift<Key>Insert:"); ac++;
    button = XmCreatePushButton (menuPane, "paste", al, ac);
    XtAddCallback (button, XmNactivateCallback, pasteCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Clear")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'e'); ac++;
    /* pseudo accelerator - Text already handles this action appropriately */
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Del")); ac++;
    button = XmCreatePushButton (menuPane, "clear", al, ac);
    XtAddCallback (button, XmNactivateCallback, clearCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Shift Left")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'L'); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>9"); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+9")); ac++;
    button = XmCreatePushButton (menuPane, "shiftLeft", al, ac);
    XtAddCallback (button, XmNactivateCallback, shiftLeftCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Shift Right")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'R'); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>0"); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+0")); ac++;
    button = XmCreatePushButton (menuPane, "shiftRight", al, ac);
    XtAddCallback (button, XmNactivateCallback, shiftRightCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg (al[ac], XmNsubMenuId, menuPane);  ac++;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Edit")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'E'); ac++;
    cascade= XmCreateCascadeButton (menuBar, "editB", al, ac);
    XtManageChild (cascade);
    XmStringFree(st1);

    /* 
    ** Create "Search" pull down menu.
    */
    ac = 0;
    menuPane = XmCreatePulldownMenu (menuBar, "search", al, ac);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Find...")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'F'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("[Shift]Ctrl+F")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>f"); ac++;
    button = XmCreatePushButton (menuPane, "find", al, ac);
    XtAddCallback (button, XmNactivateCallback, findCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    
    ac = 0; /* Fake "Find Backward" button with Shifted accelerator keys */
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("")); ac++;
    XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
    XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
    XtSetArg(al[ac], XmNheight, 0); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Shift Ctrl<Key>f"); ac++;
    fakeBtn1 = XmCreatePushButton (menuPane, "bFind", al, ac);
    XtAddCallback (fakeBtn1, XmNactivateCallback, findCB, window);
    XtManageChild (fakeBtn1);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Find Same")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'i'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("[Shift]Ctrl+G")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>g"); ac++;
    button = XmCreatePushButton (menuPane, "findSame", al, ac);
    XtAddCallback (button, XmNactivateCallback, findSameCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);
 
    ac = 0; /* Fake "Find Same" button with Shifted accelerator keys */
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("")); ac++;
    XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
    XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
    XtSetArg(al[ac], XmNheight, 0); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Shift Ctrl<Key>g"); ac++;
    fakeBtn2 = XmCreatePushButton (menuPane, "bFindSame", al, ac);
    XtAddCallback (fakeBtn2, XmNactivateCallback, findSameCB, window);
    XtManageChild (fakeBtn2);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString,st1=MKSTRING("Find Selection")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'S'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("[Shift]Ctrl+H")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>h"); ac++;
    button = XmCreatePushButton (menuPane, "findSelection", al, ac);
    XtAddCallback (button, XmNactivateCallback, findSelCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0; /* Fake "Find Selection" button with Shifted accelerator keys */
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("")); ac++;
    XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
    XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
    XtSetArg(al[ac], XmNheight, 0); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Shift Ctrl<Key>h"); ac++;
    fakeBtn3 = XmCreatePushButton (menuPane, "bFindSelection", al, ac);
    XtAddCallback (fakeBtn3, XmNactivateCallback, findSelCB, window);
    XtManageChild (fakeBtn3);
    XmStringFree(st1);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Replace...")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'R'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("[Shift]Ctrl+R")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>r"); ac++;
    button = XmCreatePushButton (menuPane, "replace", al, ac);
    XtAddCallback (button, XmNactivateCallback, replaceCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0; /* Fake "Replace" button with Shifted accelerator keys */
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("")); ac++;
    XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
    XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
    XtSetArg(al[ac], XmNheight, 0); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Shift Ctrl<Key>r"); ac++;
    fakeBtn4 = XmCreatePushButton (menuPane, "bReplace", al, ac);
    XtAddCallback (fakeBtn4, XmNactivateCallback, replaceCB, window);
    XtManageChild (fakeBtn4);
    XmStringFree(st1);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Replace Same")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'p'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("[Shift]Ctrl+T")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>t"); ac++;
    button = XmCreatePushButton (menuPane, "replaceSame", al, ac);
    XtAddCallback (button, XmNactivateCallback, replaceSameCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0; /* Fake "Replace" button with Shifted accelerator keys */
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("")); ac++;
    XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
    XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
    XtSetArg(al[ac], XmNheight, 0); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Shift Ctrl<Key>t"); ac++;
    fakeBtn5 = XmCreatePushButton (menuPane, "bReplaceSame", al, ac);
    XtAddCallback (fakeBtn5, XmNactivateCallback, replaceSameCB, window);
    XtManageChild (fakeBtn5);
    XmStringFree(st1);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Goto Line #")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'L'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+L")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>l"); ac++;
    button = XmCreatePushButton (menuPane, "gotoNumber", al, ac);
    XtAddCallback (button, XmNactivateCallback, gotoCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Goto Selected")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'G'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+E")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>e"); ac++;
    button = XmCreatePushButton (menuPane, "gotoSelected", al, ac);
    XtAddCallback (button, XmNactivateCallback, gotoSelectedCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator", al, ac);
    XtManageChild (button);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Match (..)")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'M'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+M")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>m"); ac++;
    button = XmCreatePushButton (menuPane, "findMatching", al, ac);
    XtAddCallback (button, XmNactivateCallback, findMatchingCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Find Definition")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'D'); ac++;
    XtSetArg(al[ac], XmNacceleratorText, st2=MKSTRING("Ctrl+D")); ac++;
    XtSetArg(al[ac], XmNaccelerator, "Ctrl<Key>d"); ac++;
    XtSetArg(al[ac], XmNsensitive, TagsFileLoaded()); ac++;
    button = XmCreatePushButton (menuPane, "findDefinition", al, ac);
    XtAddCallback (button, XmNactivateCallback, findDefCB, window);
    XtManageChild (button);
    XmStringFree(st1);
    XmStringFree(st2);
    window->findDefItem = button;
 
    ac = 0;
    XtSetArg (al[ac], XmNsubMenuId, menuPane);  ac++;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Search")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'S'); ac++;
    cascade= XmCreateCascadeButton (menuBar, "searchB", al, ac);
    XtManageChild (cascade);
    XmStringFree(st1);
     
    /* turn off traversal for fake items implementing shifted accelerators */
    SET_ONE_RSRC(fakeBtn1, XmNtraversalOn, False);
    SET_ONE_RSRC(fakeBtn2, XmNtraversalOn, False);
    SET_ONE_RSRC(fakeBtn3, XmNtraversalOn, False);
    SET_ONE_RSRC(fakeBtn4, XmNtraversalOn, False);
    SET_ONE_RSRC(fakeBtn5, XmNtraversalOn, False);

    /*
    ** Create the Preferences menu
    */
    menuPane = XmCreatePulldownMenu(menuBar, "preferences", NULL, 0);
    XtVaCreateManagedWidget("prefB",
    	    xmCascadeButtonWidgetClass, menuBar,
    	    XmNsubMenuId, menuPane,
    	    XmNlabelString, st1=MKSTRING("Preferences"),
    	    XmNmnemonic, 'P', 0);
    XmStringFree(st1);

    button = XtVaCreateManagedWidget("autoIndent", xmToggleButtonWidgetClass,
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Auto Indent"),
    	    XmNmnemonic, 'A',
    	    XmNset, window->autoIndent, 0);
    XtAddCallback (button, XmNvalueChangedCallback, autoIndentCB, window);
    XmStringFree(st1);

    button = XtVaCreateManagedWidget("autoSave", xmToggleButtonWidgetClass,
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Periodic Backup"),
    	    XmNmnemonic, 'P',
    	    XmNset, window->autoSave, 0);
    XtAddCallback (button, XmNvalueChangedCallback, autoSaveCB, window);
    XmStringFree(st1);
    
#ifndef IBM_DESTROY_BUG
    button = XtVaCreateManagedWidget("font", xmPushButtonWidgetClass, 
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Text Font..."),
    	    XmNmnemonic, 'F', NULL);
    XtAddCallback(button, XmNactivateCallback, fontCB, window);
    XmStringFree(st1);

    button = XtVaCreateManagedWidget("wrapText", xmToggleButtonWidgetClass,
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Wrap Text"),
    	    XmNmnemonic, 'W',
    	    XmNset, window->wrap, 0);
    XtAddCallback (button, XmNvalueChangedCallback, wrapCB, window);
    XmStringFree(st1);
#endif /*IBM_DESTROY_BUG*/

    button = XtVaCreateManagedWidget("stats", xmToggleButtonWidgetClass,
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Statistics Line"),
    	    XmNmnemonic, 'S',
    	    XmNset, False, 0);
    XtAddCallback (button, XmNvalueChangedCallback, statsCB, window);
    XmStringFree(st1);
    
    button = XmCreateSeparator(menuPane, "sep1", NULL, 0);
    XtManageChild(button);
    
    /* Default Settings sub menu */
    subPane = XmCreatePulldownMenu(menuPane, "defaultSettings", NULL, 0);
    XtVaCreateManagedWidget("defaultSettingsB",
    	    xmCascadeButtonWidgetClass, menuPane,
    	    XmNsubMenuId, subPane,
    	    XmNlabelString, st1=MKSTRING("Default Settings"),
    	    XmNmnemonic, 'D', 0);
    XmStringFree(st1);

    button = XtVaCreateManagedWidget("autoIndent", xmToggleButtonWidgetClass,
    	    subPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Auto Indent"),
    	    XmNmnemonic, 'A',
    	    XmNset, GetPrefAutoIndent(), 0);
    XtAddCallback (button, XmNvalueChangedCallback, autoIndentDefCB, window);
    XmStringFree(st1);
    window->autoIndentDefItem = button;
    
    button = XtVaCreateManagedWidget("font", xmPushButtonWidgetClass, 
    	    subPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Text Font..."),
    	    XmNmnemonic, 'F', NULL);
    XtAddCallback(button, XmNactivateCallback, fontDefCB, window);
    XmStringFree(st1);

    button = XtVaCreateManagedWidget("autoSave", xmToggleButtonWidgetClass,
    	    subPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Periodic Backup"),
    	    XmNmnemonic, 'B',
    	    XmNset, GetPrefAutoSave(), 0);
    XtAddCallback (button, XmNvalueChangedCallback, autoSaveDefCB, window);
    XmStringFree(st1);
    window->autoSaveDefItem = button;

    button = XtVaCreateManagedWidget("wrapText", xmToggleButtonWidgetClass,
    	    subPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Wrap Text"),
    	    XmNmnemonic, 'W',
    	    XmNset, GetPrefWrap(), 0);
    XtAddCallback (button, XmNvalueChangedCallback, wrapDefCB, window);
    XmStringFree(st1);
    window->wrapTextDefItem = button;

    button = XtVaCreateManagedWidget("searchDlogs", xmToggleButtonWidgetClass,
    	    subPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Verbose Search"),
    	    XmNmnemonic, 'V',
    	    XmNset, GetPrefSearchDlogs(), 0);
    XtAddCallback (button, XmNvalueChangedCallback, searchDlogsDefCB, window);
    XmStringFree(st1);
    window->searchDlogsDefItem = button;

    /* Search Method sub menu (a radio btn only pane w/ XmNradioBehavior on) */
    subSubPane = XmCreatePulldownMenu(subPane, "searchType", NULL, 0);
    XtVaSetValues(subSubPane, XmNradioBehavior, True, 0); 
    XtVaCreateManagedWidget("searchTypeB",
    	    xmCascadeButtonWidgetClass, subPane,
    	    XmNsubMenuId, subSubPane,
    	    XmNlabelString, st1=MKSTRING("Default Search Style"),
    	    XmNmnemonic, 'D', 0);
    XmStringFree(st1);
    button = XtVaCreateManagedWidget("literal", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Literal"),
    	    XmNmnemonic, 'L',
    	    XmNindicatorType, XmONE_OF_MANY,
    	    XmNset, GetPrefSearch() == SEARCH_LITERAL, 0);
    XtAddCallback (button, XmNvalueChangedCallback, searchLiteralCB, window);
    XmStringFree(st1);
    window->searchLiteralDefItem = button;
    button = XtVaCreateManagedWidget("caseSense", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Case Sensitive"),
    	    XmNmnemonic, 'C',
    	    XmNindicatorType, XmONE_OF_MANY,
    	    XmNset, GetPrefSearch() == SEARCH_CASE_SENSE, 0);
    XtAddCallback (button, XmNvalueChangedCallback, searchCaseSenseCB, window);
    XmStringFree(st1);
    window->searchCaseSenseDefItem = button;
    button = XtVaCreateManagedWidget("regEx", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Regular Expression"),
    	    XmNmnemonic, 'R',
    	    XmNindicatorType, XmONE_OF_MANY,
    	    XmNset, GetPrefSearch() == SEARCH_REGEX, 0);
    XtAddCallback (button, XmNvalueChangedCallback, searchRegexCB, window);
    XmStringFree(st1);
    window->searchRegexDefItem = button;
    
    /* Initial Window Size sub menu (simulates radioBehavior) */
    subSubPane = XmCreatePulldownMenu(subPane, "windowSize", NULL, 0);
    XtVaCreateManagedWidget("windowSizeB",
    	    xmCascadeButtonWidgetClass, subPane,
    	    XmNsubMenuId, subSubPane,
    	    XmNlabelString, st1=MKSTRING("Initial Window Size"),
    	    XmNmnemonic, 'I', 0);
    XmStringFree(st1);
    button = XtVaCreateManagedWidget("24X80", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("24 x 80"),
    	    XmNmnemonic, '2',
    	    XmNindicatorType, XmONE_OF_MANY, 0);
    XtAddCallback (button, XmNvalueChangedCallback, size24x80CB, window);
    XmStringFree(st1);
    window->size24x80DefItem = button;
    button = XtVaCreateManagedWidget("40x80", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("40 x 80"),
    	    XmNmnemonic, '4',
    	    XmNindicatorType, XmONE_OF_MANY, 0);
    XtAddCallback (button, XmNvalueChangedCallback, size40x80CB, window);
    XmStringFree(st1);
    window->size40x80DefItem = button;
    button = XtVaCreateManagedWidget("60x80", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("60 x 80"),
    	    XmNmnemonic, '6',
    	    XmNindicatorType, XmONE_OF_MANY, 0);
    XtAddCallback (button, XmNvalueChangedCallback, size60x80CB, window);
    XmStringFree(st1);
    window->size60x80DefItem = button;
    button = XtVaCreateManagedWidget("80x80", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("80 x 80"),
    	    XmNmnemonic, '8',
    	    XmNindicatorType, XmONE_OF_MANY, 0);
    XtAddCallback (button, XmNvalueChangedCallback, size80x80CB, window);
    XmStringFree(st1);
    window->size80x80DefItem = button;
    button = XtVaCreateManagedWidget("Custom", xmToggleButtonWidgetClass,
    	    subSubPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Custom..."),
    	    XmNmnemonic, 'C',
    	    XmNindicatorType, XmONE_OF_MANY, 0);
    XtAddCallback (button, XmNvalueChangedCallback, sizeCustomCB, window);
    XmStringFree(st1);
    window->sizeCustomDefItem = button;
    updateWindowSizeMenu(window);
    
    button = XtVaCreateManagedWidget("savePrefs", xmPushButtonWidgetClass, 
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Save Defaults"),
    	    XmNmnemonic, 'v', NULL);
    XtAddCallback(button, XmNactivateCallback, savePrefCB, window);
    XmStringFree(st1);

    /*
    ** Create the Windows menu
    */
    menuPane = XmCreatePulldownMenu(menuBar, "windows", NULL, 0);
    button = XtVaCreateManagedWidget("windowB", xmCascadeButtonWidgetClass,
    	    menuBar,
    	    XmNsubMenuId, menuPane,
    	    XmNlabelString, st1=MKSTRING("Windows"),
    	    XmNmnemonic, 'W', 0);
    XtAddCallback(button, XmNcascadingCallback, windowMenuCB, window);
    XmStringFree(st1);
    window->windowMenuPane = menuPane;
    
    button = XtVaCreateManagedWidget("splitWindow", xmPushButtonWidgetClass, 
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Split Window"),
    	    XmNacceleratorText, st2=XmStringCreateSimple("Ctrl+2"),
    	    XmNaccelerator, "Ctrl<Key>2",
    	    XmNmnemonic, 'S',
    	    XmNuserData, PERMANENT, 0);
    XtAddCallback(button, XmNactivateCallback, splitWindowCB, window);
    XmStringFree(st1);
    XmStringFree(st2);
    window->splitWindowItem = button;
    
    button = XtVaCreateManagedWidget("closePane", xmPushButtonWidgetClass, 
    	    menuPane, 
    	    XmNlabelString, st1=XmStringCreateSimple("Close Pane"),
    	    XmNacceleratorText, st2=XmStringCreateSimple("Ctrl+1"),
    	    XmNaccelerator, "Ctrl<Key>1",
    	    XmNsensitive, False,
    	    XmNmnemonic, 'C', 0);
    XtAddCallback(button, XmNactivateCallback, closePaneCB, window);
    XmStringFree(st1);
    XmStringFree(st2);
    window->closePaneItem = button;
    
    button = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, 
    	    menuPane, XmNuserData, PERMANENT, 0);
    
    /* 
    ** Create "Help" pull down menu.
    */
    ac = 0;
    menuPane = XmCreatePulldownMenu (menuBar, "help", al, ac);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Getting Started")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'G'); ac++;
    button = XmCreatePushButton (menuPane, "start", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpStartCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Finding & Replacing Text"));
    ac++;
    XtSetArg(al[ac], XmNmnemonic, 'F'); ac++;
    button = XmCreatePushButton (menuPane, "search", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpSearchCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Selecting Text")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'S'); ac++;
    button = XmCreatePushButton (menuPane, "select", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpSelectCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Cut & Paste")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'C'); ac++;
    button = XmCreatePushButton (menuPane, "clipboard", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpClipCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Features for Programming"));
    ac++;
    XtSetArg(al[ac], XmNmnemonic, 'g'); ac++;
    button = XmCreatePushButton (menuPane, "programming", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpProgCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString,
    	st1=MKSTRING("Navigation from the Keyboard")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'N'); ac++;
    button = XmCreatePushButton (menuPane, "navigation", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpNavCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString,
    	st1=MKSTRING("Crash Recovery")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'R'); ac++;
    button = XmCreatePushButton (menuPane, "recovery", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpRecoveryCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString,
    	st1=MKSTRING("Preferences")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'P'); ac++;
    button = XmCreatePushButton (menuPane, "preferences", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpPrefCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString,
    	st1=MKSTRING("NEdit Command Line")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'm'); ac++;
    button = XmCreatePushButton (menuPane, "cmdline", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpCmdLineCB, window);
    XtManageChild (button);
    XmStringFree(st1);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Customizing NEdit")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'u'); ac++;
    button = XmCreatePushButton (menuPane, "customization", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpCustCB, window);
    XtManageChild (button);
    XmStringFree(st1);

    ac = 0;
    button = XmCreateSeparator(menuPane, "separator", al, ac);
    XtManageChild (button);
 
    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Version")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'V'); ac++;
    button = XmCreatePushButton (menuPane, "version", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpVerCB, window);
    XtManageChild (button);
    XmStringFree(st1);

    ac = 0;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Problems/Bugs")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'B'); ac++;
    button = XmCreatePushButton (menuPane, "bugs", al, ac);
    XtAddCallback (button, XmNactivateCallback, helpBugsCB, window);
    XtManageChild (button);
    XmStringFree(st1);

    ac = 0;
    XtSetArg (al[ac], XmNsubMenuId, menuPane);  ac++;
    XtSetArg(al[ac], XmNlabelString, st1=MKSTRING("Help")); ac++;
    XtSetArg(al[ac], XmNmnemonic, 'H'); ac++;
    cascade= XmCreateCascadeButton (menuBar, "helpB", al, ac);
    XtManageChild (cascade);
    XmStringFree(st1);
    SET_ONE_RSRC(menuBar, XmNmenuHelpWidget, cascade);

    return (menuBar);
}

static void newCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    EditNewFile();
    checkCloseDim();
}

static void openCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    char fullname[MAXPATHLEN], filename[MAXPATHLEN], pathname[MAXPATHLEN];
    int response;
    
    response = GetExistingFilename(window->shell, "File to Edit:", fullname);
    if (response == GFN_OK) {
    	ParseFilename(fullname, filename, pathname);
    	EditExistingFile(window, filename, pathname, False);
    }
    checkCloseDim();
}

static void closeCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    CloseFileAndWindow(window);
    checkCloseDim();
}

static void saveCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    SaveWindow(window);
}

static void saveAsCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    SaveWindowAs(window);
}

static void revertCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    RevertToSaved(window);
}

static void loadTagsCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    char filename[MAXPATHLEN];
    int response;
    
    while(True) {
	response = GetExistingFilename(window->shell, "ctags file:", filename);
	if (response == GFN_OK)
    	    if (!LoadTagsFile(filename))
    		DialogF(DF_WARN, window->shell, 1,
    	    		"Error reading ctags file,\ntags not loaded", "OK");
    	    else
    	    	break;
    	else
    	    break;
    }
}

static void printCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    PrintWindow(window, False);
}

static void printSelCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    PrintWindow(window, True);
}

static void exitCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    /* Close all files and exit when the last one is closed */
    if (CloseAllFilesAndWindows())
    	exit(0);
}

static void undoCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    Undo(window);
}

static void cutCB(Widget w, WindowInfo *window, XmAnyCallbackStruct *callData) 
{
    CutToClipboard(window, callData->event->xbutton.time);
}

static void copyCB(Widget w, WindowInfo *window,XmAnyCallbackStruct *callData) 
{
    CopyToClipboard(window, callData->event->xbutton.time);
}

static void pasteCB(Widget w,WindowInfo *window,XmAnyCallbackStruct *callData) 
{
    PasteFromClipboard(window, callData->event->xbutton.time);
}

static void clearCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    DeletePrimarySelection(window->textArea);
}

static void shiftLeftCB(Widget w, WindowInfo *window, caddr_t callData) 
{
    ShiftSelection(window, SHIFT_LEFT, CurrentTime);
}

static void shiftRightCB (Widget w, WindowInfo *window, caddr_t callData) 
{
    ShiftSelection(window, SHIFT_RIGHT, CurrentTime);
}

static void findCB(Widget w, WindowInfo *window,XmAnyCallbackStruct *callData) 
{
    DoFindDlog(window, callData->event->xbutton.state&ShiftMask);
}

static void findSameCB(Widget w, WindowInfo *window,
			XmAnyCallbackStruct *callData) 
{
    SearchAndSelect(window, callData->event->xbutton.state&ShiftMask,
    			 callData->event->xbutton.time);
}

static void findSelCB(Widget w, WindowInfo *window,
		       XmAnyCallbackStruct *callData) 
{
    SearchForSelected(window, callData->event->xbutton.state&ShiftMask,
    			   callData->event->xbutton.time);
}

static void replaceCB(Widget w, WindowInfo *window,
		       XmAnyCallbackStruct *callData) 
{
   DoReplaceDlog(window, callData->event->xbutton.state&ShiftMask);
}

static void replaceSameCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData) 
{
    SearchAndReplace(window, callData->event->xbutton.state&ShiftMask);
}

static void gotoCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData) 
{
    GotoLineNumber(window, callData->event->xbutton.time);
}

static void gotoSelectedCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData) 
{
    GotoSelectedLineNumber(window, callData->event->xbutton.time);
}

static void findMatchingCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData) 
{
    MatchSelectedCharacter(window, CurrentTime);
}

static void findDefCB(Widget w, WindowInfo *window,
			   XmAnyCallbackStruct *callData) 
{
    FindDefinition(window, CurrentTime);
}

static void autoIndentCB(Widget w, WindowInfo *window, caddr_t callData)
{
    SetAutoIndent(window, XmToggleButtonGetState(w));
}

static void autoSaveCB(Widget w, WindowInfo *window, caddr_t callData)
{
    window->autoSave = XmToggleButtonGetState(w);
}

static void fontCB(Widget w, WindowInfo *window, caddr_t callData)
{
    char *fontName;
    
    fontName = FontSel(window->shell, PREF_FIXED, window->fontName);
    if (fontName == NULL)
    	return;
    SetFont(window, fontName);
    XtFree(fontName);
}

static void wrapCB(Widget w, WindowInfo *window, caddr_t callData)
{
    SetWrap(window, XmToggleButtonGetState(w));
}

static void statsCB(Widget w, WindowInfo *window, caddr_t callData)
{
    ShowStatsLine(window, XmToggleButtonGetState(w));
}

static void autoIndentDefCB(Widget w, WindowInfo *window, caddr_t callData)
{
    WindowInfo *win;
    int state = XmToggleButtonGetState(w);

    /* Set the preference and make the other windows' menus agree */
    SetPrefAutoIndent(state);
    for (win=WindowList; win!=NULL; win=win->next)
    	XmToggleButtonSetState(win->autoIndentDefItem, state, False);
}

static void autoSaveDefCB(Widget w, WindowInfo *window, caddr_t callData)
{
    WindowInfo *win;
    int state = XmToggleButtonGetState(w);

    /* Set the preference and make the other windows' menus agree */
    SetPrefAutoSave(state);
    for (win=WindowList; win!=NULL; win=win->next)
    	XmToggleButtonSetState(win->autoSaveDefItem, state, False);
}

static void fontDefCB(Widget w, WindowInfo *window, caddr_t callData)
{
    char *fontName;
    
    fontName = FontSel(window->shell, PREF_FIXED, GetPrefFontName());
    if (fontName == NULL)
    	return;
    SetPrefFont(fontName);
    XtFree(fontName);
}

static void wrapDefCB(Widget w, WindowInfo *window, caddr_t callData)
{
    WindowInfo *win;
    int state = XmToggleButtonGetState(w);

    /* Set the preference and make the other windows' menus agree */
    SetPrefWrap(state);
    for (win=WindowList; win!=NULL; win=win->next)
    	XmToggleButtonSetState(win->wrapTextDefItem, state, False);
}

static void searchDlogsDefCB(Widget w, WindowInfo *window, caddr_t callData)
{
    WindowInfo *win;
    int state = XmToggleButtonGetState(w);

    /* Set the preference and make the other windows' menus agree */
    SetPrefSearchDlogs(state);
    for (win=WindowList; win!=NULL; win=win->next)
    	XmToggleButtonSetState(win->searchDlogsDefItem, state, False);
}

static void searchLiteralCB(Widget w, WindowInfo *window, caddr_t callData)
{
    WindowInfo *win;

    /* Set the preference and make the other windows' menus agree */
    if (XmToggleButtonGetState(w)) {
    	SetPrefSearch(SEARCH_LITERAL);
    	for (win=WindowList; win!=NULL; win=win->next){
    	    XmToggleButtonSetState(win->searchLiteralDefItem, True, False);
    	    XmToggleButtonSetState(win->searchCaseSenseDefItem, False, False);
    	    XmToggleButtonSetState(win->searchRegexDefItem, False, False);
    	}
    }
}

static void searchCaseSenseCB(Widget w, WindowInfo *window, caddr_t callData)
{
    WindowInfo *win;

    /* Set the preference and make the other windows' menus agree */
    if (XmToggleButtonGetState(w)) {
    	SetPrefSearch(SEARCH_CASE_SENSE);
    	for (win=WindowList; win!=NULL; win=win->next) {
    	    XmToggleButtonSetState(win->searchLiteralDefItem, False, False);
    	    XmToggleButtonSetState(win->searchCaseSenseDefItem, True, False);
    	    XmToggleButtonSetState(win->searchRegexDefItem, False, False);
    	}
    }
}

static void searchRegexCB(Widget w, WindowInfo *window, caddr_t callData)
{
   WindowInfo *win;

    /* Set the preference and make the other windows' menus agree */
    if (XmToggleButtonGetState(w)) {
    	SetPrefSearch(SEARCH_REGEX);
    	for (win=WindowList; win!=NULL; win=win->next){
    	    XmToggleButtonSetState(win->searchLiteralDefItem, False, False);
    	    XmToggleButtonSetState(win->searchCaseSenseDefItem, False, False);
    	    XmToggleButtonSetState(win->searchRegexDefItem, True, False);
    	}
    }
}

static void size24x80CB(Widget w, WindowInfo *window, caddr_t callData)
{
    setWindowSizeDefault(24, 80);
}

static void size40x80CB(Widget w, WindowInfo *window, caddr_t callData)
{
    setWindowSizeDefault(40, 80);
}

static void size60x80CB(Widget w, WindowInfo *window, caddr_t callData)
{
    setWindowSizeDefault(60, 80);
}

static void size80x80CB(Widget w, WindowInfo *window, caddr_t callData)
{
    setWindowSizeDefault(80, 80);
}

static void sizeCustomCB(Widget w, WindowInfo *window, caddr_t callData)
{
    RowColumnPrefDialog(window->shell);
    updateWindowSizeMenus();
}

static void savePrefCB(Widget w, WindowInfo *window, caddr_t callData)
{
    SaveNEditPrefs(window->shell);
}

static void splitWindowCB(Widget w, WindowInfo *window, caddr_t callData)
{
    SplitWindow(window);
    XtSetSensitive(window->splitWindowItem, window->nPanes < MAX_PANES);
    XtSetSensitive(window->closePaneItem, window->nPanes > 0);
}

static void closePaneCB(Widget w, WindowInfo *window, caddr_t callData)
{
    ClosePane(window);
    XtSetSensitive(window->splitWindowItem, window->nPanes < MAX_PANES);
    XtSetSensitive(window->closePaneItem, window->nPanes > 0);
}

static void helpStartCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_START);
}

static void helpSearchCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_SEARCH);
}

static void helpSelectCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_SELECT);
}

static void helpClipCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_CLIPBOARD);
}

static void helpProgCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_PROGRAMMER);
}

static void helpNavCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_KEYBOARD);
}

static void helpRecoveryCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_RECOVERY);
}

static void helpPrefCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_PREFERENCES);
}

static void helpCmdLineCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_COMMAND_LINE);
}

static void helpCustCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_CUSTOMIZE);
}

static void helpVerCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_VERSION);
}

static void helpBugsCB(Widget w, WindowInfo *window, caddr_t callData)
{
    Help(window, HELP_BUGS);
}

static void windowMenuCB(Widget w, WindowInfo *window, caddr_t callData)
{
    if (!window->windowMenuValid) {
    	updateWindowMenu(window);
    	window->windowMenuValid = True;
    }
}

/*
** Make sure the close menu item is dimmed appropriately for the current
** set of windows.  It should be dim only for the last Untitled, unmodified,
** editor window, and sensitive otherwise.
*/
static void checkCloseDim(void)
{
    WindowInfo *window;
    
    if (WindowList == NULL)
    	return;
    if (WindowList->next==NULL &&
    	    !WindowList->filenameSet && !WindowList->fileChanged) {
    	XtSetSensitive(WindowList->closeItem, FALSE);
    	return;
    }
    
    for (window=WindowList; window!=NULL; window=window->next)
    	XtSetSensitive(window->closeItem, True);
}

/*
** Invalidate the Window menus of all NEdit windows to but don't change
** the menus until they're needed (Originally, this was "UpdateWindowMenus",
** but creating and destroying the menus for every window every time a
** new window was created or something changed, made things move very
** slowly with more than 10 or so windows).
*/
void InvalidateWindowMenus()
{
    WindowInfo *w;

    for (w=WindowList; w!=NULL; w=w->next)
    	w->windowMenuValid = False;
}

/*
** Update the Window menu of a single window to reflect the current state of
** all NEdit windows as determined by the global WindowList.
*/
static void updateWindowMenu(WindowInfo *window)
{
    WindowInfo *w;
    char *title;
    Widget btn;
    WidgetList items;
    int nItems, n, userData;
    XmString st1;
    
    /* While it is not possible on some systems (ibm at least) to substitute
       a new menu pane, it is possible to substitute menu items, as long as
       at least one remains in the menu at all times. This routine assumes
       that the menu contains permanent items marked with the value PERMANENT
       in the userData resource, and adds and removes items which it marks
       with the value WINDOW_NAME */
    
    /* Remove all of the existing window names from the menu */
    XtVaGetValues(window->windowMenuPane, XmNchildren, &items,
    	    XmNnumChildren, &nItems,0);
    for (n=0; n<nItems; n++) {
    	XtVaGetValues(items[n], XmNuserData, &userData, 0);
    	if (userData == WINDOW_NAME) {
    	    /* unmanaging before destroying stops parent from displaying */
    	    XtUnmanageChild(items[n]);
    	    XtDestroyWidget(items[n]);
    	}
    }
    
    /* Add current window titles from WindowList to the menu */
    for (w=WindowList; w!=NULL; w=w->next) {
    	XtVaGetValues(w->shell, XmNtitle, &title, 0);
    	btn = XtVaCreateManagedWidget("win", xmPushButtonWidgetClass,
    		window->windowMenuPane, 
    		XmNlabelString, st1=XmStringCreateSimple(title),
    		XmNuserData, WINDOW_NAME, NULL);
	XtAddCallback(btn, XmNactivateCallback, raiseCB, w);
    	XmStringFree(st1);
    }
}

static void setWindowSizeDefault(int rows, int cols)
{
    SetPrefRows(rows);
    SetPrefCols(cols);
    updateWindowSizeMenus();
}

static void updateWindowSizeMenus()
{
    WindowInfo *win;
    
    for (win=WindowList; win!=NULL; win=win->next)
    	updateWindowSizeMenu(win);
}

static void updateWindowSizeMenu(WindowInfo *win)
{
    int rows = GetPrefRows(), cols = GetPrefCols();
    char title[50];
    XmString st1;
    
    XmToggleButtonSetState(win->size24x80DefItem, rows==24&&cols==80,False);
    XmToggleButtonSetState(win->size40x80DefItem, rows==40&&cols==80,False);
    XmToggleButtonSetState(win->size60x80DefItem, rows==60&&cols==80,False);
    XmToggleButtonSetState(win->size80x80DefItem, rows==80&&cols==80,False);
    if ((rows!=24 && rows!=40 && rows!=60 && rows!=80) || cols!=80) {
    	XmToggleButtonSetState(win->sizeCustomDefItem, True, False);
    	sprintf(title, "Custom... (%d x %d)", rows, cols);
    	XtVaSetValues(win->sizeCustomDefItem,
    	    	XmNlabelString, st1=XmStringCreateSimple(title), 0);
    	XmStringFree(st1);
    } else {
    	XmToggleButtonSetState(win->sizeCustomDefItem, False, False);
    	XtVaSetValues(win->sizeCustomDefItem,
    	    	XmNlabelString, st1=XmStringCreateSimple("Custom..."), 0);
    	XmStringFree(st1);
    }
}

static void raiseCB(Widget w, WindowInfo *window, caddr_t callData)
{
    /* XMapRaised as opposed to XRaiseWindow will uniconify as well as raise */
    XMapRaised(TheDisplay, XtWindow(window->shell));
    XmProcessTraversal(window->lastFocus, XmTRAVERSE_CURRENT);
}
