 /* written by:    Nigel R. Arnot,6    dept. Physics, Kings College, London WC2R 2LS, U.K.C    NRA@UK.AC.KCL.PH.IPG     NRA%UK.AC.KCL.PH.IPG@nsfnet-relay.ac.uk  */$ /* Copyright (C) 1993 Nigel R. Arnot  G This program is free software; you can redistribute it and/or modify it E under the terms of the GNU General Public License as published by the  Free Software Foundation.   ? This program is distributed in the hope that it will be useful, ? but WITHOUT ANY WARRANTY; without even the implied warranty of  @ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU( General Public License for more details.  < This distribution should have come with a copy of the GPL inE file COPYING.TXT. If not, write to the Free Software Foundation inc., ' 675 Mass Ave, Cambridge, MA 02139, USA.    */   /*H * This program will walk the tree of DECW$BOOKSHELF files from CDDS CDs,G * presenting the shelves on the screen much as the bookreader does. The H * user can select or de-select books. On exit, the progra, writes a listF * of selected books, complete with titles so manual editing thereafter * is easier. *  * Keyboard functions:  * * * Cursor up/down  --- move selection point; * Enter or CR     --- toggle selection (book); down (shelf) M * Control/Z       --- up shelf; up from top shelf is exit (write new OUTFILE) < * KP.             --- select this shelf (whole tree) or file> * KP0             --- deselect this shelf (whole tree) or file * A * These seemed like a good idea at the time but I never use them! I * gold A          --- recursively process whole screen: next keystroke is 2 *                       + (select) or - (deselect)O * gold B          --- process all books on screen, no recursion (+|- next as A)  *  * B * initial input is SOURCE:LIBRARY.DECW$BOOKSHELF (always on CD #1) * H * output is file BOOKLIST.DAT in current directory (#defined as OUTFILE) *  */  K /* note to U**X-trained C programmers: the CHECK macro is mandatory on VMS. N  *  The GOBBLE macro is for debugging, solves problems with comment delimiters  *  not being nestable   */   #include stdio   #include <smg$routines>  #include <smgdef>  #include <smgmsg>    #include "symdefs.h" #include "bookdata.h"   C #define CHECK(x) if ( ( (istat = x) & 1) != 1) LIB$SIGNAL( istat);    #define CRASH(x) LIB$SIGNAL( 4); #define GOBBLE(x) /**/    #define OUTFILE "[]BOOKLIST.DAT"   #define OP_SELECT 1  #define OP_DESEL  2     struct stringdesc { long int l; "                     char *   s; };   void error( char *);9 void analyze_line( char *, struct bookdata **, char ** ); 7 void displayline( int *, int, struct bookdata *, int );  void dump_symbols();   /* file scope variables */  7 static struct symtable * symtab;     /* symbol table */ B static int pb, kb;                   /* pasteboard and keyboard */& static char * sourcedir  = "SOURCE:" ;. static char * sourcex    = ".DECW$BOOKSHELF" ;  	 main () {      unsigned long int istat;   char filename[80];   filename[0] = 0;  !   symtab = init_sym_table( 3000);   %   CHECK( smg$create_pasteboard( &pb)) +   CHECK( smg$create_virtual_keyboard( &kb))       strcat( filename, sourcedir);    strcat( filename,"LIBRARY");     strcat( filename, sourcex);      display(filename, 2); J   smg$delete_pasteboard( &pb);  /* clears screen, makes ascii output OK */     dump_symbols();    };  L /* create virtual display and put the data for the given bookshelf file intoJ    it, then allow user to move up and down selecting things. If a shelf is    selected, it recurses */  & int display( char * file, int level) {   unsigned long int istat;   int disp;    struct stringdesc sdesc;  *   int icol, irow, nrow, i, iscrol, n, op;    short int key, key2;
   FILE fd;  J /* ROWS is maximum handleable length of a bookshelf. COLS is width of VDU.1    BUFLEN must be at least 1 bigger than COLS */     #define ROWS 70  #define COLS 132 #define BUFLEN 133 #define VDUROW 24      char buf[BUFLEN];    struct bookdata * book[ROWS];    char            * name[ROWS];   O /* MAXREC is maximum record in a shelf file, MAXFILE maxi bookreader filename*/  #define MAXREC 200 #define MAXFILE 40     char rec[MAXREC];    char bookfile[MAXFILE];      int selectrow;   char gold, selecting;      sdesc.s = buf;  O   for (i = 0; i < ROWS; ++i) { book[i] = 0; name[i] = 0; }; /* null pointers */   4 /* open the file: error and return if can't do it */  '   if ((fd = fopen( file, "r") ) == 0) { 2     sprintf( buf, "Unable to open file %s", file);     error( buf);     return;    };  8 /* file is OK, now create virtual displlay for output */  :   CHECK( smg$create_virtual_display( &ROWS, &COLS, &disp, 0              &(SMG$M_BORDER+SMG$M_TRUNC_ICON) ))=   CHECK( smg$create_viewport( &disp, &1, &1, &VDUROW, &COLS))    { int pasterow = level + 1; D   CHECK( smg$paste_virtual_display( &disp, &pb, &pasterow, &level))    };   2 /*  read the shelf file, analyze and display it */  J   for( nrow = 1; nrow <= ROWS && fgets( buf, BUFLEN, fd) != 0 ; ++nrow ) {  1    analyze_line( buf, &book[nrow], &name[nrow] ); -    displayline( &disp,  nrow, book[nrow], 0);    };  N   if( nrow == ROWS) error("ROWS too small, list truncated, please recompile");  J   /* irow is the current row in range 1..nrow. Highlight the first line */   irow = 1; iscrol = 0; >   CHECK( smg$change_rendition( &disp, &irow, &1, &irow, &COLS,1                                &SMG$M_REVERSE ));   8   /* Now use the cursor to move around in this window */   do {   ,     istat = smg$read_keystroke( &kb, &key );C     if( (istat & 1) == 0 && istat != SMG$_EOF ) LIB$SIGNAL( istat); %     smg$begin_display_update( &disp);        switch ( key) {        default:       BADKEY: 
 	gold = 0; 	smg$ring_bell( &disp); break;       case SMG$K_TRM_UP:' 	if( irow == 1) smg$ring_bell( &disp);   	else { > 	   CHECK( smg$change_rendition( &disp, &irow, &1, &1, &COLS, A                                &SMG$M_REVERSE, &SMG$M_REVERSE ));  	   irow-- ;> 	   CHECK( smg$change_rendition( &disp, &irow, &1, &1, &COLS, 1                                &SMG$M_REVERSE )); + 	   if( irow - iscrol < 2 && iscrol != 0) {  	      --iscrol;= 	      CHECK( smg$scroll_viewport( &disp, &SMG$M_DOWN, &1 ));  	   }; 	};  	break;        case SMG$K_TRM_DOWN:     SCROLL_DOWN:, 	if( irow == nrow-1) smg$ring_bell( &disp);  	else { > 	   CHECK( smg$change_rendition( &disp, &irow, &1, &1, &COLS, A                                &SMG$M_REVERSE, &SMG$M_REVERSE ));  	   irow++ ;> 	   CHECK( smg$change_rendition( &disp, &irow, &1, &1, &COLS, 1                                &SMG$M_REVERSE )); ? 	   if( irow - iscrol > VDUROW - 2 - level && irow != nrow-1) {  	      ++iscrol;; 	      CHECK( smg$scroll_viewport( &disp, &SMG$M_UP, &1 ));  	   }; 	};  	break;        case SMG$K_TRM_CTRLZ: 7     CONTROL_Z:		    /* delete the display and return */ - 	CHECK( smg$delete_virtual_display( &disp));           fclose(fd);  	return( irow);           case SMG$K_TRM_ENTER:      case SMG$K_TRM_CR:  O     /* select this item. For a shelf, this opens and displays the shelf file */   '         if( book[irow] -> shelf == 1) {               	    char filename[80];              filename[0] = 0;  ? 	    strcat(filename, sourcedir); strcat(filename, name[irow]); &             strcat(filename, sourcex);  # 	    display( filename, level+1 );  	         }  	else { 6 	    book[irow] -> selected = ~book[irow] -> selected;B             displayline( &disp, irow, book[irow], SMG$M_REVERSE );* 	    if( irow != nrow-1) goto SCROLL_DOWN;
         }; 	break;   L     /* also select, but doesn't open shelf. Instead, will recursively select!        or deselect a whole range       */     case SMG$K_TRM_PERIOD:   	if( book[irow]->shelf == 1) {> 	    n = do_book( book[irow], name[irow], OP_SELECT, level+1);             goto SHOW_N; 	} 	else {   	    book[irow] -> selected = 1;B             displayline( &disp, irow, book[irow], SMG$M_REVERSE );* 	    if( irow != nrow-1) goto SCROLL_DOWN;
         }; 	break;        case SMG$K_TRM_KP0:    	if( book[irow]->shelf == 1) {= 	    n = do_book( book[irow], name[irow], OP_DESEL, level+1);              goto SHOW_N; 	} 	else {   	    book[irow] -> selected = 0;B             displayline( &disp, irow, book[irow], SMG$M_REVERSE );* 	    if( irow != nrow-1) goto SCROLL_DOWN;
         }; 	break;     L     case SMG$K_TRM_PF1:   /* 'gold' keys to unlock dangerous commands A,B */     case SMG$K_TRM_F1:  0         istat = smg$read_keystroke( &kb, &key );G         if( (istat & 1) == 0 && istat != SMG$_EOF ) LIB$SIGNAL( istat); >         if ( key >= 'a' && key <= 'z') key = key - 'a' + 'A' ;3         if( key != 'A' && key != 'B') goto BADKEY ;   0         istat = smg$read_keystroke( &kb, &key2);G         if( (istat & 1) == 0 && istat != SMG$_EOF ) LIB$SIGNAL( istat); F 	if( key2 != '+' && key2 != '-' && key2 != SMG$K_TRM_CR ) goto BADKEY;. 	op = ( key2 != '-' ) ? OP_SELECT : OP_DESEL ;   	n = 0;            if( key == 'A') { )             for ( i = 1; i < nrow; ++i) { : 	        n = n + do_book( book[i], name[i], op, level+1 );4                 displayline( &disp, i, book[i], 0 ); 	    };  	};          if( key == 'B') { )             for ( i = 1; i < nrow; ++i) { # 	        if (book[i]->shelf == 0) { 5 		    book[i]->selected = (op == OP_SELECT) ? 1 : 0 ; 
 		    ++n; 	        }; 9 	        displayline( &disp, i, book[i], SMG$M_REVERSE );  	    };  	};      SHOW_N: (         smg$end_display_update( &disp); 3 	sprintf(buf, "%d books processed", n); error(buf); =         if ( key == 'A') goto CONTROL_Z; /* pop up a level */  	break;     %     }; /* end switch on keystrokes */   $     smg$end_display_update( &disp);   /   } while ( 1 == 1);  /* end of forever loop */  };     void error( char * message) {      int len, nstart, disp, i;    struct stringdesc sdesc;   unsigned long int istat;     len = strlen( message) + 2; K   if (len < 25) len=25;        /* hit any key to continue*/ /* space for */    nstart =  (80-len-2) /2;6   CHECK( smg$create_virtual_display( &5, &len, &disp, 0              &(SMG$M_BORDER+SMG$M_TRUNC_ICON) ))>   CHECK( smg$paste_virtual_display( &disp, &pb, &10, &nstart))      smg$ring_bell( &disp);    /   sdesc.l = strlen(message); sdesc.s = message; B   CHECK( smg$put_chars( &disp, &sdesc, &2,&2, 0, &SMG$M_REVERSE));  &   sdesc.s = "Hit any key to continue";   sdesc.l = strlen( sdesc.s);    i = ( 3 + len - sdesc.l) / 2; 1   CHECK( smg$put_chars( &disp, &sdesc, &4, &i ));   (   istat = smg$read_keystroke( &kb, &i );.   CHECK( smg$delete_virtual_display( &disp));    };  P void displayline( int * disp, int irow, struct bookdata * book, int rendition) {      struct stringdesc sdesc;     char line[12]; 
    char flag; 	    int i;     unsigned long int istat;       sdesc.s = line;      flag = 0;       *    if ( book -> size > 99999 ) flag = '?';*    if ( book -> shelf == 1   ) flag = ' ';    if ( flag != 0) {.       for( i = 0 ; i < 5; ++i) line[i] = flag;    }    else +       sprintf( line, "%5d", book -> size );   	    i = 4;     line[++i] = ' ' ;3    line[++i] = (book -> shelf == 1)    ? 'S' : ' '; 3    line[++i] = (book -> selected == 1) ? '*' : ' ';     line[++i] = ' ';     sdesc.l = i;      C    CHECK( smg$put_chars( disp, &sdesc, &irow, &1, 0, &rendition ));     ++i; =    sdesc.s = &(book -> title[0]); sdesc.l = strlen( sdesc.s); C    CHECK( smg$put_chars( disp, &sdesc, &irow, &i, 0, &rendition ));   
    return; };   M void analyze_line( char * buf, struct bookdata ** bookrtn, char ** namertn) {   L /* line contains components separated by backslashes. The first substring isF    BOOK or SHELF. The second is a filename. The third is the title. WeF    store the information in a symbol table, and return useful pointers */"     int noff, nsiz, toff, tsiz, i;     int bookbytes;     struct symbol * sym;     struct bookdata * book;   
     noff = 0; &     while ( buf[noff] != '\\') ++noff;     ++noff;      toff=noff;%     while( buf[toff] != '\\') ++toff;      nsiz = toff-noff; 9     buf[toff] = 0;       /* null-terminate name string */      ++toff; "     tsiz = strlen( &buf[toff] );  E     tsiz--; buf[ toff+tsiz ] = 0;    /* don't include the newline! */   ) /* uppercase name string, just in case */      i = noff;      while( buf[i] != 0) { P        if ( buf[i] >= 'a' && buf[i] <= 'z') buf[i] = ( buf[i] - 'a') + 'A'; ++i;     };  F /* now need to see if a corresponding symbol exists. If so, return its'    pointers. If not, create from new */   *    sym = find_symbol( symtab, &buf[noff]);    if( sym == 0) {  6       bookbytes = sizeof( struct bookdata) + tsiz + 1;3       book = (struct bookdata *) malloc(bookbytes); *       if( book == 0) error("malloc fail");  A       book -> shelf = ( buf[0] == 'S' || buf[0] == 's' ) ? 1 : 0;        book -> selected = 0;        book -> size = 0; 3       strcpy( &( book -> title[0]),  &buf[toff]  );        7       set_symbol( symtab, &buf[noff], book, bookbytes); -       sym = find_symbol( symtab, &buf[noff]);     };      M /* this isn't particularly useful at present: chances are high the file isn't 9    on the CDROM that you've got mounted! GOBBLE() it out   */ GOBBLE( 1    if( book -> shelf == 0 && book -> size == 0) {           char fnam[80]; int fsiz;G         fnam[0] = 0; strcat(fnam, sourcedir); strcat(fnam, &buf[noff]); <                      strcat(fnam, ".DECW$BOOK");             	fsiz = filesize( fnam ); 5         book -> size = (fsiz+511) >> 9;  /* blocks */     };  )   !    *namertn = &( sym -> name[0]); B    *bookrtn = ( struct bookdata *) &( sym -> name[ sym -> doff] );
    return; };   void dump_symbols() {       struct symbol * sym; 	    int i;     struct bookdata * book;    char * nam;    FILE fd;       fd = fopen( OUTFILE, "w" );      sym = symtab -> flink;   )    for( i = 1; i <= symtab->nsym; ++i) {          nam = &sym->name[0]; <        book = (struct bookdata  *) (&sym->name[sym->doff] );  9        if( book -> shelf == 0 && book -> selected == 1) { :           fprintf( fd, "%s\\%s\n", nam, &book->title[0] );	        };         sym = sym->flink;    };     fclose(fd); };  H int do_book( struct bookdata * book, char * name, int op, int level ) {   O /* non-interactive select/deselect operator for traversing the tree recursively N    to locate all the book files if shelf files passed. Returns number of books
    processed.  */    if( book -> shelf == 1) {    	int bookcount = 0; 	char buf[MAXREC];	 	FILE fd;          char file[80];          	file[0]=0; !         strcat( file, sourcedir);          strcat( file, name);         strcat( file, sourcex);   <         /* open the file: error and return if can't do it */  (   	if ((fd = fopen( file, "r") ) == 0) {6     	   sprintf( buf, "Unable to open file %s", file);     	   error( buf);     	   return(0);   	};   - 	/*  read the records, analyze and operate */   +   	while ( fgets( buf, BUFLEN, fd) != 0 ) {      ,      	    analyze_line( buf, &book, &name );E /*     	    bookcount += do_book( book, name, op, level+1);        */ E /*          recursing for books is grossly inefficient... optimize */        	    if( book->shelf == 1 ) 9 		bookcount += do_book( book, name, op, level+1);                      else {* 		if( op == OP_SELECT) book->selected = 1;+  		if( op == OP_DESEL ) book->selected = 0;  		++bookcount; 	    };      	};    	fclose( fd);    	return( bookcount);    };   N /* this is what happens if do_book is called for a single book. This should be    rairly rare */     +    if( op == OP_SELECT) book->selected = 1; +    if( op == OP_DESEL ) book->selected = 0;     return(1);    };  