#
#  MMS file to build Jed  (Thanks to Hunter Goatley)
#
.IFDEF __MATTS_MMS__
.ELSE
EXE = .EXE
OBJ = .OBJ
.ENDIF

.IFDEF __ALPHA__
CC = CC/STANDARD=VAXC
OPTFILE =
OPTIONS =
.ELSE
OPTFILE = ,VAXCRTL.OPT
OPTIONS = $(OPTFILE)/OPTIONS
.ENDIF

.IFDEF __DEBUG__
CFLAGS = $(CFLAGS)/DEBUG/NOOPTIMIZE
LINKFLAGS = $(LINKFLAGS)/DEBUG
.ELSE
LINKFLAGS = $(LINKFLAGS)/NOTRACE
.ENDIF

.IFDEF SLANG_OLB
.ELSE
SLANG_DIR = [-.SLANG095-2]
SLANG_OLB = $(SLANG_DIR)SLANG$(OLB)
.ENDIF

CFLAGS = $(CFLAGS)/DEFINE=(HAS_MEMCPY,HAS_MEMSET,HAS_MEMCMP,JED)/INCLUDE=$(SLANG_DIR)

OBJS =	BUFFER$(OBJ),CMDS$(OBJ),MISC$(OBJ),FILE$(OBJ),MAIN$(OBJ),-
	DISPLAY$(OBJ),INS$(OBJ),SIG$(OBJ),SYSDEP$(OBJ),SCREEN$(OBJ),-
	PASTE$(OBJ),LEDIT$(OBJ),LINE$(OBJ),VTERM$(OBJ),SEARCH$(OBJ),-
	TEXT$(OBJ),KEYMAP$(OBJ),REPLACE$(OBJ),WINDOW$(OBJ),-
	UNDO$(OBJ),MEM$(OBJ),VFILE$(OBJ),INTRIN$(OBJ),VMSMAIL$(OBJ)

HFILES = BUFFER.H,CMDS.H,DISPLAY.H,FILE.H,INS.H,KEYMAP.H,LEDIT.H,LINE.H,-
         MISC.H,PASTE.H,SCREEN.H,SEARCH.H,SIG.H,SYSDEP.H,TEXT.H,VTERM.H,-
         REPLACE.H,WINDOW.H,UNDO.H,MEM.H

JED$(EXE) : JED$(OLB)($(OBJS))$(OPTFILE),$(SLANG_OLB)
        $(LINK)$(LINKFLAGS) JED$(OLB)/INCLUDE=main/LIBRARY$(OPTIONS),-
		$(SLANG_OLB)/LIBRARY

#
#  Most modules depend on most of the .H files, so I'm going to be lazy
#  and just make them all depend on all of them.
#
SYSDEP$(OBJ) :	SYSDEP.C,VMS.C

$(OBJS) : $(HFILES)


#
#  Build the linker options file for OpenVMS VAX and VAX C.
#
VAXCRTL.OPT :
        @ open/write tmp vaxcrtl.opt
        @ write tmp "SYS$SHARE:VAXCRTL.EXE/SHARE"
        @ close tmp
