%
%  Fortran mode for jed
%
%   Loading this file, then executing 'fortran' will start fortran mode
%   on the current buffer.  The only keys that get remapped are:
%     ^M (return)   which runs the fortan newline command
%     ^I (tab) which indents the current line
%     ^[; (escape semicolon) runs the fortran comment command
%     ^[: (escape colon) runs fortran uncomment command
%     ^[^M : start a continuation line

. [ForContChar]  "&" =ForContChar       % default continuation char


% gotobeginning of line and skip past continuation char
. (
.    bol
.    "0-9\t " skip_chars
.    ForContChar skip_chars skip_white
. ) forskiplab
   
% computes fortran indent
. ( 
.    [col] 7 =col    % at top of buffer it should be 7 n'est pas?
.    [case] CASE_SEARCH =case
.    0 =CASE_SEARCH
.    push_spot
.    {1 up}
.    {
.      forskiplab
.      what_column =col
     
.      { "do " looking_at } 
.      { "if " looking_at "if(" looking_at or
.        { "then" ffind {col 2 - =col} !if 1} {0} else }
.      { "else" looking_at }
.      orelse { col 2 + =col } if
     
.      {eolp}{bolp} orelse {break} !if
.    } while
  
  % now check current line
.   pop_spot
.   push_spot
.   forskiplab
  
.   { "end" looking_at } {"continue" looking_at} {"else" looking_at} orelse
.   { col 2 - =col } if
  
.   col 7 < { 7 =col} if
.   pop_spot
.   col
.   case =CASE_SEARCH
. ) for_get_ind

% used below-- skips range 
% assumes we are after the label or continuation char 
% and indents the rest to goal
. (  [goal] =goal
   
.    "0-9" skip_chars
.    trim
.    ForContChar looking_at
.      {  6 what_column - { insert_single_space } loop } if
.    ForContChar skip_chars trim
.    goal what_column - { insert_single_space } loop
. ) for_ToughInd



% fortran indent routine
. (
.   [col ch n goal] 
.   push_spot
.   for_get_ind =goal
.   bol skip_white
.   what_column =col
.   what_char char =ch 
.     {
.       ch isdigit                  % label
. 	{ 
. 	   col 6 >= {bol trim insert_single_space} if
. 	   goal for_ToughInd
. 	   1
. 	} { 0 } else
.     }
.     {
.       ch ForContChar strcmp                % continuation character
.         { 0 }
. 	{ 
. 	   col 6 == { bol trim "     " insert } !if 
. 	   goal for_ToughInd
. 	   1
. 	} else
.     }
.     { % special cases handled above already
.       bolp { eolp {1} {goal} else} {what_column} else =col
.       goal col ==
.         {
. 	   bol trim goal 1 - {insert_single_space} loop
. 	} !if	     
.       1
.     }  orelse pop
.     bol skip_white eolp {trim} !if
.     pop_spot
.     skip_white
. ) for_indent


. (
.    for_indent
   % ins space too in case this is called from middle of line
.    newline insert_single_space
.    push_spot
.    1 up
.      { 
.        eol trim
.        what_column 72 >
.          { 
. 	   bol skip_white 
. 	   bolp {"Line exceeds 72 columns." message } !if
. 	 } if
.      } if
.    pop_spot	 
.    for_indent 
. ) for_newline

. ( for_newline ForContChar insert for_indent ) for_cont_newline


%
%   electric labels
%
. (
.    [ch col]  LAST_CHAR char =ch
.    ch insert
.    push_spot
.    bol skip_white  % test for comment
.    bolp {pop_spot} {"0-9" skip_chars trim pop_spot for_indent} else
. ) for_elabel


% fortran comment/uncomment functions
. ( 
.   bol " \t0-9" skip_chars
.   bolp eolp not and
. ) is_for_comm

. ( 
.   push_spot
.   is_for_comm {bol eolp {del} !if} if
.   for_indent
.   pop_spot
.   1 down pop
. ) for_uncomment

. ( 
.   push_spot
.   is_for_comm {bol "C " insert} !if
.   pop_spot
.   1 down pop
. ) for_comment


%
% main entry point into the fortran mode
%

. "Fortran_Mode" is_defined 
.    {  
.       [Fortran_Mode] "Fortran" =Fortran_Mode   % it is now
.       "Fortran" make_keymap
.       "for_newline" "^M" Fortran_Mode definekey
.       "for_indent" "^I" Fortran_Mode definekey
.       "for_comment" "^[;" Fortran_Mode definekey
.       "for_uncomment" "^[:" Fortran_Mode definekey
.       "for_cont_newline"  "^[^M"  Fortran_Mode definekey
.       "self_insert_cmd" "'" Fortran_Mode definekey
.       "self_insert_cmd" "\"" Fortran_Mode definekey
.       0 9 1 { "for_elabel" exch string Fortran_Mode definekey } _for
.    }
.   !if


%%% Mode designed for the purpose of editing FORTRAN files.
%%% After the mode is loaded, the hook 'fortran_hook' is called.
%%% Useful functions include
%%% 
%%%  Function:                    Default Binding:
%%%   for_indent                    TAB
%%%   for_newline                   RETURN  
%%%     indents current line, inserts newline and indents it.
%%%   for_cont_newline              ESC RETURN
%%%     indents current line, and creates a continuation line on next line.
%%%   for_comment                   ESC ;
%%%     comments out current line
%%%   for_uncomment                 ESC :
%%%     uncomments current line
%%%   for_elabel                    0-9
%%%     Generates a label for current line or simply inserts a digit.
%%%  
%%% Variables include:
%%%   ForContChar   --- character used as a continuation character.  By default
%%%     is value is "&"
. (
.    [f]  "Fortran" =f
.    f use_keymap
.    f 4 setmode
.    "fortran_hook" runhooks
. ) fortran
