%%
%%  Ispell interface
%%

define ispell()
{
   variable ibuf, buf, file, letters;
   variable word, cmd, p, word, num, n, new_word;
   
   file = "/tmp/ispell_jed";
   letters = "a-zA-Z";
   
   ibuf = "*ispell*";
   buf = whatbuf();
   
   skip_chars(letters); bskip_chars(letters); push_mark(); push_mark();

   n = POINT;
   skip_chars(letters);
   if (POINT == n)
     {
	pop_mark(0); pop_mark(0);
	return;
     }
   
   word = bufsubstr();
   
   pipe_region(strcat("/usr/local/bin/ispell -a > ", file));
   setbuf(ibuf); erase_buffer();
   insert_file(file); pop();
   
   %%
   %% parse output
   %%
   bob();
   if (looking_at_char('@'))   % ispell header
     {
	push_mark();
	eol();
	go_right(1);
	del_region();
     }
   
   if (looking_at_char('*') or looking_at_char('+'))
     {
	message ("Correct");   % '+' ==> is derived from
	return;
     }
   
   if (looking_at_char('#')) return (message("No clue."));
   
   
   del(); trim(); eol(); trim(); bol();
   if (ffind(":"))
     {
	skip_chars(":\t ");
	push_mark();
	bol();
	del_region();
     }
   
	
   
   
   insert ("(0) ");
   n = 1;
   while (ffind(" "))
     {
	trim(); newline();
	insert_char('(');
	insert(string(n));
	insert_char(')');
	insert_single_space();
	++n;
     } 
   
   bob();
   pop2buf(buf);
   pop2buf(ibuf);
   set_buffer_modified_flag(0);
   num = read_mini("Enter choice. (^G to abort)", "0", Null_String);
   num = strcat(strcat("(", num), ")");
   
   if (fsearch(num))
     {
	ffind(" "); pop();  trim();
	push_mark(); eol(); trim(); new_word = bufsubstr();
	set_buffer_modified_flag(0);
	pop2buf(buf);
	bskip_chars(letters); push_mark();
	skip_chars(letters); del_region();
	insert(new_word);
     }
   else pop2buf(buf);
   delbuf(ibuf);
}

