/*
 *  Copyright (c) 1992, 1993 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#ifndef _JED_KEYMAP_H_
#define _JED_KEYMAP_H_  
/* Jed Keymap routines.
    
   The main problem here is how to associate a sequence of characters to a
   given function in as fast a way as possible.  In addition, I require that
   the procedure be memory efficient as well as allowing the user the
   flexability to redefine the keys and add new keymaps.

   To do this, I define a key map to be an array of keys.  There may be many
   keymaps (global, local, etc...).    A key structure is defined */
   
#include "malloc.h"
/* VOID defined */

/* Think about the overhead of malloc str below.  With a malloc we have
   4 bytes for pointer, 8 bytes overhead + strlen(str) + 1 >= 13 */
typedef struct Key_Type
  {
     unsigned char str[13];	       /* key sequence */
     VOID *f;			       /* function to invoke */
     char type;			       /* type of function */
     struct Key_Type *next;	       /* */
  }
Key_Type;

#define F_INTERPRET 0x01
#define F_INTRINSIC 0x02


extern Key_Type Global_Map[128];
extern Key_Type *Mini_Map;

extern void init_keymaps(void);
extern void define_key(char *, char *, Key_Type *);
extern void undefine_key(char *, Key_Type *);
extern void define_key1(char *, VOID *, char, Key_Type *);
extern int digit_arg(void);
extern void do_jed(void);
extern void jed(void);
extern int do_key(char);
extern int kbd_quit(void);
extern Key_Type *copy_keymap(Key_Type *);
extern VOID *Last_Key_Function;
extern int *Repeat_Factor;
extern char *find_key(int *);
extern char *what_keymap(void);
extern int which_key(char *);
extern Key_Type *find_keymap(char *);
extern Key_Type *create_keymap(char *);
extern void use_keymap(char *);
extern VOID *find_function(char *);
extern void set_abort_char(int *);
extern int next_function_list(char *);
extern int open_function_list(char *);

extern char Key_Buffer[];
extern char *Key_Bufferp;
extern int Key_TimeOut_Flag;
extern char *Read_This_Character;      /* alternate keyboard buffer */
extern void add_to_completion(char *);
extern int is_internal(char *);
#endif

