% Mail for VMS and Unix systems
%
% On VMS, this uses callable mail interface.  
% For Unix, uses /usr/ucb/mail
%
% Calls mailhook if defined.  "mail_hook" can either load a file
% to override some of the functions here.  This is because one cannot
% define a function from within a function unless one writes the function
% as a string and evals the string.  For example:
%
%  ( "( [x y] =y =x x y + ) sum" eval ) create_sum_function
%


#UNIX
%%% University of Calififornia, Berkeley mail program
%%% "/usr/ucb/mail" on most unix, "/usr/sbin/Mail" on others
. [UCB_Mailer] "/usr/ucb/mail" =UCB_Mailer

. UCB_Mailer file_status 1 != 
.   {
.     "/usr/sbin/Mail" =UCB_Mailer 
.     UCB_Mailer file_status 1 !=
.       {
.          "UCB Mail program not found!" error
.       } if
.   }
.  if
  
. (
.   [subj to] =subj =to
.   UCB_Mailer " -s \"" strcat subj strcat "\" "  strcat to strcat 
.   pipe_region
. ) unix_send_mail
#end


. (
.   [mail_cmd to subj beg]  Null_String =subj Null_String =to
  
.    push_spot
.    bob
   
.    "---text follows this line---" fsearch
.      {
.        pop_spot
.        "Failed to find text divider." error
.      } !if

.    whatline =beg 
.    bob
.    beg 
.    {
.        bol "To:" looking_at {
.          3 right pop
. 	 push_mark eol bufsubstr =to
.        } if
.        bol "Subject:" looking_at {
.          8 right pop
. 	 push_mark eol bufsubstr =subj
.        } if
.        1 down pop
.     } loop
    
.    to strlen { pop_spot "Bad To: field." error } !if
      
.    beg goto_line
.    1 down { pop_spot "No message!" error } !if
   
.    push_mark
.    eob
.    "Sending..." flush
   
#UNIX
.    to subj unix_send_mail
#end
#VMS
.    narrow
.    to subj vms_send_mail
.    widen
#end
.    {
.       "Sending...done"  message
.       0 set_buffer_modified_flag
.    } {
.       "No message sent." message
.    } else
   
.    pop_spot
   
. ) send    "send" add_completion


define mail()
{
   variable mail_buf, old, mail_map, status;
   mail_buf = "*mail*";
   
   mail_map = "mail_map";
   
   old = bufferp(mail_buf);
   pop2buf(mail_buf);
   
   %% if buffer is not old, turn autosave on
   if (old == 0)
     {
	getbuf_info(); pop(); 
	setbuf_info(2);
     }
   else
     {
	status = getbuf_info() & 1; pop(); pop(); pop();
	if (status) return();
     }
   
   erase_buffer();
   text_mode();
   insert("To: \nSubject: \n---text follows this line---\n");
   bob(); eol();
   set_buffer_modified_flag(0);
   set_buffer_undo(1);
   
   if (keymap_p(mail_map) == 0) make_keymap(mail_map);
   use_keymap(mail_map);
   
   runhooks("mail_hook");
}

