#ifndef _DAVIS_MALLOC_H__
#define _DAVIS_MALLOC_H__

/* system specific malloc prototypes and macros. */

#ifdef msdos
#  include <alloc.h>
#  define VOID void
#ifdef MALLOC_DEBUG
    extern void far *malloc_debug(unsigned long);
    extern void far *realloc_debug(void far *, unsigned long);
    extern void far *calloc_debug(unsigned long, unsigned long);
    extern void free_debug(void far *);
#   define MALLOC(x)  malloc_debug((unsigned long)(x))
#   define FREE(x)  free_debug((void far *)(x))
#   define REALLOC(x, y)  realloc_debug((void far *) (x), (unsigned long) (y))
#   define CALLOC(x, y)  calloc_debug((unsigned long) (x), (unsigned long) (y))
#else
#  include <alloc.h>
#  define FREE(buf)  farfree((void far *)(buf))
#  define MALLOC(x) farmalloc((unsigned long) (x))
#  define REALLOC(buf, n) farrealloc((void far *) (buf), (unsigned long) (n))
#  define CALLOC(n, m) farcalloc((unsigned long) (n), (unsigned long) (m))
#endif
#else
#  ifndef VMS
#    ifndef sequent
#    ifndef ISC
#      include <malloc.h>
#    endif
#    endif
#  endif
#  define VOID unsigned char
#  define FREE(p) free((VOID *)(p))
#  define MALLOC malloc
#  define REALLOC realloc
#  define CALLOC calloc
#endif


/* _DAVIS_MALLOC_H__ */
#endif 
