%
%  Example of menus for JED.  This is designed to aid in learning
%  the editor since after a menu item has been chosen, the user is 
%  informed of the keybinding of the function.
%


. (
.   [list] =list
.   [i cmd] 0 =i
.   [s] Null_String =s
  
.   {
.      list i ',' extract_element =cmd
     
.      cmd strlen {break} !if
.      i {s ", " strcat =s} if
.      s 
.      "(" i string strcat ")" strcat
.      cmd strcat
.      strcat =s
.      ++i
.    } forever
   
.    s
. ) menu_build_display_string

. ( [list] =list
.   [i] 
.   0 =i
.   { list i ',' extract_element strlen {break} !if
.     ++i
.   } forever
.   i 1 -
. ) menu_list_length

. [Menu_Last_Cmd]

variable Menu_Abort;  Menu_Abort = 0;

define menu_select_cmd (s_list, cmd_list)
{
   variable cmd, i, s, n;
   i = 0;
  
   n = menu_list_length (s_list);
  
   s = strcat ("Menu: ", menu_build_display_string(s_list));
   
   
   do
     {
	Menu_Abort = 0;

	forever 
	  {
	     flush(s);
	     i = getkey();
	     if (i == 7) call ("kbd_quit");
	     if (i == ' ')
	       {
		  Menu_Abort = 1;
		  return;
	       }

	     i -= '0';
  
	     if ((i >= 0) and (i <= n)) break;
    

	     beep();
	     flush_input();
	     flush("Pick a number or press Ctrl-G to abort or SPACE to go back.");
	     pop(input_pending(20));
	  }
   
	cmd = extract_element(cmd_list, i, ',');
  
	if (int (substr(cmd, 1, 1)) == '@')
	  {	
	     Menu_Last_Cmd = substr(cmd, 2, strlen(cmd));
	     call (Menu_Last_Cmd);
	  }
	else
	  {
	     Menu_Last_Cmd = cmd;
	     eval(cmd);
	  }
     }
   while(Menu_Abort);
}

. (
.   "One window,Split Window,Other Window,Del Window,Redraw"
.   "@one_window,@split_window,@other_window,@delete_window,@redraw"
.   menu_select_cmd
. ) menu_window_cmds

. (
.   "Search Forward,Search Backward,Replace"
.   "@search_forward,@search_backward,@replace"
.   menu_select_cmd
. ) search_replace

. (
.   "Delete Char,Delete Word"
.   "del,@delete_word"
.   menu_select_cmd
. ) menu_deletion_cmd


. (
.   "Deleting,Begin Region,Cut Region,Copy Region,Paste"
.   "menu_deletion_cmd,@set_mark_cmd,@kill_region,@copy_region,@yank"
.   menu_select_cmd
. ) menu_cut_paste


. (
.   "Page Up,Page Down,Top,Bottom,Page Left,Page Right"
.   "@page_up,@page_down,@beg_of_buffer,@end_of_buffer,@scroll_right,@scroll_left"
.   menu_select_cmd
. ) menu_movement


. ( "Search/Replace,Moving around,Cut/Paste,Undo,Formatting"
.   "search_replace,menu_movement,menu_cut_paste,@undo,@format_paragraph"
.   menu_select_cmd 
. ) menu_basics

. ( 
.   "Text Mode,C Mode,Fortran,Tog Overwrite,Tog readonly"
.   "text_mode,c_mode,fortran,toggle_overwrite,toggle_readonly"
.   menu_select_cmd
. ) menu_buffer_modes

. ( 
.   "Kill Buffer,Switch To Buffer,List Buffers,Set buffer modes"
.   "@kill_buffer,@switch_to_buffer,list_buffers,menu_buffer_modes"
.   menu_select_cmd
. ) menu_buffers

. ( 
.   "Read File,Write File,Save Buffers,Insert File"
.   "@find_file,@write_buffer,@save_buffers,@insert_file"
.   menu_select_cmd
. ) menu_files


. (
.   "Pop up help,Browse Documentation,Show Key,Where is Command"
.   "help,info_mode,showkey,where_is"
.   menu_select_cmd
. ) menu_help

. (
.   "compose mail,send mail,ispell,shell command,Suspend"
.   "mail,send,ispell,do_shell_cmd,@sys_spawn_cmd"
.   menu_select_cmd
. ) menu_misc


. (
.   [n key len next nlen]
.   "Basic,Files,Buffers,Windows,Help,Misc,Exit"
.   "menu_basics,menu_files,menu_buffers,menu_window_cmds,menu_help,menu_misc,@exit_jed"
.   menu_select_cmd
     %
     %  Show user keybinding of the function.
     %  The problem with this is that any function which leaves a message
     %  in the message buffer, the message will be destroyed.  Here I 
     %  update screen and sleep for a second before continuing.  Menus are
     %  intrinsically inefficient anyway.
     %
  
.   MESSAGE_BUFFER strlen { 0 update 20 input_pending pop } if

.   Menu_Abort { " " flush return } if
.   Menu_Last_Cmd which_key =n
.   n { 
.       =key --n
.       key strlen =len
.       n {
.           =next
. 	  next strlen =nlen
. 	  nlen len < { nlen =len next =key } if
.         } loop

.       Menu_Last_Cmd " is on key " strcat key expand_keystring strcat
.     }
.     {Menu_Last_Cmd " is not on any keys." strcat}
.   else
.   message

. ) menu_main_cmds  

