%
%  Recall previous commands in MiniBuffer
%

variable Prev_Minibuffer; Prev_Minibuffer = " *mini*";
variable In_Mini_Flag; In_Mini_Flag = 0;

if (bufferp(Prev_Minibuffer) == 0)
{ 
   whatbuf();                   % used by setbuf below
   % to minimize fragmentation, alloc 16 lines now
   setbuf(Prev_Minibuffer);
   loop(60) insert(" ");       % 60 chars is probably ok
   loop(15) double_line();
   bob();
   setbuf();
} 


define mini_use_this_line()
{
  bol(); if (eobp()) return;
  push_mark(); eol(); bufsubstr();
  setbuf(" <mini>");
  bol(); push_mark(); eol(); del_region();
  insert(()); 
   % trim();
}

define  next_mini_command()
{
   setbuf(Prev_Minibuffer);
   if (In_Mini_Flag)
     {
       !if (down(1))
         {
	   message("End of list");
	   beep();
	   return;
	 }
     }
   else 
     {
       In_Mini_Flag = 1;
       eob();
     }
   bol(); mini_use_this_line();
}

define prev_mini_command()
{
   setbuf(Prev_Minibuffer);
   if (In_Mini_Flag) 
     {
       !if (up(1)) {message("Top of List."); beep(); return;}
     }
   else { In_Mini_Flag = 1; eob(); }

   bol(); mini_use_this_line();
}

define mini_exit_minibuffer()
{
   bol(); skip_white();
   !if (eolp())
     {
        bol(); push_mark(); eol(); bufsubstr();
	setbuf(Prev_Minibuffer);
	%% lose one off top
	bob(); push_mark(); eol(); go_right(1); del_region();
	eob(); newline();
	insert(()); bol();
	
	%loop (60 - right(60)) insert(" ");    %% keep 60 chars
	setbuf(" <mini>");                    %% to avoid fragmentation
     } 
   call("exit_mini");
   In_Mini_Flag = 0;
}



