%%
%%  rmail for jed
%%  

variable InBox;  InBox = getenv("MAIL");

% for now I just delete headers, later I will hide them
define rmail_delete_headers()
{
   set_readonly(0);
   bob();
   while (bol(), not(eolp()))
     {
	if (looking_at("From") 
	    or looking_at ("Subj")
	    or looking_at ("Sender")
	    or looking_at ("In-Rep")
	    or looking_at ("Date"))
	  {
	     !if (down(1)) return;
	     continue;
	  }
	push_mark();
	eol(); right(1); pop();
	del_region();
     }
}

define rmail_narrow()
{
   variable from, c;  
   from = "From ";
   c = CASE_SEARCH;
   CASE_SEARCH = 1;
   if (bol_fsearch(from)) pop(up(1)); else eob();
   push_mark();
   !if (bol_bsearch(from)) bob();
   narrow();
   rmail_delete_headers();
   set_buffer_modified_flag(0);
   CASE_SEARCH = c;
}


define rmail_next()
{
   eob();
   widen();
   down(1); pop();
   rmail_narrow();
   set_readonly(1);
}

define rmail_prev()
{
   bob();
   widen();
   pop(up(1));
   rmail_narrow();
   set_readonly(1);
}

define rmail_end_edit()
{
   use_keymap("*rmail*");
   set_readonly(1);
}

define rmail_edit()
{
   use_keymap("global");
   text_mode();
   setkey("rmail_end_edit", "^C^C");
   set_readonly(0);
}

define rmail()
{
   variable km, buf;
   buf = whatbuf();
   km = "*rmail*";
   !if (keymap_p(km))
     {
	make_keymap(km);
	_for (' ', 127, 1) { undefinekey (char(()), km) }
	
	definekey("rmail_next",	"n", km );
	definekey("rmail_forward",	"f", km );
	definekey("rmail_prev",	"p", km );
	definekey("reply",	"r", km );
	definekey("page_down", " ", km );
	definekey("mail",	"m", km);
	definekey("rmail_edit", "w", km );
	definekey("page_up", "^?", km );
	definekey("rmail", "g",	km);
     } 
   
   if (find_file(InBox))
     { 
	push_spot();
	use_keymap(km);
	rmail_narrow();
	pop_spot();
	set_readonly(1);
     }
   else sw2buf(buf);
}


define rmail_forward()
{
   variable cbuf;
   cbuf = whatbuf();
   mail();
   eob();
   insbuf(cbuf);
   bob(); eol();
}
